/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang.StringUtils;

public final class Assert {
    private static final int INPUT_MAX_WIDTH = 30;

    private Assert() {
    }

    public static void assertTrue(Object input, Predicate predicate) throws IllegalArgumentException {
        if (predicate.evaluate(input)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Predicate rejected input [predicate=");
        builder.append(predicate);
        builder.append(", input=");
        builder.append(StringUtils.abbreviate((String)String.valueOf(input), (int)30));
        builder.append("]");
        throw new IllegalArgumentException(builder.toString());
    }

    public static void assertTrue(boolean bool) throws IllegalArgumentException {
        Assert.assertTrue(bool, "Value cannot be false", new Object[0]);
    }

    public static void assertTrue(boolean bool, String message, Object ... args) throws IllegalArgumentException {
        if (bool) {
            return;
        }
        if (args != null && args.length > 0) {
            throw new IllegalArgumentException(MessageFormat.format(message, args));
        }
        throw new IllegalArgumentException(message);
    }

    public static void assertFalse(boolean bool) throws IllegalArgumentException {
        Assert.assertFalse(bool, "Value cannot be true", new Object[0]);
    }

    public static void assertFalse(boolean bool, String message, Object ... args) throws IllegalArgumentException {
        if (!bool) {
            return;
        }
        if (args != null && args.length > 0) {
            throw new IllegalArgumentException(MessageFormat.format(message, args));
        }
        throw new IllegalArgumentException(message);
    }

    public static void assertFalse(Object input, Predicate predicate) throws IllegalArgumentException {
        if (!predicate.evaluate(input)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Predicate didn't rejected input [predicate=");
        builder.append(predicate);
        builder.append(", input=");
        builder.append(StringUtils.abbreviate((String)String.valueOf(input), (int)30));
        builder.append("]");
        throw new IllegalArgumentException(builder.toString());
    }

    public static void assertNotNullOrEmpty(Collection<?> collection) throws IllegalArgumentException {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Collection cannot be null or empty");
        }
    }

    public static void assertNotNullOrEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNullOrEmpty(Object[] array) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null or empty");
        }
    }

    public static void assertNotNullOrEmpty(Object[] array, String message) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNullOrEmpty(Map<?, ?> map) throws IllegalArgumentException {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Map cannot be null or empty");
        }
    }

    public static void assertNotNullOrEmpty(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(String input) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)input)) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
    }

    public static void assertNotEmpty(String input, String message) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)input)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotBlank(String input) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)input)) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
    }

    public static void assertNotBlank(String input, String message) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)input)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNull(Object input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
    }

    public static void assertNotNull(Object input, String message) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNull(Object input) throws IllegalArgumentException {
        if (input != null) {
            throw new IllegalArgumentException("Input must be null");
        }
    }

    public static void assertNull(Object input, String message) throws IllegalArgumentException {
        if (input != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertGreaterZero(Integer value) throws IllegalArgumentException {
        Assert.assertGreaterZero(value, "Value must be greater than 0");
    }

    public static void assertGreaterZero(Double value) throws IllegalArgumentException {
        Assert.assertGreaterZero(value, "Value must be greater than 0");
    }

    public static void assertGreaterZero(Double value, String message) throws IllegalArgumentException {
        if (value == null || value <= 0.0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertGreaterZero(Integer value, String message) throws IllegalArgumentException {
        if (value == null || value <= 0) {
            throw new IllegalArgumentException(message);
        }
    }
}

