/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.kinesis.EFOKinesisReader;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIOOptions;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReader;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.ShardListingUtils;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.kinesis.common.KinesisClientUtil;

class KinesisSource
extends UnboundedSource<KinesisRecord, KinesisReaderCheckpoint> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisSource.class);
    private final  @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec;
    private final @Nullable @UnknownKeyFor @Initialized KinesisReaderCheckpoint initialCheckpoint;

    KinesisSource( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read read) {
        this(read, null);
    }

    KinesisSource( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @Nullable @UnknownKeyFor @Initialized KinesisReaderCheckpoint initialCheckpoint) {
        this.spec = (KinesisIO.Read)((Object)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((Object)spec)));
        this.initialCheckpoint = initialCheckpoint;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        KinesisReaderCheckpoint checkpoint;
        ArrayList<KinesisSource> sources = new ArrayList<KinesisSource>();
        if (this.initialCheckpoint != null) {
            checkpoint = this.initialCheckpoint;
        } else {
            AwsOptions awsOptions = (AwsOptions)options.as(AwsOptions.class);
            ClientConfiguration config = this.spec.getClientConfiguration();
            try (KinesisClient client = (KinesisClient)ClientBuilderFactory.buildClient(awsOptions, KinesisClient.builder(), config);){
                checkpoint = this.generateInitCheckpoint(this.spec, client);
            }
        }
        for (KinesisReaderCheckpoint partition : checkpoint.splitInto(desiredNumSplits)) {
            sources.add(new KinesisSource(this.spec, partition));
        }
        return sources;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized KinesisRecord> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized KinesisReaderCheckpoint checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
        KinesisReaderCheckpoint initCheckpoint;
        if (checkpointMark != null) {
            LOG.info("Got checkpoint mark {}", (Object)checkpointMark);
            initCheckpoint = checkpointMark;
        } else {
            try {
                LOG.info("No checkpointMark specified, fall back to initial {}", (Object)this.initialCheckpoint);
                initCheckpoint = (KinesisReaderCheckpoint)Preconditions.checkArgumentNotNull((Object)this.initialCheckpoint);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.initReader(this.spec, options, initCheckpoint, this);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint> getCheckpointMarkCoder() {
        return SerializableCoder.of(KinesisReaderCheckpoint.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KinesisRecord> getOutputCoder() {
        return KinesisRecordCoder.of();
    }

    static @Nullable @UnknownKeyFor @Initialized String resolveConsumerArn( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        String streamName = (String)Preconditions.checkArgumentNotNull((Object)spec.getStreamName());
        KinesisIOOptions sourceOptions = (KinesisIOOptions)options.as(KinesisIOOptions.class);
        Map<String, String> streamToArnMapping = sourceOptions.getKinesisIOConsumerArns();
        String consumerArn = streamToArnMapping.containsKey(streamName) ? streamToArnMapping.get(streamName) : spec.getConsumerArn();
        return consumerArn;
    }

    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized KinesisRecord> initReader( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint checkpointMark, @UnknownKeyFor @NonNull @Initialized KinesisSource source) {
        String consumerArn = KinesisSource.resolveConsumerArn(spec, options);
        if (consumerArn == null) {
            LOG.info("Creating new reader using {}", (Object)checkpointMark);
            return new KinesisReader(spec, this.createSimplifiedKinesisClient(options), checkpointMark, source);
        }
        LOG.info("Creating new EFO reader using {}", (Object)checkpointMark);
        return new EFOKinesisReader(spec, consumerArn, KinesisSource.createAsyncClient(spec, options), checkpointMark, source);
    }

    private @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient createSimplifiedKinesisClient(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        AwsOptions awsOptions = (AwsOptions)options.as(AwsOptions.class);
        ClientConfiguration config = this.spec.getClientConfiguration();
        Supplier<KinesisClient> kinesisSupplier = () -> (KinesisClient)ClientBuilderFactory.buildClient(awsOptions, KinesisClient.builder(), config);
        Supplier<CloudWatchClient> cloudWatchSupplier = () -> (CloudWatchClient)ClientBuilderFactory.buildClient(awsOptions, CloudWatchClient.builder(), config);
        return new SimplifiedKinesisClient(kinesisSupplier, cloudWatchSupplier, this.spec.getRequestRecordsLimit());
    }

    private static @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient createAsyncClient( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        AwsOptions awsOptions = (AwsOptions)options.as(AwsOptions.class);
        KinesisAsyncClientBuilder builder = KinesisClientUtil.adjustKinesisClientBuilder((KinesisAsyncClientBuilder)KinesisAsyncClient.builder());
        return (KinesisAsyncClient)ClientBuilderFactory.buildClient(awsOptions, builder, spec.getClientConfiguration());
    }

    private @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint generateInitCheckpoint( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized KinesisClient kinesis) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        String stream = (String)Preconditions.checkArgumentNotNull((Object)spec.getStreamName());
        StartingPoint startingPoint = (StartingPoint)Preconditions.checkArgumentNotNull((Object)spec.getInitialPosition());
        List<Shard> streamShards = ShardListingUtils.listShardsAtPoint(kinesis, stream, startingPoint);
        LOG.info("Creating a checkpoint with following shards {} at {}", streamShards, (Object)startingPoint);
        return new KinesisReaderCheckpoint(streamShards.stream().map(shard -> new ShardCheckpoint(stream, shard.shardId(), startingPoint)).collect(Collectors.toList()));
    }
}

