/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkStreamingPortablePipelineTranslator;
import org.apache.beam.runners.flink.adapter.BeamAdapterCoderUtils;
import org.apache.beam.runners.flink.adapter.BeamAdapterUtils;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class BeamFlinkDataStreamAdapter {
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry = CoderRegistry.createDefault();

    public BeamFlinkDataStreamAdapter() {
        this(PipelineOptionsFactory.create());
    }

    public BeamFlinkDataStreamAdapter(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public <InputT, OutputT, CollectionT extends PCollection<? extends InputT>> @UnknownKeyFor @NonNull @Initialized DataStream<OutputT> applyBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataStream<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)output -> ImmutableMap.of((Object)"output", (Object)output), (PTransform)transform, input.getExecutionEnvironment()), "output");
    }

    public <OutputT> @UnknownKeyFor @NonNull @Initialized DataStream<OutputT> applyBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, output -> ImmutableMap.of((Object)"output", (Object)output), transform, inputs.values().stream().findAny().get().getExecutionEnvironment()), "output");
    }

    public <OutputT> @UnknownKeyFor @NonNull @Initialized DataStream<OutputT> applyBeamPTransform(@UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)output -> ImmutableMap.of((Object)"output", (Object)output), (PTransform)transform, executionEnvironment), "output");
    }

    public <InputT, CollectionT extends PCollection<? extends InputT>> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataStream<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)BeamAdapterUtils::tupleToMap, (PTransform)transform, input.getExecutionEnvironment());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, BeamAdapterUtils::tupleToMap, transform, inputs.values().stream().findAny().get().getExecutionEnvironment());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)BeamAdapterUtils::tupleToMap, (PTransform)transform, executionEnvironment);
    }

    public <InputT, CollectionT extends PCollection<? extends InputT>> void applyNoOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataStream<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)pDone -> ImmutableMap.of(), (PTransform)transform, input.getExecutionEnvironment());
    }

    public void applyNoOutputBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, pDone -> ImmutableMap.of(), transform, inputs.values().stream().findAny().get().getExecutionEnvironment());
    }

    public void applyNoOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal((Map<String, ? extends DataStream<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)pDone -> ImmutableMap.of(), (PTransform)transform, executionEnvironment);
    }

    private <BeamInputT extends PInput, BeamOutputT extends POutput> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyBeamPTransformInternal(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Pipeline, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>, BeamInputT> toBeamInput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<BeamOutputT, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> fromBeamOutput, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super BeamInputT, BeamOutputT> transform, @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment) {
        return BeamAdapterUtils.applyBeamPTransformInternal(inputs, toBeamInput, fromBeamOutput, transform, executionEnvironment, false, dataStream -> dataStream.getType(), this.pipelineOptions, this.coderRegistry, (flinkInputs, pipelineProto, env) -> {
            HashMap flinkOutputs = new HashMap();
            FlinkStreamingPortablePipelineTranslator translator = new FlinkStreamingPortablePipelineTranslator((Map<String, FlinkStreamingPortablePipelineTranslator.PTransformTranslator<FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext>>)ImmutableMap.of((Object)"beam:flink:internal:translation_input", this.flinkInputTranslator(flinkInputs), (Object)"beam:flink:internal:translation_output", this.flinkOutputTranslator(flinkOutputs)));
            FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext context = translator.createTranslationContext(JobInfo.create((String)"unusedJobId", (String)"unusedJobName", (String)"unusedRetrievalToken", (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)this.pipelineOptions)), (FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class), (StreamExecutionEnvironment)env);
            translator.translate(context, translator.prepareForTranslation(pipelineProto));
            return flinkOutputs;
        });
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized FlinkStreamingPortablePipelineTranslator.PTransformTranslator<@UnknownKeyFor @NonNull @Initialized FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext> flinkInputTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputMap) {
        return (id, p, context) -> {
            RunnerApi.PTransform transform = p.getComponents().getTransformsOrThrow(id);
            String inputId = transform.getSpec().getPayload().toStringUtf8();
            DataStream flinkInput = (DataStream)Preconditions.checkStateNotNull((Object)((DataStream)inputMap.get(inputId)), (Object)("missing input referenced in proto: " + inputId));
            context.addDataStream((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), flinkInput.process(new ProcessFunction<InputT, WindowedValue<InputT>>(){

                public void processElement(InputT value, /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ProcessFunction. @UnknownKeyFor @NonNull @Initialized Context ctx, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    out.collect((Object)WindowedValues.timestampedValueInGlobalWindow(value, (Instant)(ctx.timestamp() == null ? BoundedWindow.TIMESTAMP_MIN_VALUE : Instant.ofEpochMilli((long)ctx.timestamp()))));
                }
            }, BeamAdapterCoderUtils.coderToTypeInformation(WindowedValues.getFullCoder(BeamAdapterCoderUtils.typeInformationToCoder(flinkInput.getType(), this.coderRegistry), (Coder)GlobalWindow.Coder.INSTANCE), this.pipelineOptions)));
        };
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized FlinkStreamingPortablePipelineTranslator.PTransformTranslator<@UnknownKeyFor @NonNull @Initialized FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext> flinkOutputTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap) {
        return (id, p, context) -> {
            RunnerApi.PTransform transform = p.getComponents().getTransformsOrThrow(id);
            DataStream inputDataStream = context.getDataStreamOrThrow((String)Iterables.getOnlyElement(transform.getInputsMap().values()));
            String outputId = transform.getSpec().getPayload().toStringUtf8();
            Coder outputCoder = BeamAdapterCoderUtils.lookupCoder(p, (String)Iterables.getOnlyElement(transform.getInputsMap().values()));
            outputMap.put(outputId, (DataStream<?>)inputDataStream.transform("StripWindows", BeamAdapterCoderUtils.coderToTypeInformation(outputCoder, this.pipelineOptions), new UnwrapWindowOperator()));
        };
    }

    private <K, V> V getNonNull(@UnknownKeyFor @NonNull @Initialized Map<K, V> map, K key) {
        return (V)Preconditions.checkStateNotNull(map.get(Preconditions.checkArgumentNotNull(key)));
    }

    private static class UnwrapWindowOperator<@UnknownKeyFor T>
    extends AbstractStreamOperator<T>
    implements OneInputStreamOperator<WindowedValue<T>, T> {
        private UnwrapWindowOperator() {
        }

        public void processElement(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> element) {
            this.output.collect((Object)element.replace(((WindowedValue)element.getValue()).getValue(), ((WindowedValue)element.getValue()).getTimestamp().getMillis()));
        }
    }
}

