/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ProtoSchema;
import com.google.bigtable.admin.v2.UpdateSchemaBundleRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.SchemaBundle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.FieldMaskUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;

public final class UpdateSchemaBundleRequest {
    private final UpdateSchemaBundleRequest.Builder requestBuilder;
    private final String tableId;
    private final String schemaBundleId;

    public static UpdateSchemaBundleRequest of(@Nonnull SchemaBundle schemaBundle) {
        return new UpdateSchemaBundleRequest(schemaBundle.getTableId(), schemaBundle.getId(), com.google.bigtable.admin.v2.UpdateSchemaBundleRequest.newBuilder().setSchemaBundle(schemaBundle.toProto()));
    }

    public static UpdateSchemaBundleRequest of(@Nonnull String tableId, @Nonnull String schemaBundleId) {
        return new UpdateSchemaBundleRequest(tableId, schemaBundleId, com.google.bigtable.admin.v2.UpdateSchemaBundleRequest.newBuilder());
    }

    private UpdateSchemaBundleRequest(@Nonnull String tableId, @Nonnull String schemaBundleId, @Nonnull UpdateSchemaBundleRequest.Builder requestBuilder) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId must be set");
        Preconditions.checkNotNull((Object)schemaBundleId, (Object)"schemaBundleId must be set");
        Preconditions.checkNotNull((Object)requestBuilder, (Object)"proto builder must be set");
        this.tableId = tableId;
        this.schemaBundleId = schemaBundleId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateSchemaBundleRequest setProtoSchemaFile(@Nonnull String protoSchemaFile) throws IOException {
        Preconditions.checkNotNull((Object)protoSchemaFile, (Object)"protoSchemaFile must be set");
        byte[] content = Files.readAllBytes(Paths.get(protoSchemaFile, new String[0]));
        return this.setProtoSchema(ByteString.copyFrom((byte[])content));
    }

    public UpdateSchemaBundleRequest setProtoSchema(@Nonnull ByteString protoSchema) throws IOException {
        Preconditions.checkNotNull((Object)protoSchema, (Object)"protoSchema must be set");
        this.requestBuilder.setSchemaBundle(com.google.bigtable.admin.v2.SchemaBundle.newBuilder().setProtoSchema(ProtoSchema.newBuilder().setProtoDescriptors(protoSchema)));
        this.updateFieldMask(2);
        return this;
    }

    public UpdateSchemaBundleRequest setIgnoreWarnings(boolean value) {
        this.requestBuilder.setIgnoreWarnings(value);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.admin.v2.SchemaBundle.class, (int[])new int[]{fieldNumber});
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union((FieldMask)this.requestBuilder.getUpdateMask(), (FieldMask)newMask, (FieldMask[])new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSchemaBundleRequest that = (UpdateSchemaBundleRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build()) && Objects.equal((Object)this.tableId, (Object)that.tableId) && Objects.equal((Object)this.schemaBundleId, (Object)that.schemaBundleId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build(), this.tableId, this.schemaBundleId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateSchemaBundleRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        this.requestBuilder.getSchemaBundleBuilder().setName(NameUtil.formatSchemaBundleName(projectId, instanceId, this.tableId, this.schemaBundleId));
        return this.requestBuilder.build();
    }
}

