/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemValue;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueDetailsPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueModifyAction;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import javax.swing.Icon;

class VSystemValue
implements VObject {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SystemValue systemValue_;
    private VObject[] detailsChildren_;
    private VObject[] children_;
    private VAction[] actions_;
    VPropertiesPane propertiesPane_;
    ErrorEventSupport errorEventSupport_;
    VObjectEventSupport objectEventSupport_;
    WorkingEventSupport workingEventSupport_;
    private static final Icon icon16_ = ResourceLoader.getIcon("VSystemValue16.gif", "System Values");
    private static final Icon icon32_ = ResourceLoader.getIcon("VSystemValue32.gif", "System Values");
    public static final String VALUE_PROPERTY = "Value";

    public VSystemValue(SystemValue systemValue) {
        this.systemValue_ = systemValue;
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.actions_ = new VAction[1];
        this.actions_[0] = new VSystemValueModifyAction(this);
        if (this.systemValue_.isReadOnly()) {
            this.actions_[0].setEnabled(false);
        }
        this.actions_[0].addErrorListener(this.errorEventSupport_);
        this.actions_[0].addVObjectListener(this.objectEventSupport_);
        this.actions_[0].addWorkingListener(this.workingEventSupport_);
        this.propertiesPane_ = new VSystemValueDetailsPropertiesPane(this, this.systemValue_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener workin1) {
        this.workingEventSupport_.addWorkingListener(workin1);
    }

    @Override
    public VAction[] getActions() {
        return this.actions_;
    }

    @Override
    public VAction getDefaultAction() {
        return null;
    }

    public String getDescription() {
        return this.systemValue_.getDescription();
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size != 32) {
            return icon16_;
        }
        return icon32_;
    }

    public String getName() {
        return this.systemValue_.getName();
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    @Override
    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return this.systemValue_.getDescription();
        }
        if (propertyIdentifier == VALUE_PROPERTY) {
            Object value = null;
            try {
                value = this.systemValue_.getValue();
            }
            catch (Exception e) {
                this.errorEventSupport_.fireError(e);
            }
            if (value != null && this.systemValue_.getType() == 4) {
                String[] valStrs = (String[])value;
                StringBuilder strBuf = new StringBuilder();
                for (int i = 0; i < valStrs.length; ++i) {
                    String temp = valStrs[i].trim();
                    if (temp.length() <= 0) continue;
                    if (strBuf.length() > 0) {
                        strBuf.append(",");
                    }
                    strBuf.append(temp);
                }
                return strBuf.toString();
            }
            return value;
        }
        return null;
    }

    @Override
    public String getText() {
        return this.systemValue_.getName();
    }

    public int getType() {
        return this.systemValue_.getType();
    }

    public Object getValue() {
        Object value = null;
        try {
            value = this.systemValue_.getValue();
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return value;
    }

    @Override
    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.systemValue_.clear();
            this.systemValue_.getValue();
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener workin1) {
        this.workingEventSupport_.removeWorkingListener(workin1);
    }

    public void setValue(Object value) {
        try {
            this.systemValue_.setValue(value);
            this.objectEventSupport_.fireObjectChanged(this);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
    }
}

