/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.AbstractValueMap;

class ArrayValueMap
extends AbstractValueMap {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private String noneString_ = null;

    public ArrayValueMap() {
    }

    public ArrayValueMap(String noneString) {
        if (noneString == null) {
            throw new NullPointerException("noneString");
        }
        this.noneString_ = noneString;
    }

    @Override
    public Object ltop(Object logicalValue) {
        if (logicalValue == null) {
            throw new NullPointerException("logicalValue");
        }
        if (!(logicalValue instanceof Object[])) {
            throw new ExtendedIllegalArgumentException("logicalValue", 2);
        }
        Object[] asArray = (Object[])logicalValue;
        StringBuilder buffer = new StringBuilder();
        if (asArray.length == 0 && this.noneString_ != null) {
            buffer.append(this.noneString_);
        } else {
            for (int i = 0; i < asArray.length; ++i) {
                if (i > 0) {
                    buffer.append(' ');
                }
                if (asArray[i] == null) {
                    throw new NullPointerException("logicalValue[" + i + "]");
                }
                buffer.append(asArray[i]);
            }
        }
        return buffer.toString();
    }
}

