/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerConnection;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ValueMap;
import java.beans.PropertyVetoException;
import java.util.Vector;

public class NetServerSession
extends Resource {
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerSession";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    private static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    private static ProgramMap getterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    private static final String ENSS_ = "qzlsenss";
    private static final String OLST0300_ = "qzlsolst_zlsl0300";
    private static final int[] INDICES_ = new int[]{0};
    public static final String CONNECTION_COUNT = "CONNECTION_COUNT";
    public static final String SESSION_TIME = "SESSION_TIME";
    public static final String FILES_OPEN_COUNT = "FILES_OPEN_COUNT";
    public static final String IDLE_TIME = "IDLE_TIME";
    public static final String IS_ENCRYPT_PASSWORD = "IS_ENCRYPT_PASSWORD";
    public static final String IS_GUEST = "IS_GUEST";
    static final String SESSION_COUNT = "SESSION_COUNT";
    public static final String USER = "USER";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    private static ProgramCallDocument staticDocument_;
    private ProgramCallDocument document_;
    private String name_;
    private ProgramAttributeGetter attributeGetter_;

    NetServerSession() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerSession(AS400 system, String name) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setName(name);
    }

    static Object computeResourceKey(AS400 system, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(NetServerSession.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(name);
        return buffer.toString();
    }

    public void end() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        NetServerSession.endSession(this.getSystem(), this.name_);
    }

    static void endSession(AS400 system, String sessionName) throws ResourceException {
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            document.setValue("qzlsenss.workstationName", sessionName);
            if (!document.callProgram(ENSS_)) {
                throw new ResourceException(document.getMessageList(ENSS_));
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when ending a session.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        super.establishConnection();
        AS400 system = this.getSystem();
        this.document_ = (ProgramCallDocument)staticDocument_.clone();
        try {
            this.document_.setSystem(system);
            this.document_.setValue("qzlsolst_zlsl0300.informationQualifier", this.name_);
            this.attributeGetter_ = new ProgramAttributeGetter(system, this.document_, getterMap_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when establishing connection.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        presentation.setFullName(this.name_);
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerSession.computeResourceKey(this.getSystem(), this.name_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeValue(Object attributeID) throws ResourceException {
        Object value;
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if ((value = super.getAttributeValue(attributeID)) == null) {
            value = this.attributeGetter_.getValue(attributeID);
        }
        return value;
    }

    public String getName() {
        return this.name_;
    }

    static ResourceList list(AS400 system) throws ResourceException {
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            document.setValue("qzlsolst_zlsl0300.informationQualifier", "*ALL");
            int expectedInfoLength = 640;
            document.setIntValue("qzlsolst_zlsl0300.lengthOfReceiverVariable", expectedInfoLength);
            NetServer.callListProgram(document, OLST0300_, true);
            int recCount = document.getIntValue("qzlsolst_zlsl0300.listInformation.recordsReturned");
            int recSize = document.getIntValue("qzlsolst_zlsl0300.listInformation.recordLength");
            Vector<NetServerSession> sessions = new Vector<NetServerSession>();
            String prefix = "qzlsolst_zlsl0300.receiverVariable.";
            int index = 0;
            int[] indices = new int[1];
            Object[] attributeIDs = openListAttributeMap_.getIDs();
            for (int i = 0; i < recCount; ++i) {
                indices[0] = i;
                String sessionName = (String)document.getValue(prefix + "workstationName", indices);
                NetServerSession session = new NetServerSession(system, sessionName);
                Object[] values = openListAttributeMap_.getValues(attributeIDs, system, document, null, indices);
                for (int ii = 0; ii < values.length; ++ii) {
                    session.initializeAttributeValue(attributeIDs[ii], values[ii]);
                }
                session.freezeProperties();
                sessions.addElement(session);
                index += recSize;
            }
            Object[] array = new NetServerSession[sessions.size()];
            sessions.copyInto(array);
            Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            return new ArrayResourceList((Resource[])array, presentation, NetServerSession.getAttributeMetaDataStatic());
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when listing sessions.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    public ResourceList listConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.listConnectionsForSession(this.getSystem(), this.name_);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        super.refreshAttributeValues();
    }

    void setName(String name) {
        this.name_ = name;
    }

    static {
        attributes_.add((Object)CONNECTION_COUNT, Integer.class, true);
        getterMap_.add((Object)CONNECTION_COUNT, OLST0300_, "receiverVariable.numberOfConnections", INDICES_);
        openListAttributeMap_.add(CONNECTION_COUNT, OLST0300_, "receiverVariable.numberOfConnections");
        attributes_.add((Object)SESSION_TIME, Integer.class, true);
        getterMap_.add((Object)SESSION_TIME, OLST0300_, "receiverVariable.sessionTime", INDICES_);
        openListAttributeMap_.add(SESSION_TIME, OLST0300_, "receiverVariable.sessionTime");
        attributes_.add((Object)FILES_OPEN_COUNT, Integer.class, true);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0300_, "receiverVariable.numberOfFilesOpen", INDICES_);
        openListAttributeMap_.add(FILES_OPEN_COUNT, OLST0300_, "receiverVariable.numberOfFilesOpen");
        attributes_.add((Object)IDLE_TIME, Integer.class, true);
        getterMap_.add((Object)IDLE_TIME, OLST0300_, "receiverVariable.idleTime", INDICES_);
        openListAttributeMap_.add(IDLE_TIME, OLST0300_, "receiverVariable.idleTime");
        attributes_.add((Object)IS_ENCRYPT_PASSWORD, Boolean.class, true);
        BooleanValueMap valueMap = new BooleanValueMap(new String[]{"0", ""}, new String[]{"1"});
        getterMap_.add((Object)IS_ENCRYPT_PASSWORD, OLST0300_, "receiverVariable.encryptedPassword", INDICES_, (ValueMap)valueMap);
        openListAttributeMap_.add((Object)IS_ENCRYPT_PASSWORD, OLST0300_, "receiverVariable.encryptedPassword", valueMap);
        attributes_.add((Object)IS_GUEST, Boolean.class, true);
        valueMap = new BooleanValueMap(new String[]{"1", ""}, new String[]{"0"});
        getterMap_.add((Object)IS_GUEST, OLST0300_, "receiverVariable.logonType", INDICES_, (ValueMap)valueMap);
        openListAttributeMap_.add((Object)IS_GUEST, OLST0300_, "receiverVariable.logonType", valueMap);
        attributes_.add((Object)SESSION_COUNT, Integer.class, true);
        getterMap_.add((Object)SESSION_COUNT, OLST0300_, "receiverVariable.numberOfSessions", INDICES_);
        openListAttributeMap_.add(SESSION_COUNT, OLST0300_, "receiverVariable.numberOfSessions");
        attributes_.add((Object)USER, String.class, true);
        getterMap_.add((Object)USER, OLST0300_, "receiverVariable.userProfileName", INDICES_);
        openListAttributeMap_.add(USER, OLST0300_, "receiverVariable.userProfileName");
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)e);
        }
    }
}

