/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class EnvironmentVariable
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int RV_ENOENT = 3025;
    static final int RV_EPERM = 3027;
    static final int RV_ENOSPC = 3404;
    static final ProgramParameter nullParameter = new ProgramParameter();
    private AS400 system_ = null;
    private transient ServiceProgramCall spc_ = null;
    private transient Converter converter_ = null;
    private String name_ = null;
    private byte[] nameBytes_ = null;
    private transient String value_ = null;
    private transient byte[] valueBytes_ = null;
    private transient int ccsid_ = 0;
    private int stringType_ = 0;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private char[] nameInCharArray_ = new char[0];

    static ServiceProgramCall setupServiceProgramCall(AS400 system) {
        if (system == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        ServiceProgramCall spc = new ServiceProgramCall(system);
        try {
            spc.setProgram("/QSYS.LIB/QP0ZSYSE.SRVPGM");
            spc.suggestThreadsafe();
            spc.setReturnValueFormat(1);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
        return spc;
    }

    static int runServiceProgram(ServiceProgramCall spc, String procedureName, ProgramParameter[] parameters, int rv1, int rv2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ServiceProgramCall serviceProgramCall = spc;
        synchronized (serviceProgramCall) {
            if (Trace.traceOn_) {
                Trace.log(3, "Calling service program procedure: " + procedureName);
            }
            try {
                spc.setProcedureName(procedureName);
                spc.setParameterList(parameters);
            }
            catch (PropertyVetoException e) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
                throw new InternalErrorException(10);
            }
            if (spc.run()) {
                int rv = spc.getIntegerReturnValue();
                if (Trace.traceOn_) {
                    Trace.log(3, "Service program procedure: " + procedureName + ", returned value: " + rv);
                }
                if (rv == 0 || rv == rv1 || rv == rv2) {
                    return rv;
                }
                if (rv == 3027) {
                    Trace.log(2, "*JOBCTL special authority required to add, change, or delete system-level environment variable.");
                    throw new AS400SecurityException(40);
                }
                Trace.log(2, "Service program return value was unexpected.");
                throw new InternalErrorException(9);
            }
            if (Trace.traceOn_) {
                Trace.log(3, "Service program procedure: " + procedureName + ", failed.");
            }
            throw new AS400Exception(spc.getMessageList());
        }
    }

    public EnvironmentVariable() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing EnvironmentVariable object.");
        }
    }

    public EnvironmentVariable(AS400 system) {
        this();
        if (Trace.traceOn_) {
            Trace.log(1, " system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public EnvironmentVariable(AS400 system, String name) {
        this(system);
        if (Trace.traceOn_) {
            Trace.log(1, " name: '" + name + "'");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (name.indexOf(32) >= 0 || name.indexOf(61) >= 0) {
            Trace.log(2, "Value of parameter 'name' is not valid: " + name);
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 2);
        }
        this.name_ = name;
    }

    public EnvironmentVariable(AS400 system, char[] nameInCharArray) {
        this(system);
        if (Trace.traceOn_) {
            Trace.log(1, " name: '" + nameInCharArray + "'");
        }
        if (nameInCharArray.length == 0) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        for (int i = 0; i < nameInCharArray.length; ++i) {
            if (nameInCharArray[i] != ' ' && nameInCharArray[i] != '=') continue;
            Trace.log(2, "Value of parameter 'name' is not valid: " + nameInCharArray);
            throw new ExtendedIllegalArgumentException("name (" + nameInCharArray + ")", 2);
        }
        this.nameInCharArray_ = nameInCharArray;
    }

    EnvironmentVariable(AS400 system, ServiceProgramCall spc, char[] nameInCharArray) throws IOException {
        this(system, nameInCharArray);
        this.spc_ = spc;
    }

    EnvironmentVariable(AS400 system, ServiceProgramCall spc, String name) throws IOException {
        this(system, name);
        this.spc_ = spc;
    }

    EnvironmentVariable(AS400 system, ServiceProgramCall spc, byte[] nameBytes, byte[] valueBytes, int ccsid) throws IOException {
        this();
        this.system_ = system;
        this.spc_ = spc;
        this.converter_ = new Converter(ccsid, system);
        this.nameBytes_ = nameBytes;
        this.valueBytes_ = valueBytes;
        this.ccsid_ = ccsid;
        this.stringType_ = AS400BidiTransform.getStringType(ccsid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        EnvironmentVariable environmentVariable = this;
        synchronized (environmentVariable) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parameters;
        int rv;
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting environment variable.");
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to delete before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (this.converter_ == null) {
            this.converter_ = new Converter(this.system_.getCcsid(), this.system_);
        }
        if (this.nameBytes_ == null) {
            byte[] tempBytes = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[tempBytes.length + 1];
            System.arraycopy(tempBytes, 0, this.nameBytes_, 0, tempBytes.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        if ((rv = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zDltSysEnv", parameters = new ProgramParameter[]{new ProgramParameter(2, this.nameBytes_), nullParameter}, 3025, 0)) == 3025) {
            Trace.log(2, "Environment variable does not exist.");
            throw new ObjectDoesNotExistException(this.getName(), 2);
        }
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.stringType_ = 0;
    }

    public int getCCSID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable CCSID.");
        }
        if (this.ccsid_ == 0) {
            this.refreshValue();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable name.");
        }
        if (this.name_ == null && this.nameBytes_ != null) {
            this.name_ = this.converter_.byteArrayToString(this.nameBytes_, 0, this.nameBytes_.length - 1, this.stringType_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name: " + this.name_);
        }
        return this.name_;
    }

    public String getName(int stringType) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable name.");
        }
        if (this.stringType_ != stringType && this.nameBytes_ != null) {
            this.name_ = this.converter_.byteArrayToString(this.nameBytes_, 0, this.nameBytes_.length - 1, stringType);
        }
        this.stringType_ = stringType;
        return this.getName();
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable value.");
        }
        if (this.value_ == null) {
            if (this.valueBytes_ == null) {
                this.refreshValue();
            }
            this.value_ = this.converter_.byteArrayToString(this.valueBytes_, 0, this.valueBytes_.length - 1, this.stringType_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Value: " + this.value_);
        }
        return this.value_;
    }

    public String getValue(int stringType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.stringType_ = stringType;
        return this.getValue();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.spc_ = null;
        this.converter_ = null;
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.propertyChangeListeners_ = null;
    }

    public void refreshValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing environment variable value.");
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to refresh before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (this.converter_ == null) {
            this.converter_ = new Converter(this.system_.getCcsid(), this.system_);
        }
        if (this.nameBytes_ == null) {
            byte[] tempBytes = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[tempBytes.length + 1];
            System.arraycopy(tempBytes, 0, this.nameBytes_, 0, tempBytes.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.nameBytes_), new ProgramParameter(2, 1024), new ProgramParameter(2, new byte[]{0, 0, 4, 0}, 4), new ProgramParameter(2, 4), nullParameter};
        int rv = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetSysEnv", parameters, 3404, 3025);
        int actualValueSize = BinaryConverter.byteArrayToInt(parameters[2].getOutputData(), 0);
        if (rv == 3404) {
            if (Trace.traceOn_) {
                Trace.log(3, "ENOSPC returned, getting environment variable again with " + actualValueSize + " bytes.");
            }
            try {
                parameters[1].setOutputDataLength(actualValueSize);
                parameters[2].setInputData(BinaryConverter.intToByteArray(actualValueSize));
            }
            catch (PropertyVetoException e) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
                throw new InternalErrorException(10);
            }
            EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetSysEnv", parameters, 0, 0);
        } else if (rv == 3025) {
            Trace.log(2, "Environment variable does not exist.");
            throw new ObjectDoesNotExistException(this.getName(), 2);
        }
        this.valueBytes_ = new byte[actualValueSize];
        System.arraycopy(parameters[1].getOutputData(), 0, this.valueBytes_, 0, actualValueSize);
        if (Trace.traceOn_) {
            Trace.log(1, "Value bytes:", this.valueBytes_);
        }
        this.value_ = null;
        int ccsid = BinaryConverter.byteArrayToInt(parameters[3].getOutputData(), 0);
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", ccsid);
        }
        if (ccsid != this.ccsid_) {
            this.converter_ = new Converter(ccsid, this.system_);
            this.ccsid_ = ccsid;
            this.stringType_ = AS400BidiTransform.getStringType(ccsid);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void setName(String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variable name: '" + name + "'");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (name.indexOf(32) >= 0 || name.indexOf(61) >= 0) {
            Trace.log(2, "Value of parameter 'name' is not valid: " + name);
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 2);
        }
        this.nameBytes_ = null;
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.stringType_ = 0;
        if (this.propertyChangeListeners_ == null) {
            this.name_ = name;
        } else {
            String newValue;
            String oldValue = this.name_;
            this.name_ = newValue = name;
            this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
        }
    }

    public void setName(String name, int stringType) {
        this.setName(name);
        this.stringType_ = stringType;
    }

    public void setSystem(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.spc_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 newValue;
            AS400 oldValue = this.system_;
            this.system_ = newValue = system;
            this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
        }
    }

    public void setValue(String value) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(value, 0, 0);
    }

    public void setValue(String value, int ccsid) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(value, ccsid, AS400BidiTransform.getStringType(ccsid));
    }

    public void setValue(String value, int ccsid, int stringType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] tempBytes;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variable value: '" + value + "', ccsid: " + ccsid + ", string type: " + stringType);
        }
        if (value == null) {
            Trace.log(2, "Parameter 'value' is null.");
            throw new NullPointerException("value");
        }
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to set value before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (ccsid == 0) {
            ccsid = this.system_.getCcsid();
        }
        this.converter_ = new Converter(ccsid, this.system_);
        this.ccsid_ = ccsid;
        this.stringType_ = stringType;
        if (this.nameBytes_ == null) {
            tempBytes = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[tempBytes.length + 1];
            System.arraycopy(tempBytes, 0, this.nameBytes_, 0, tempBytes.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        tempBytes = this.converter_.stringToByteArray(value, this.stringType_);
        this.valueBytes_ = new byte[tempBytes.length + 1];
        System.arraycopy(tempBytes, 0, this.valueBytes_, 0, tempBytes.length);
        if (Trace.traceOn_) {
            Trace.log(1, "Value bytes:", this.valueBytes_);
        }
        byte[] parameterBytes = new byte[this.nameBytes_.length + this.valueBytes_.length];
        System.arraycopy(this.nameBytes_, 0, parameterBytes, 0, this.nameBytes_.length - 1);
        parameterBytes[this.nameBytes_.length - 1] = 126;
        System.arraycopy(this.valueBytes_, 0, parameterBytes, this.nameBytes_.length, this.valueBytes_.length);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, parameterBytes), new ProgramParameter(1, BinaryConverter.intToByteArray(ccsid)), nullParameter};
        EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zPutSysEnv", parameters, 0, 0);
    }

    public void setValue(char[] value) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(value, 0, 0);
    }

    public void setValue(char[] value, int ccsid) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(value, ccsid, AS400BidiTransform.getStringType(ccsid));
    }

    public void setValue(char[] value, int ccsid, int stringType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] tempBytes;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variable value: '" + value + "', ccsid: " + ccsid + ", string type: " + stringType);
        }
        if (value == null) {
            Trace.log(2, "Parameter 'value' is null.");
            throw new NullPointerException("value");
        }
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (this.name_ == null && this.nameBytes_ == null && this.nameInCharArray_.length == 0) {
            Trace.log(2, "Attempt to set value before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (ccsid == 0) {
            ccsid = this.system_.getCcsid();
        }
        this.converter_ = new Converter(ccsid, this.system_);
        this.ccsid_ = ccsid;
        this.stringType_ = stringType;
        if (this.nameBytes_ == null) {
            tempBytes = this.name_ == null ? this.converter_.charArrayToByteArray(this.nameInCharArray_, this.stringType_) : this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[tempBytes.length + 1];
            System.arraycopy(tempBytes, 0, this.nameBytes_, 0, tempBytes.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        tempBytes = this.converter_.charArrayToByteArray(value, this.stringType_);
        this.valueBytes_ = new byte[tempBytes.length + 1];
        System.arraycopy(tempBytes, 0, this.valueBytes_, 0, tempBytes.length);
        if (Trace.traceOn_) {
            Trace.log(1, "Value bytes:", this.valueBytes_);
        }
        byte[] parameterBytes = new byte[this.nameBytes_.length + this.valueBytes_.length];
        System.arraycopy(this.nameBytes_, 0, parameterBytes, 0, this.nameBytes_.length - 1);
        parameterBytes[this.nameBytes_.length - 1] = 126;
        System.arraycopy(this.valueBytes_, 0, parameterBytes, this.nameBytes_.length, this.valueBytes_.length);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, parameterBytes), new ProgramParameter(1, BinaryConverter.intToByteArray(ccsid)), nullParameter};
        EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zPutSysEnv", parameters, 0, 0);
    }

    static {
        try {
            nullParameter.setParameterType(2);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }
}

