/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class DDMS38OpenFeedback {
    private static final int FILE_OPEN_TYPE = 10;
    private static final int FILE_NAME = 11;
    private static final int FILE_NAME_LENGTH = 10;
    private static final int LIB_NAME = 21;
    private static final int LIB_NAME_LENGTH = 10;
    private static final int MBR_NAME = 31;
    private static final int MBR_NAME_LENGTH = 10;
    private static final int RECORD_LEN = 41;
    private static final int INP_BUFFER_LEN = 45;
    private static final int OUT_BUFFER_LEN = 49;
    private static final int NUM_RECORDS = 53;
    private static final int ACCESS_TYPE = 57;
    private static final int ACCESS_TYPE_LENGTH = 2;
    private static final int SUPPORT_DUPLICATE_KEYS = 59;
    private static final int SUPPORT_DUPLICATE_KEYS_LENGTH = 1;
    private static final int SOURCE_FILE_INDICATOR = 60;
    private static final int SOURCE_FILE_INDICATOR_LENGTH = 1;
    private static final int UFCB_PARAMETERS = 61;
    private static final int UFCB_PARAMETERS_LENGTH = 10;
    private static final int MAX_BLOCKED_RECORDS_TRANSFERRED = 71;
    private static final int RECORD_INCREMENT = 73;
    private static final int OPEN_FLAGS_1 = 75;
    private static final int NUMBER_OF_ASSOCIATED_PHYS_FILE_MBRS = 76;
    private static final int MAX_RECORD_LENGTH = 82;
    private static final int RECORD_WAIT_TIME = 84;
    private static final int OPEN_FLAGS_2 = 88;
    private static final int NULL_FIELD_BYTE_MAP = 90;
    private static final int NULL_KEY_FIELD_BYTE_MAP = 92;
    private static final int CCSID = 98;
    private static final int FIXED_FIELD_LEN = 100;
    private static final int MIN_RECORD_LEN = 102;
    byte[] data_;
    int offset_;
    ConverterImplRemote conv_;

    DDMS38OpenFeedback(AS400ImplRemote system, byte[] data) throws AS400SecurityException, InterruptedException, IOException {
        this(system, data, 0);
    }

    DDMS38OpenFeedback(AS400ImplRemote system, byte[] data, int offset) throws AS400SecurityException, InterruptedException, IOException {
        this.data_ = data;
        this.offset_ = offset;
        this.conv_ = ConverterImplRemote.getConverter(system.getCcsid(), system);
    }

    String getAccessType() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 57, 2);
    }

    int getCCSID() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 98);
    }

    boolean duplicateKeysSupported() {
        return this.data_[this.offset_ + 59] == -60;
    }

    String getFileName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 11, 10);
    }

    int getInputBufferLength() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 45);
    }

    String getLibraryName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 21, 10);
    }

    int getMaxNumberOfRecordsTransferred() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 71);
    }

    String getMemberName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 31, 10);
    }

    int getNullFieldByteMapOffset() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 90);
    }

    int getNumberOfRecords() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 53);
    }

    int getOpenType() {
        int type = this.data_[this.offset_ + 10] & 0xFFFF;
        if (type == 64 || type == 68 || type == 192 || type == 196) {
            return 0;
        }
        if (type == 32 || type == 36 || type == 160 || type == 164) {
            return 2;
        }
        return 1;
    }

    int getOutputBufferLength() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 49);
    }

    int getRecordIncrement() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 73);
    }

    int getRecordLength() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 41);
    }

    boolean hasVariableLengthFields() {
        return (this.data_[this.offset_ + 88 + 1] & 0x80) == 128;
    }

    boolean isLogicalFile() {
        return (this.data_[this.offset_ + 75] & 0x80) == 128;
    }

    boolean isLogicalJoinFile() {
        return (this.data_[this.offset_ + 75] & 4) == 4;
    }

    boolean isNullCapable() {
        return (this.data_[this.offset_ + 88 + 1] & 0x40) == 64;
    }

    boolean isSourceFile() {
        return this.data_[this.offset_ + 60] == -24;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(0);
        try {
            str.append("Open type: ");
            str.append(this.getOpenType());
            str.append("\n");
            str.append("Library name: ");
            str.append(this.getLibraryName());
            str.append("\n");
            str.append("File name: ");
            str.append(this.getFileName());
            str.append("\n");
            str.append("Member name: ");
            str.append(this.getMemberName());
            str.append("\n");
            str.append("Record length: ");
            str.append(this.getRecordLength());
            str.append("\n");
            str.append("Input buffer length: ");
            str.append(this.getInputBufferLength());
            str.append("\n");
            str.append("Output buffer length: ");
            str.append(this.getOutputBufferLength());
            str.append("\n");
            str.append("Number of records: ");
            str.append(this.getNumberOfRecords());
            str.append("\n");
            str.append("Access type: ");
            str.append(this.getAccessType());
            str.append("\n");
            str.append("Duplicate keys supported: ");
            str.append(this.duplicateKeysSupported());
            str.append("\n");
            str.append("Source file: ");
            str.append(this.isSourceFile());
            str.append("\n");
            str.append("Max blocked records transferred: ");
            str.append(this.getMaxNumberOfRecordsTransferred());
            str.append("\n");
            str.append("Record increment: ");
            str.append(this.getRecordIncrement());
            str.append("\n");
            str.append("Has variable length fields: ");
            str.append(this.hasVariableLengthFields());
            str.append("\n");
            str.append("Is null capable: ");
            str.append(this.isNullCapable());
            str.append("\n");
            str.append("Offset to null byte field map: ");
            str.append(this.getNullFieldByteMapOffset());
            str.append("\n");
            str.append("Logical file: ");
            str.append(this.isLogicalFile());
            str.append("\n");
            str.append("Logical join file: ");
            str.append(this.isLogicalJoinFile());
            str.append("\n");
            str.append("CCSID: ");
            str.append(this.getCCSID());
            str.append("\n");
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(6, (Throwable)e);
        }
        return str.toString();
    }
}

