/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.config.IConfigFile;
import org.apache.hop.core.config.plugin.ConfigFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class Project
extends ConfigFile
implements IConfigFile {
    @JsonIgnore
    private String configFilename;
    private String description;
    private String company;
    private String department;
    private String metadataBaseFolder = "${PROJECT_HOME}/metadata";
    private String unitTestsBasePath = "${PROJECT_HOME}";
    private String dataSetsCsvFolder = "${PROJECT_HOME}/datasets";
    private boolean enforcingExecutionInHome = true;
    private String parentProjectName;
    private MultiMetadataProvider metadataProvider;
    private List<Path> pipelinePaths;
    private List<Path> workflowPaths;
    private Map<PipelineMeta, List<TransformMeta>> pipelineTransformsMap;
    private Map<WorkflowMeta, List<ActionMeta>> workflowActionsMap;

    public Project() {
    }

    public Project(String configFilename) {
        this();
        this.configFilename = configFilename;
    }

    public void saveToFile() throws HopException {
        try {
            FileObject file = HopVfs.getFileObject((String)this.configFilename);
            if (!file.getParent().exists()) {
                file.getParent().createFolder();
            }
            ObjectMapper objectMapper = HopJson.newMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            OutputStream outputStream = HopVfs.getOutputStream((FileObject)file, (boolean)false);
            objectMapper.writeValue(outputStream, (Object)this);
        }
        catch (Exception e) {
            throw new HopException("Error saving project configuration to file '" + this.configFilename + "'", (Throwable)e);
        }
    }

    public void readFromFile() throws HopException {
        ObjectMapper objectMapper = HopJson.newMapper();
        try (InputStream inputStream = HopVfs.getInputStream((String)this.configFilename);){
            Project project = (Project)((Object)objectMapper.readValue(inputStream, Project.class));
            this.description = project.description;
            this.company = project.company;
            this.department = project.department;
            this.metadataBaseFolder = project.metadataBaseFolder;
            this.unitTestsBasePath = project.unitTestsBasePath;
            this.dataSetsCsvFolder = project.dataSetsCsvFolder;
            this.enforcingExecutionInHome = project.enforcingExecutionInHome;
            this.configMap = project.configMap;
            this.parentProjectName = project.parentProjectName;
        }
        catch (Exception e) {
            throw new HopException("Error saving project configuration to file '" + this.configFilename + "'", (Throwable)e);
        }
    }

    public void modifyVariables(IVariables variables, ProjectConfig projectConfig, List<String> configurationFiles, String environmentName) throws HopException {
        Object realValue;
        ProjectConfig parentProjectConfig;
        if (variables == null) {
            variables = Variables.getADefaultVariableSpace();
        }
        this.verifyProjectsChain(projectConfig.getProjectName(), variables);
        Project parentProject = null;
        String realParentProjectName = variables.resolve(this.parentProjectName);
        if (StringUtils.isNotEmpty((String)realParentProjectName) && (parentProjectConfig = ProjectsConfigSingleton.getConfig().findProjectConfig(realParentProjectName)) != null) {
            try {
                parentProject = parentProjectConfig.loadProject(variables);
                parentProject.modifyVariables(variables, parentProjectConfig, new ArrayList<String>(), null);
            }
            catch (HopException he) {
                LogChannel.GENERAL.logError("Error loading configuration file of parent project '" + realParentProjectName + "'", (Throwable)he);
            }
        }
        variables.setVariable("HOP_PROJECT_NAME", Const.NVL((String)projectConfig.getProjectName(), (String)""));
        variables.setVariable("HOP_ENVIRONMENT_NAME", Const.NVL((String)environmentName, (String)""));
        if (StringUtils.isNotEmpty((String)projectConfig.getProjectHome())) {
            realValue = variables.resolve(projectConfig.getProjectHome());
            variables.setVariable("PROJECT_HOME", (String)realValue);
        }
        for (String configurationFile : configurationFiles) {
            String realConfigurationFile = variables.resolve(configurationFile);
            FileObject file = HopVfs.getFileObject((String)realConfigurationFile);
            try {
                if (file.exists()) {
                    DescribedVariablesConfigFile configFile = new DescribedVariablesConfigFile(realConfigurationFile);
                    configFile.readFromFile();
                    for (DescribedVariable describedVariable : configFile.getDescribedVariables()) {
                        variables.setVariable(describedVariable.getName(), describedVariable.getValue());
                    }
                    continue;
                }
                LogChannel.GENERAL.logError("Configuration file '" + realConfigurationFile + "' does not exist to read variables from.");
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading described variables from configuration file '" + realConfigurationFile + "'", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((String)this.metadataBaseFolder)) {
            String parentMetadataFolder;
            Object realMetadataBaseFolder = variables.resolve(this.metadataBaseFolder);
            if (parentProject != null && StringUtils.isNotEmpty((String)(parentMetadataFolder = variables.getVariable("HOP_METADATA_FOLDER")))) {
                realMetadataBaseFolder = parentMetadataFolder + "," + (String)realMetadataBaseFolder;
            }
            variables.setVariable("HOP_METADATA_FOLDER", (String)realMetadataBaseFolder);
        }
        if (StringUtils.isNotEmpty((String)this.unitTestsBasePath)) {
            realValue = variables.resolve(this.unitTestsBasePath);
            variables.setVariable("HOP_UNIT_TESTS_FOLDER", (String)realValue);
        }
        if (StringUtils.isNotEmpty((String)this.dataSetsCsvFolder)) {
            realValue = variables.resolve(this.dataSetsCsvFolder);
            variables.setVariable("HOP_DATASETS_FOLDER", (String)realValue);
        }
        for (DescribedVariable variable : this.getDescribedVariables()) {
            if (variable.getName() == null) continue;
            variables.setVariable(variable.getName(), variable.getValue());
        }
    }

    public void verifyProjectsChain(String projectName, IVariables variables) throws HopException {
        if (StringUtils.isEmpty((String)this.parentProjectName)) {
            return;
        }
        if (this.parentProjectName.equals(projectName)) {
            throw new HopException("Parent project '" + this.parentProjectName + "' can not be the same as the project itself");
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        String realParentProjectName = variables.resolve(this.parentProjectName);
        ArrayList<String> projectsList = new ArrayList<String>();
        while (StringUtils.isNotEmpty((String)realParentProjectName)) {
            projectsList.add(realParentProjectName);
            ProjectConfig projectConfig = config.findProjectConfig(realParentProjectName);
            if (projectConfig != null) {
                Project parentProject = projectConfig.loadProject(variables);
                if (parentProject == null) {
                    realParentProjectName = null;
                    continue;
                }
                if (StringUtils.isEmpty((String)parentProject.parentProjectName)) {
                    realParentProjectName = null;
                    continue;
                }
                realParentProjectName = variables.resolve(parentProject.parentProjectName);
                if (!StringUtils.isNotEmpty((String)realParentProjectName) || !projectsList.contains(realParentProjectName)) continue;
                throw new HopException("There is a loop in the parent projects hierarchy: project " + realParentProjectName + " references itself");
            }
            realParentProjectName = null;
        }
    }

    public List<String> getMetadataTypes() throws HopException {
        ArrayList<String> metadataTypeNames = new ArrayList<String>();
        if (this.metadataProvider != null) {
            List metadataClasses = this.metadataProvider.getMetadataClasses();
            for (Class metadataClass : metadataClasses) {
                IHopMetadataSerializer metadataSerializer = this.metadataProvider.getSerializer(metadataClass);
                List names = metadataSerializer.listObjectNames();
                Collections.sort(names);
                if (names.isEmpty()) continue;
                metadataTypeNames.add(metadataClass.getName());
            }
        }
        return metadataTypeNames;
    }

    private void buildPipelineMap(IVariables variables) throws IOException, HopFileException {
        this.pipelineTransformsMap = new HashMap<PipelineMeta, List<TransformMeta>>();
        this.pipelinePaths = new ArrayList<Path>();
        File projectFolder = new File(String.valueOf(HopVfs.getFileObject((String)this.configFilename).getParent().getPath()));
        if (projectFolder.isDirectory()) {
            try (Stream<Path> walk = Files.walk(projectFolder.toPath(), new FileVisitOption[0]);){
                this.pipelinePaths = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(f -> f.getFileName().toString().toLowerCase().endsWith("hpl")).collect(Collectors.toList());
            }
        }
    }

    private void buildWorkflowMap() throws IOException, HopFileException {
        this.workflowActionsMap = new HashMap<WorkflowMeta, List<ActionMeta>>();
        this.workflowPaths = new ArrayList<Path>();
        File projectFolder = new File(String.valueOf(HopVfs.getFileObject((String)this.configFilename).getParent().getPath()));
        if (projectFolder.isDirectory()) {
            try (Stream<Path> walk = Files.walk(projectFolder.toPath(), new FileVisitOption[0]);){
                this.workflowPaths = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(f -> f.getFileName().toString().toLowerCase().endsWith("hwf")).collect(Collectors.toList());
            }
        }
    }

    public List<String> getTransformTypes(IVariables variables) throws IOException, HopFileException {
        this.buildPipelineMap(variables);
        for (Path pipelinePath : this.pipelinePaths) {
            try {
                PipelineMeta pipelineMeta = new PipelineMeta(pipelinePath.toAbsolutePath().toString(), (IHopMetadataProvider)this.metadataProvider, variables);
                List transformMetas = pipelineMeta.getTransforms();
                this.pipelineTransformsMap.put(pipelineMeta, transformMetas);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> transformTypes = new ArrayList<String>();
        for (PipelineMeta pipelineMeta : this.pipelineTransformsMap.keySet()) {
            for (TransformMeta transformMeta : pipelineMeta.getTransforms()) {
                if (transformTypes.contains(transformMeta.getTypeId())) continue;
                transformTypes.add(transformMeta.getPluginId());
            }
        }
        Collections.sort(transformTypes);
        return transformTypes;
    }

    public List<String> getActionTypes(IVariables variables) throws HopException, IOException {
        this.buildWorkflowMap();
        for (Path workflowPath : this.workflowPaths) {
            try {
                WorkflowMeta workflowMeta = new WorkflowMeta(variables, workflowPath.toAbsolutePath().toString(), (IHopMetadataProvider)this.metadataProvider);
                List actionMetas = workflowMeta.getActions();
                this.workflowActionsMap.put(workflowMeta, actionMetas);
            }
            catch (Exception e) {
                System.err.println("error getting workflow actions");
                e.printStackTrace();
            }
        }
        ArrayList<String> actionTypes = new ArrayList<String>();
        for (WorkflowMeta workflowMeta : this.workflowActionsMap.keySet()) {
            for (ActionMeta actionMeta : workflowMeta.getActions()) {
                if (actionTypes.contains(actionMeta.getAction().getPluginId())) continue;
                actionTypes.add(actionMeta.getAction().getPluginId());
            }
        }
        Collections.sort(actionTypes);
        return actionTypes;
    }

    public List<String> getPipelinesForMetadataItem(IVariables variables, String metadataItemName) throws HopException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        ArrayList<String> resultStrings = new ArrayList<String>();
        HashMap<HopMetadataPropertyType, String> metadataItems = new HashMap<HopMetadataPropertyType, String>();
        List metadataClasses = this.metadataProvider.getMetadataClasses();
        for (Class metadataClass : metadataClasses) {
            IHopMetadataSerializer metadataSerializer = this.metadataProvider.getSerializer(metadataClass);
            List names = metadataSerializer.listObjectNames();
            if (!names.contains(metadataItemName) || !metadataClass.isAnnotationPresent(HopMetadata.class)) continue;
            HopMetadata annotation = metadataClass.getAnnotation(HopMetadata.class);
            HopMetadataPropertyType hopMetadataPropertyType = annotation.hopMetadataPropertyType();
            metadataItems.put(hopMetadataPropertyType, metadataItemName);
        }
        if (Utils.isEmpty(this.pipelineTransformsMap)) {
            this.getTransformTypes(variables);
        }
        for (PipelineMeta pipelineMeta : this.pipelineTransformsMap.keySet()) {
            for (TransformMeta transformMeta : this.pipelineTransformsMap.get(pipelineMeta)) {
                Field[] fields;
                for (Field field : fields = transformMeta.getTransform().getClass().getDeclaredFields()) {
                    if (!field.isAnnotationPresent(HopMetadataProperty.class)) continue;
                    HopMetadataProperty annotation = field.getAnnotation(HopMetadataProperty.class);
                    HopMetadataPropertyType hopMetadataPropertyType = annotation.hopMetadataPropertyType();
                    if (!metadataItems.keySet().contains(hopMetadataPropertyType)) continue;
                    Method method = transformMeta.getTransform().getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                    String resultStr = (String)method.invoke((Object)transformMeta.getTransform(), new Object[0]);
                    resultStrings.add(pipelineMeta.getFilename() + " -> " + transformMeta.getName() + " -> " + resultStr + " (" + String.valueOf(hopMetadataPropertyType) + ")");
                }
            }
        }
        return resultStrings;
    }

    public List<String> getWorkflowsForMetadataItem(IVariables variables, String metadataItemName) throws HopException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        ArrayList<String> resultStrings = new ArrayList<String>();
        HashMap<HopMetadataPropertyType, String> metadataItems = new HashMap<HopMetadataPropertyType, String>();
        List metadataClasses = this.metadataProvider.getMetadataClasses();
        for (Class metadataClass : metadataClasses) {
            IHopMetadataSerializer metadataSerializer = this.metadataProvider.getSerializer(metadataClass);
            List names = metadataSerializer.listObjectNames();
            if (!names.contains(metadataItemName) || !metadataClass.isAnnotationPresent(HopMetadata.class)) continue;
            HopMetadata annotation = metadataClass.getAnnotation(HopMetadata.class);
            HopMetadataPropertyType hopMetadataPropertyType = annotation.hopMetadataPropertyType();
            metadataItems.put(hopMetadataPropertyType, metadataItemName);
        }
        if (Utils.isEmpty(this.workflowActionsMap)) {
            this.getActionTypes(variables);
        }
        for (WorkflowMeta workflowMeta : this.workflowActionsMap.keySet()) {
            for (ActionMeta actionMeta : this.workflowActionsMap.get(workflowMeta)) {
                Field[] fields;
                for (Field field : fields = actionMeta.getAction().getClass().getDeclaredFields()) {
                    if (!field.isAnnotationPresent(HopMetadataProperty.class)) continue;
                    HopMetadataProperty annotation = field.getAnnotation(HopMetadataProperty.class);
                    HopMetadataPropertyType hopMetadataPropertyType = annotation.hopMetadataPropertyType();
                    if (!metadataItems.keySet().contains(hopMetadataPropertyType)) continue;
                    Method method = actionMeta.getAction().getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                    String resultStr = (String)method.invoke((Object)actionMeta.getAction(), new Object[0]);
                    resultStrings.add(workflowMeta.getFilename() + " -> " + actionMeta.getName() + " -> " + resultStr + " (" + String.valueOf(hopMetadataPropertyType) + ")");
                }
            }
        }
        return resultStrings;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public void setConfigFilename(String configFilename) {
        this.configFilename = configFilename;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getMetadataBaseFolder() {
        return this.metadataBaseFolder;
    }

    public void setMetadataBaseFolder(String metadataBaseFolder) {
        this.metadataBaseFolder = metadataBaseFolder;
    }

    public String getUnitTestsBasePath() {
        return this.unitTestsBasePath;
    }

    public void setUnitTestsBasePath(String unitTestsBasePath) {
        this.unitTestsBasePath = unitTestsBasePath;
    }

    public String getDataSetsCsvFolder() {
        return this.dataSetsCsvFolder;
    }

    public void setDataSetsCsvFolder(String dataSetsCsvFolder) {
        this.dataSetsCsvFolder = dataSetsCsvFolder;
    }

    public boolean isEnforcingExecutionInHome() {
        return this.enforcingExecutionInHome;
    }

    public void setEnforcingExecutionInHome(boolean enforcingExecutionInHome) {
        this.enforcingExecutionInHome = enforcingExecutionInHome;
    }

    public String getParentProjectName() {
        return this.parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

