/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.AnnotationValidator;
import picocli.codegen.annotation.processing.CompileTimeTypeInfo;
import picocli.codegen.annotation.processing.CompletionCandidatesMetaData;
import picocli.codegen.annotation.processing.DefaultValueProviderMetaData;
import picocli.codegen.annotation.processing.MixinInfo;
import picocli.codegen.annotation.processing.ParameterConsumerMetaData;
import picocli.codegen.annotation.processing.TypeConverterMetaData;
import picocli.codegen.annotation.processing.TypedMember;
import picocli.codegen.annotation.processing.VersionProviderMetaData;
import picocli.codegen.util.JulLogFormatter;

public abstract class AbstractCommandSpecProcessor
extends AbstractProcessor {
    private static final String COMMAND_DEFAULT_NAME = "<main class>";
    private static Logger logger = Logger.getLogger(AbstractCommandSpecProcessor.class.getName());
    private static boolean loadBundlesDuringAnnotationProcessing;
    protected ProcessingEnvironment processingEnv;
    private static final String COMMAND_TYPE;
    static ConsoleHandler handler;

    protected AbstractCommandSpecProcessor() {
        if (Boolean.getBoolean("jul.format")) {
            for (Handler h : Logger.getLogger("picocli.annotation.processing").getHandlers()) {
                h.setFormatter(new JulLogFormatter());
            }
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Set<String> result = super.getSupportedAnnotationTypes();
        if (!result.contains("picocli.*")) {
            result = new TreeSet<String>(result);
            result.add("picocli.*");
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion ssv = this.getClass().getAnnotation(SupportedSourceVersion.class);
        Object sv = null;
        if (ssv == null) {
            return SourceVersion.latest();
        }
        return ssv.value();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        logger.fine("entered process, processingOver=" + roundEnv.processingOver());
        try {
            return this.tryProcess(annotations, roundEnv);
        }
        catch (Exception e) {
            this.fatalError(AbstractCommandSpecProcessor.stacktrace(e));
            return false;
        }
    }

    public static final void setLoadResourceBundles(boolean loadBundles) {
        loadBundlesDuringAnnotationProcessing = loadBundles;
    }

    private static String stacktrace(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private boolean tryProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CommandLine.Model.Messages.setLoadBundles((boolean)loadBundlesDuringAnnotationProcessing);
        new AnnotationValidator(this.processingEnv).validateAnnotations(roundEnv);
        Context context = new Context();
        this.buildCommands(roundEnv, context);
        this.buildMixins(roundEnv, context);
        this.buildArgGroups(roundEnv, context);
        this.buildOptions(roundEnv, context);
        this.buildParameters(roundEnv, context);
        this.buildParentCommands(roundEnv, context);
        this.buildSpecs(roundEnv, context);
        this.buildUnmatched(roundEnv, context);
        context.connectModel(this);
        this.debugFoundAnnotations(annotations, roundEnv);
        return this.handleCommands(context.commands, annotations, roundEnv);
    }

    protected abstract boolean handleCommands(Map<Element, CommandLine.Model.CommandSpec> var1, Set<? extends TypeElement> var2, RoundEnvironment var3);

    private void buildCommands(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building commands...");
        Set<? extends Element> explicitCommands = roundEnv.getElementsAnnotatedWith(CommandLine.Command.class);
        for (Element element : explicitCommands) {
            this.buildCommand(element, context, roundEnv);
        }
    }

    private CommandLine.Model.CommandSpec buildCommand(Element element, Context context, RoundEnvironment roundEnv) {
        return this.buildCommand(true, element, context, roundEnv);
    }

    private CommandLine.Model.CommandSpec buildCommand(boolean reuseExisting, Element element, final Context context, final RoundEnvironment roundEnv) {
        this.debugElement(element, "@Command");
        CommandLine.Model.CommandSpec result = null;
        if (reuseExisting && (result = context.commands.get(element)) != null) {
            return result;
        }
        result = CommandLine.Model.CommandSpec.wrapWithoutInspection((Object)element);
        result.interpolateVariables(Boolean.valueOf(false));
        context.commands.put(element, result);
        element.accept(new SimpleElementVisitor6<Void, CommandLine.Model.CommandSpec>(){

            @Override
            public Void visitType(TypeElement e, CommandLine.Model.CommandSpec commandSpec) {
                AbstractCommandSpecProcessor.this.updateCommandSpecFromTypeElement(e, context, commandSpec, roundEnv);
                List<? extends Element> enclosedElements = e.getEnclosedElements();
                AbstractCommandSpecProcessor.this.processEnclosedElements(context, roundEnv, enclosedElements);
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableElement e, CommandLine.Model.CommandSpec commandSpec) {
                AbstractCommandSpecProcessor.this.updateCommandFromMethodElement(e, context, commandSpec, roundEnv);
                List<? extends Element> enclosedElements = e.getEnclosedElements();
                AbstractCommandSpecProcessor.this.processEnclosedElements(context, roundEnv, enclosedElements);
                return null;
            }
        }, result);
        logger.fine(String.format("CommandSpec[name=%s] built for %s", result.name(), element));
        return result;
    }

    private void updateCommandSpecFromTypeElement(TypeElement typeElement, Context context, CommandLine.Model.CommandSpec result, RoundEnvironment roundEnv) {
        TypeElement superClass = AbstractCommandSpecProcessor.superClassFor(typeElement);
        this.debugElement(superClass, "  super");
        result.withToString(typeElement.asType().toString());
        Stack<TypeElement> hierarchy = this.buildTypeHierarchy(typeElement);
        while (!hierarchy.isEmpty()) {
            typeElement = hierarchy.pop();
            this.updateCommandSpecFromCommandAnnotation(result, typeElement, context, roundEnv);
            context.registerCommandType(result, typeElement);
        }
    }

    private void updateCommandFromMethodElement(ExecutableElement method, Context context, CommandLine.Model.CommandSpec result, RoundEnvironment roundEnv) {
        this.debugMethod(method);
        result.withToString(method.getEnclosingElement().asType().toString() + "." + method.getSimpleName());
        this.updateCommandSpecFromCommandAnnotation(result, method, context, roundEnv);
        result.setAddMethodSubcommands(Boolean.valueOf(false));
        if (result.name().equals(COMMAND_DEFAULT_NAME)) {
            result.name(method.getSimpleName().toString());
        }
        if (this.isSubcommand(method, roundEnv)) {
            CommandLine.Model.CommandSpec commandSpec = this.buildCommand(method.getEnclosingElement(), context, roundEnv);
            commandSpec.addSubcommand(result.name(), result);
        }
        this.buildOptionsAndPositionalsFromMethodParameters(method, result, context);
    }

    private boolean isSubcommand(ExecutableElement method, RoundEnvironment roundEnv) {
        Element typeElement = method.getEnclosingElement();
        CommandLine.Command cmd = typeElement.getAnnotation(CommandLine.Command.class);
        if (cmd != null) {
            return cmd.addMethodSubcommands();
        }
        List<? extends Element> elements = typeElement.getEnclosedElements();
        return !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.Option.class), elements) || !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.Parameters.class), elements) || !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.Mixin.class), elements) || !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.ArgGroup.class), elements) || !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.Unmatched.class), elements) || !Collections.disjoint(roundEnv.getElementsAnnotatedWith(CommandLine.Spec.class), elements);
    }

    private Stack<TypeElement> buildTypeHierarchy(TypeElement typeElement) {
        Stack<TypeElement> hierarchy = new Stack<TypeElement>();
        int count = 0;
        while (typeElement != null && count++ < 20) {
            logger.fine("Adding to type hierarchy: " + typeElement);
            hierarchy.add(typeElement);
            typeElement = AbstractCommandSpecProcessor.superClassFor(typeElement);
        }
        return hierarchy;
    }

    private void updateCommandSpecFromCommandAnnotation(CommandLine.Model.CommandSpec result, Element element, Context context, RoundEnvironment roundEnv) {
        CommandLine.Command cmd = element.getAnnotation(CommandLine.Command.class);
        if (cmd != null) {
            this.updateCommandAttributes(result, cmd);
            List<CommandLine.Model.CommandSpec> subcommands = this.findSubcommands(element.getAnnotationMirrors(), context, roundEnv);
            for (CommandLine.Model.CommandSpec sub : subcommands) {
                result.addSubcommand(sub.name(), sub);
            }
            if (cmd.mixinStandardHelpOptions()) {
                context.commandsRequestingStandardHelpOptions.add(result);
            }
        }
    }

    private void updateCommandAttributes(CommandLine.Model.CommandSpec result, CommandLine.Command cmd) {
        result.updateCommandAttributes(cmd, null);
        VersionProviderMetaData.initVersionProvider(result, cmd);
        DefaultValueProviderMetaData.initDefaultValueProvider(result, cmd);
    }

    private List<CommandLine.Model.CommandSpec> findSubcommands(List<? extends AnnotationMirror> annotationMirrors, Context context, RoundEnvironment roundEnv) {
        ArrayList<CommandLine.Model.CommandSpec> result = new ArrayList<CommandLine.Model.CommandSpec>();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(COMMAND_TYPE)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"subcommands".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue list = entry.getValue();
                List typeMirrors = (List)list.getValue();
                this.registerSubcommands(typeMirrors, result, context, roundEnv);
                continue block0;
            }
        }
        return result;
    }

    private void registerSubcommands(List<AnnotationValue> typeMirrors, List<CommandLine.Model.CommandSpec> result, Context context, RoundEnvironment roundEnv) {
        for (AnnotationValue typeMirror : typeMirrors) {
            TypeElement subcommandElement = this.processingEnv.getElementUtils().getTypeElement(typeMirror.getValue().toString().replace('$', '.'));
            logger.fine("Processing subcommand: " + subcommandElement);
            if (!this.isValidSubcommandHasNameAttribute(subcommandElement)) continue;
            CommandLine.Model.CommandSpec commandSpec = this.buildCommand(false, subcommandElement, context, roundEnv);
            result.add(commandSpec);
        }
    }

    private void processEnclosedElements(Context context, RoundEnvironment roundEnv, List<? extends Element> enclosedElements) {
        for (Element element : enclosedElements) {
            if (element.getAnnotation(CommandLine.Command.class) != null) {
                this.buildCommand(element, context, roundEnv);
            }
            if (element.getAnnotation(CommandLine.ArgGroup.class) != null) {
                this.buildArgGroup(element, context, roundEnv);
            }
            if (element.getAnnotation(CommandLine.Mixin.class) != null) {
                this.buildMixin(element, roundEnv, context);
            }
            if (element.getAnnotation(CommandLine.Option.class) != null) {
                this.buildOption(element, context);
            }
            if (element.getAnnotation(CommandLine.Parameters.class) != null) {
                this.buildParameter(element, context);
            }
            if (element.getAnnotation(CommandLine.Unmatched.class) != null) {
                this.buildUnmatched(element, context);
            }
            if (element.getAnnotation(CommandLine.Spec.class) != null) {
                this.buildSpec(element, context);
            }
            if (element.getAnnotation(CommandLine.ParentCommand.class) == null) continue;
            this.buildParentCommand(element, context);
        }
    }

    private boolean isValidSubcommandHasNameAttribute(Element subcommandElement) {
        CommandLine.Command annotation = subcommandElement.getAnnotation(CommandLine.Command.class);
        if (annotation == null) {
            this.error(subcommandElement, "Subcommand is missing @Command annotation with a name attribute", new Object[0]);
            return false;
        }
        if (COMMAND_DEFAULT_NAME.equals(annotation.name())) {
            this.error(subcommandElement, "Subcommand @Command annotation should have a name attribute", new Object[0]);
            return false;
        }
        return true;
    }

    private void buildMixins(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building mixins...");
        Set<? extends Element> explicitMixins = roundEnv.getElementsAnnotatedWith(CommandLine.Mixin.class);
        for (Element element : explicitMixins) {
            this.buildMixin(element, roundEnv, context);
        }
    }

    private void buildMixin(Element element, RoundEnvironment roundEnv, Context context) {
        this.debugElement(element, "@Mixin");
        if (element.asType().getKind() != TypeKind.DECLARED) {
            this.error(element, "@Mixin must have a declared type, not %s", element.asType());
            return;
        }
        TypeElement type = (TypeElement)((DeclaredType)element.asType()).asElement();
        CommandLine.Model.CommandSpec mixin = this.buildCommand(type, context, roundEnv);
        logger.fine("Built mixin: " + mixin + " from " + element);
        if (EnumSet.of(ElementKind.FIELD, ElementKind.PARAMETER).contains((Object)element.getKind())) {
            VariableElement variableElement = (VariableElement)element;
            MixinInfo mixinInfo = new MixinInfo(variableElement, mixin);
            CommandLine.Model.CommandSpec mixee = this.buildCommand(mixinInfo.enclosingElement(), context, roundEnv);
            Set<MixinInfo> mixinInfos = context.mixinInfoMap.get(mixee);
            if (mixinInfos == null) {
                mixinInfos = new HashSet<MixinInfo>(2);
                context.mixinInfoMap.put(mixee, mixinInfos);
            }
            mixinInfos.add(mixinInfo);
            logger.fine("Mixin name=" + mixinInfo.mixinName() + ", target command=" + mixee.userObject());
        }
    }

    private void buildArgGroups(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building argGroups...");
        Set<? extends Element> explicitArgGroups = roundEnv.getElementsAnnotatedWith(CommandLine.ArgGroup.class);
        for (Element element : explicitArgGroups) {
            this.buildArgGroup(element, context, roundEnv);
        }
    }

    private void buildArgGroup(Element element, Context context, RoundEnvironment roundEnv) {
        this.debugElement(element, "@ArgGroup");
        TypeMirror elementType = element.asType();
        if (elementType.getKind() != TypeKind.DECLARED && elementType.getKind() != TypeKind.ARRAY) {
            this.error(element, "@ArgGroup must have a declared or array type, not %s", elementType);
            return;
        }
        CommandLine.Model.ArgGroupSpec.Builder builder = element.accept(new SimpleElementVisitor6<CommandLine.Model.ArgGroupSpec.Builder, Void>(null){

            @Override
            public CommandLine.Model.ArgGroupSpec.Builder visitVariable(VariableElement e, Void aVoid) {
                return CommandLine.Model.ArgGroupSpec.builder((CommandLine.Model.IAnnotatedElement)new TypedMember(e, -1));
            }

            @Override
            public CommandLine.Model.ArgGroupSpec.Builder visitExecutable(ExecutableElement e, Void aVoid) {
                return CommandLine.Model.ArgGroupSpec.builder((CommandLine.Model.IAnnotatedElement)new TypedMember(e, AbstractCommandSpecProcessor.this));
            }
        }, null);
        if (builder == null) {
            this.error(element, "Only methods or variables can be annotated with @ArgGroup, not %s", element);
        } else {
            builder.updateArgGroupAttributes(element.getAnnotation(CommandLine.ArgGroup.class));
            context.argGroupElementsByVar.put(element, builder);
            DeclaredType declaredType = AbstractCommandSpecProcessor.getDeclaredTypeForArgGroupVarOrMethod(element, this);
            if (declaredType != null) {
                context.argGroupElementsByType.put(declaredType, builder);
                this.processEnclosedElements(context, roundEnv, declaredType.asElement().getEnclosedElements());
            }
        }
    }

    private static DeclaredType getDeclaredTypeForArgGroupVarOrMethod(Element element, AbstractCommandSpecProcessor proc) {
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.EXECUTABLE) {
            elementType = ((ExecutableType)elementType).getReturnType();
        }
        if (elementType.getKind() != TypeKind.DECLARED && elementType.getKind() != TypeKind.ARRAY) {
            proc.error(element, "The type of an @ArgGroup-annotated element '%s' must be a declared class, a collection or an array, but was %s", element.getSimpleName(), elementType);
            return null;
        }
        DeclaredType declaredType = elementType.getKind() == TypeKind.ARRAY ? (DeclaredType)((ArrayType)elementType).getComponentType() : (DeclaredType)elementType;
        return declaredType;
    }

    private void buildOptions(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building options...");
        Set<? extends Element> explicitOptions = roundEnv.getElementsAnnotatedWith(CommandLine.Option.class);
        for (Element element : explicitOptions) {
            this.buildOption(element, context);
        }
    }

    private void buildOption(Element element, Context context) {
        if (context.options.containsKey(element)) {
            return;
        }
        TypedMember typedMember = this.extractTypedMember(element, "@Option");
        if (typedMember != null) {
            CommandLine.Model.OptionSpec.Builder builder = CommandLine.Model.OptionSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)context.factory);
            builder.completionCandidates(CompletionCandidatesMetaData.extract(element));
            builder.converters((CommandLine.ITypeConverter[])TypeConverterMetaData.extract(element));
            builder.parameterConsumer((CommandLine.IParameterConsumer)ParameterConsumerMetaData.extract(element));
            context.options.put(element, builder);
        }
    }

    private void buildParameters(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building parameters...");
        Set<? extends Element> explicitParameters = roundEnv.getElementsAnnotatedWith(CommandLine.Parameters.class);
        for (Element element : explicitParameters) {
            this.buildParameter(element, context);
        }
    }

    private void buildParameter(Element element, Context context) {
        if (context.parameters.containsKey(element)) {
            return;
        }
        TypedMember typedMember = this.extractTypedMember(element, "@Parameters");
        if (typedMember != null) {
            CommandLine.Model.PositionalParamSpec.Builder builder = CommandLine.Model.PositionalParamSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)context.factory);
            builder.completionCandidates(CompletionCandidatesMetaData.extract(element));
            builder.converters((CommandLine.ITypeConverter[])TypeConverterMetaData.extract(element));
            builder.parameterConsumer((CommandLine.IParameterConsumer)ParameterConsumerMetaData.extract(element));
            context.parameters.put(element, builder);
        }
    }

    private TypedMember extractTypedMember(Element element, String annotation) {
        this.debugElement(element, annotation);
        if (element.getKind() == ElementKind.FIELD) {
            return new TypedMember((VariableElement)element, -1);
        }
        if (element.getKind() == ElementKind.METHOD) {
            return new TypedMember((ExecutableElement)element, this);
        }
        this.error(element, "Can only process %s annotations on fields, methods and @Command-annotated method parameters, not on %s", new Object[]{annotation, element.getKind()});
        return null;
    }

    private void buildOptionsAndPositionalsFromMethodParameters(ExecutableElement method, CommandLine.Model.CommandSpec result, Context context) {
        List<? extends VariableElement> params = method.getParameters();
        int position = -1;
        for (VariableElement variableElement : params) {
            CommandLine.Model.OptionSpec.Builder builder;
            TypedMember typedMember;
            boolean isArgGroup;
            boolean isOption = variableElement.getAnnotation(CommandLine.Option.class) != null;
            boolean isPositional = variableElement.getAnnotation(CommandLine.Parameters.class) != null;
            boolean isMixin = variableElement.getAnnotation(CommandLine.Mixin.class) != null;
            boolean bl = isArgGroup = variableElement.getAnnotation(CommandLine.ArgGroup.class) != null;
            if (isOption && isPositional) {
                this.error(variableElement, "Method %s parameter %s should not have both @Option and @Parameters annotation", method.getSimpleName(), variableElement.getSimpleName());
            } else if ((isOption || isPositional) && isMixin) {
                this.error(variableElement, "Method %s parameter %s should not have a @Mixin annotation as well as an @Option or @Parameters annotation", method.getSimpleName(), variableElement.getSimpleName());
            } else if ((isOption || isPositional || isMixin) && isArgGroup) {
                this.error(variableElement, "Method %s parameter %s should not have a @ArgGroup annotation as well as an @Option, @Parameters or @Mixin annotation", method.getSimpleName(), variableElement.getSimpleName());
            }
            if (isOption) {
                typedMember = new TypedMember(variableElement, -1);
                builder = CommandLine.Model.OptionSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)context.factory);
                builder.completionCandidates(CompletionCandidatesMetaData.extract(variableElement));
                builder.parameterConsumer((CommandLine.IParameterConsumer)ParameterConsumerMetaData.extract(variableElement));
                builder.converters((CommandLine.ITypeConverter[])TypeConverterMetaData.extract(variableElement));
                context.options.put(variableElement, builder);
                continue;
            }
            if (isArgGroup) {
                typedMember = new TypedMember(variableElement, -1);
                builder = CommandLine.Model.ArgGroupSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember);
                builder.updateArgGroupAttributes(variableElement.getAnnotation(CommandLine.ArgGroup.class));
                context.argGroupElementsByVar.put(variableElement, (CommandLine.Model.ArgGroupSpec.Builder)builder);
                DeclaredType declaredType = AbstractCommandSpecProcessor.getDeclaredTypeForArgGroupVarOrMethod(variableElement, this);
                if (declaredType == null) continue;
                context.argGroupElementsByType.put(declaredType, (CommandLine.Model.ArgGroupSpec.Builder)builder);
                continue;
            }
            if (isMixin) continue;
            typedMember = new TypedMember(variableElement, ++position);
            builder = CommandLine.Model.PositionalParamSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)context.factory);
            builder.completionCandidates(CompletionCandidatesMetaData.extract(variableElement));
            builder.parameterConsumer((CommandLine.IParameterConsumer)ParameterConsumerMetaData.extract(variableElement));
            builder.converters((CommandLine.ITypeConverter[])TypeConverterMetaData.extract(variableElement));
            context.parameters.put(variableElement, (CommandLine.Model.PositionalParamSpec.Builder)builder);
        }
    }

    private static TypeElement superClassFor(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        logger.finest(String.format("Superclass of %s is %s (of kind %s)", new Object[]{element, superclass, superclass.getKind()}));
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    private void buildUnmatched(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building unmatched...");
        Set<? extends Element> explicitUnmatched = roundEnv.getElementsAnnotatedWith(CommandLine.Unmatched.class);
        for (Element element : explicitUnmatched) {
            this.buildUnmatched(element, context);
        }
    }

    private void buildUnmatched(Element element, Context context) {
        this.debugElement(element, "@Unmatched");
        CommandLine.Model.IAnnotatedElement specElement = this.buildTypedMember(element);
        if (specElement == null) {
            this.error(element, "Only methods or variables can be annotated with @Unmatched, not %s", element);
        } else {
            context.unmatchedElements.put(element, specElement);
        }
    }

    private void buildSpecs(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building specs...");
        Set<? extends Element> explicitSpecs = roundEnv.getElementsAnnotatedWith(CommandLine.Spec.class);
        for (Element element : explicitSpecs) {
            this.buildSpec(element, context);
        }
    }

    private void buildSpec(Element element, Context context) {
        this.debugElement(element, "@Spec");
        CommandLine.Model.IAnnotatedElement specElement = this.buildTypedMember(element);
        if (specElement == null) {
            this.error(element, "Only methods or variables can be annotated with @Spec, not %s", element);
        } else {
            context.specElements.put(element, specElement);
        }
    }

    private void buildParentCommands(RoundEnvironment roundEnv, Context context) {
        logger.fine("Building parentCommands...");
        Set<? extends Element> explicitParentCommands = roundEnv.getElementsAnnotatedWith(CommandLine.ParentCommand.class);
        for (Element element : explicitParentCommands) {
            this.buildParentCommand(element, context);
        }
    }

    private void buildParentCommand(Element element, Context context) {
        this.debugElement(element, "@ParentCommand");
        CommandLine.Model.IAnnotatedElement parentCommandElement = this.buildTypedMember(element);
        if (parentCommandElement == null) {
            this.error(element, "Only methods or variables can be annotated with @ParentCommand, not %s", element);
        } else {
            context.parentCommandElements.put(element, parentCommandElement);
        }
    }

    private CommandLine.Model.IAnnotatedElement buildTypedMember(Element element) {
        return element.accept(new SimpleElementVisitor6<TypedMember, Void>(null){

            @Override
            public TypedMember visitVariable(VariableElement e, Void aVoid) {
                return new TypedMember(e, -1);
            }

            @Override
            public TypedMember visitExecutable(ExecutableElement e, Void aVoid) {
                return new TypedMember(e, AbstractCommandSpecProcessor.this);
            }
        }, null);
    }

    private void debugMethod(ExecutableElement method) {
        logger.finest(String.format("  method: simpleName=%s, asType=%s, varargs=%s, returnType=%s, enclosingElement=%s, params=%s, typeParams=%s", method.getSimpleName(), method.asType(), method.isVarArgs(), method.getReturnType(), method.getEnclosingElement(), method.getParameters(), method.getTypeParameters()));
        for (VariableElement variableElement : method.getParameters()) {
            logger.finest(String.format("    variable: name=%s, annotationMirrors=%s, @Option=%s, @Parameters=%s", variableElement.getSimpleName(), variableElement.getAnnotationMirrors(), variableElement.getAnnotation(CommandLine.Option.class), variableElement.getAnnotation(CommandLine.Parameters.class)));
        }
    }

    private void debugElement(Element element, String s) {
        if (element == null) {
            return;
        }
        this.logElementDetails(element, s);
    }

    private void logElementDetails(Element element, String s) {
        logger.finest(String.format(s + ": kind=%s, cls=%s, simpleName=%s, type=%s, typeKind=%s, enclosed=%s, enclosing=%s", new Object[]{element.getKind(), element.getClass().getName(), element.getSimpleName(), element.asType(), element.asType().getKind(), element.getEnclosedElements(), element.getEnclosingElement()}));
        TypeMirror typeMirror = element.asType();
        if (element.getKind() == ElementKind.ENUM) {
            for (Element element2 : element.getEnclosedElements()) {
                this.logElementDetails(element2, s + "  ");
            }
        } else {
            this.debugType(typeMirror, element, s + "  ");
        }
    }

    private void debugType(TypeMirror typeMirror, Element element, String indent) {
        if (indent.length() > 20) {
            return;
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            logger.finest(String.format("%stype=%s, asElement=%s, (elementKind=%s, elementClass=%s), typeArgs=%s, enclosing=%s", new Object[]{indent, declaredType, declaredType.asElement(), declaredType.asElement().getKind(), declaredType.asElement().getClass(), declaredType.getTypeArguments(), declaredType.getEnclosingType()}));
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                if (typeMirror2.equals(typeMirror)) continue;
                this.debugType(typeMirror2, element, indent + "  ");
            }
            if (declaredType.asElement().getKind() == ElementKind.ENUM && !element.equals(declaredType.asElement())) {
                this.logElementDetails(declaredType.asElement(), indent + "  --> ");
            }
        } else if (typeMirror.getKind() == TypeKind.EXECUTABLE) {
            ExecutableType type = (ExecutableType)typeMirror;
            logger.finest(String.format("%stype=%s, typeArgs=%s, paramTypes=%s, returnType=%s", indent, type, type.getTypeVariables(), type.getParameterTypes(), type.getReturnType()));
            for (TypeMirror typeMirror3 : type.getParameterTypes()) {
                if (typeMirror3.equals(typeMirror)) continue;
                this.debugType(typeMirror3, element, indent + "  ");
            }
        } else {
            logger.finest(String.format("%s%s %s is of kind=%s", new Object[]{indent, typeMirror, element.getSimpleName(), typeMirror.getKind()}));
        }
    }

    private void debugFoundAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        logger.fine("Found annotations: " + annotations);
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            logger.finest(annotatedElements + " is annotated with " + typeElement);
        }
    }

    protected void logInfo(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, this.getClass().getName() + " " + msg);
    }

    protected void error(Element element, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), element);
    }

    protected void warn(Element element, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), element);
    }

    protected void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    static {
        COMMAND_TYPE = CommandLine.Command.class.getName().replace('$', '.');
        handler = new ConsoleHandler();
    }

    static class NullFactory
    implements CommandLine.IFactory {
        NullFactory() {
        }

        public <K> K create(Class<K> cls) throws Exception {
            return null;
        }
    }

    static class Graph {
        private int vertexCount;
        private List<Integer>[] adjacencyList;

        Graph(int vertexCount) {
            this.vertexCount = vertexCount;
            this.adjacencyList = new LinkedList[vertexCount];
            for (int i = 0; i < vertexCount; ++i) {
                this.adjacencyList[i] = new LinkedList<Integer>();
            }
        }

        void addEdge(int subgroup, int group) {
            this.adjacencyList[subgroup].add(group);
        }

        void topologicalSortUtil(int v, boolean[] visited, Stack<Integer> stack) {
            visited[v] = true;
            for (Integer i : this.adjacencyList[v]) {
                if (visited[i]) continue;
                this.topologicalSortUtil(i, visited, stack);
            }
            stack.push(v);
        }

        Stack<Integer> topologicalSort() {
            Stack<Integer> stack = new Stack<Integer>();
            boolean[] visited = new boolean[this.vertexCount];
            for (int i = 0; i < this.vertexCount; ++i) {
                if (visited[i]) continue;
                this.topologicalSortUtil(i, visited, stack);
            }
            return stack;
        }
    }

    static class Context {
        CommandLine.IFactory factory = null;
        Map<Element, CommandLine.Model.CommandSpec> commands = new LinkedHashMap<Element, CommandLine.Model.CommandSpec>();
        Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes = new LinkedHashMap<TypeMirror, List<CommandLine.Model.CommandSpec>>();
        Map<Element, CommandLine.Model.OptionSpec.Builder> options = new LinkedHashMap<Element, CommandLine.Model.OptionSpec.Builder>();
        Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters = new LinkedHashMap<Element, CommandLine.Model.PositionalParamSpec.Builder>();
        Map<Element, CommandLine.Model.ArgGroupSpec.Builder> argGroupElementsByVar = new LinkedHashMap<Element, CommandLine.Model.ArgGroupSpec.Builder>();
        Map<DeclaredType, CommandLine.Model.ArgGroupSpec.Builder> argGroupElementsByType = new LinkedHashMap<DeclaredType, CommandLine.Model.ArgGroupSpec.Builder>();
        Map<CommandLine.Model.CommandSpec, Set<MixinInfo>> mixinInfoMap = new IdentityHashMap<CommandLine.Model.CommandSpec, Set<MixinInfo>>();
        Map<Element, CommandLine.Model.IAnnotatedElement> parentCommandElements = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        Map<Element, CommandLine.Model.IAnnotatedElement> specElements = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        Map<Element, CommandLine.Model.IAnnotatedElement> unmatchedElements = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        Set<CommandLine.Model.CommandSpec> commandsRequestingStandardHelpOptions = new LinkedHashSet<CommandLine.Model.CommandSpec>();

        Context() {
        }

        private void connectModel(AbstractCommandSpecProcessor proc) {
            CommandLine.Model.CommandSpec commandSpec1;
            CommandLine.Model.CommandSpec commandSpec;
            CommandLine.Model.ArgGroupSpec.Builder group;
            TypeMirror typeMirror;
            logger.fine("---------------------------");
            logger.fine("Known commands...");
            for (Map.Entry<Element, CommandLine.Model.CommandSpec> entry : this.commands.entrySet()) {
                logger.fine(String.format("%s has CommandSpec[name=%s]", entry.getKey(), entry.getValue().name()));
            }
            logger.fine("Known mixins...");
            for (Map.Entry<Element, Object> entry : this.mixinInfoMap.entrySet()) {
                logger.fine(String.format("mixins for %s:", ((CommandLine.Model.CommandSpec)entry.getKey()).userObject()));
                for (MixinInfo mixinInfo : (Set)entry.getValue()) {
                    logger.fine(String.format("mixin name=%s userObj=%s:", mixinInfo.mixinName(), mixinInfo.mixin().userObject()));
                }
            }
            for (Map.Entry<Element, Object> entry : this.options.entrySet()) {
                typeMirror = entry.getKey().getEnclosingElement().asType();
                group = this.argGroupElementsByType.get(typeMirror);
                if (group != null) {
                    logger.fine("Building OptionSpec for " + entry + " in arg group " + group);
                    group.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)entry.getValue()).build());
                    continue;
                }
                commandSpec = Context.getOrCreateCommandSpecForArg(entry.getKey(), this.commands);
                logger.fine("Building OptionSpec for " + entry + " in spec " + commandSpec);
                commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)entry.getValue()).build());
            }
            for (Map.Entry<Element, Object> entry : this.parameters.entrySet()) {
                typeMirror = entry.getKey().getEnclosingElement().asType();
                group = this.argGroupElementsByType.get(typeMirror);
                if (group != null) {
                    logger.fine("Building PositionalParamSpec for " + entry + " in arg group " + group);
                    group.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.PositionalParamSpec.Builder)entry.getValue()).build());
                    continue;
                }
                commandSpec = Context.getOrCreateCommandSpecForArg(entry.getKey(), this.commands);
                logger.fine("Building PositionalParamSpec for " + entry);
                commandSpec.addPositional(((CommandLine.Model.PositionalParamSpec.Builder)entry.getValue()).build());
            }
            if (this.connectArgGroups(proc)) {
                return;
            }
            for (Map.Entry<Element, Object> entry : this.specElements.entrySet()) {
                commandSpec1 = this.commands.get(entry.getKey().getEnclosingElement());
                if (commandSpec1 != null) {
                    logger.fine("Adding " + entry + " to commandSpec " + commandSpec1);
                    commandSpec1.addSpecElement((CommandLine.Model.IAnnotatedElement)entry.getValue());
                    continue;
                }
                Element enclosingElement = entry.getKey().getEnclosingElement();
                if (enclosingElement.getKind() == ElementKind.CLASS || enclosingElement.getKind() == ElementKind.ENUM) {
                    TypeMirror typeMirror2 = enclosingElement.asType();
                    TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror2).asElement();
                    List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
                    boolean valid = false;
                    for (TypeMirror typeMirror3 : interfaces) {
                        if (!typeMirror3.toString().equals("picocli.CommandLine.IVersionProvider")) continue;
                        valid = true;
                    }
                    if (valid) continue;
                    proc.error(entry.getKey(), "@Spec must be enclosed in a @Command, or in a class that implements IVersionProvider but was %s: %s", entry.getKey().getEnclosingElement(), entry.getKey().getEnclosingElement().getSimpleName());
                    continue;
                }
                proc.error(entry.getKey(), "@Spec must be enclosed in a @Command, but was %s: %s", entry.getKey().getEnclosingElement(), entry.getKey().getEnclosingElement().getSimpleName());
            }
            for (Map.Entry<Element, Object> entry : this.parentCommandElements.entrySet()) {
                commandSpec1 = this.commands.get(entry.getKey().getEnclosingElement());
                if (commandSpec1 != null) {
                    logger.fine("Adding " + entry + " to commandSpec " + commandSpec1);
                    commandSpec1.addParentCommandElement((CommandLine.Model.IAnnotatedElement)entry.getValue());
                    continue;
                }
                proc.error(entry.getKey(), "@ParentCommand must be enclosed in a @Command, but was %s: %s", entry.getKey().getEnclosingElement(), entry.getKey().getEnclosingElement().getSimpleName());
            }
            for (Map.Entry<Element, Object> entry : this.unmatchedElements.entrySet()) {
                commandSpec1 = this.commands.get(entry.getKey().getEnclosingElement());
                if (commandSpec1 != null) {
                    logger.fine("Adding " + entry + " to commandSpec " + commandSpec1);
                    CommandLine.Model.IAnnotatedElement annotatedElement = (CommandLine.Model.IAnnotatedElement)entry.getValue();
                    if (annotatedElement.getTypeInfo().isArray() || annotatedElement.getTypeInfo().isCollection()) {
                        CommandLine.Model.UnmatchedArgsBinding unmatchedArgsBinding = annotatedElement.getTypeInfo().isArray() ? CommandLine.Model.UnmatchedArgsBinding.forStringArrayConsumer((CommandLine.Model.ISetter)annotatedElement.setter()) : CommandLine.Model.UnmatchedArgsBinding.forStringCollectionSupplier((CommandLine.Model.IGetter)annotatedElement.getter());
                        commandSpec1.addUnmatchedArgsBinding(unmatchedArgsBinding);
                        continue;
                    }
                    proc.error(entry.getKey(), "@Unmatched must be of type String[] or List<String> but was: %s", annotatedElement.getTypeInfo().getClassName());
                    continue;
                }
                proc.error(entry.getKey(), "@Unmatched must be enclosed in a @Command, but was %s: %s", entry.getKey().getEnclosingElement(), entry.getKey().getEnclosingElement().getSimpleName());
            }
            for (Map.Entry<Element, Object> entry : this.mixinInfoMap.entrySet()) {
                CommandLine.Model.CommandSpec mixee = (CommandLine.Model.CommandSpec)entry.getKey();
                for (MixinInfo mixinInfo : (Set)entry.getValue()) {
                    logger.fine(String.format("Adding mixin name=%s to %s", mixinInfo.mixinName(), mixee.name()));
                    mixee.addMixin(mixinInfo.mixinName(), mixinInfo.mixin(), mixinInfo.annotatedElement());
                }
            }
            for (CommandLine.Model.CommandSpec commandSpec2 : this.commandsRequestingStandardHelpOptions) {
                commandSpec2.mixinStandardHelpOptions(true);
            }
        }

        private boolean connectArgGroups(AbstractCommandSpecProcessor proc) {
            LinkedHashMap<Element, TypeElement> argGroupElementsToType = new LinkedHashMap<Element, TypeElement>();
            LinkedHashMap<TypeElement, TypeElement> groupTypeToParentGroupType = new LinkedHashMap<TypeElement, TypeElement>();
            LinkedHashMap<TypeElement, CommandLine.Model.ArgGroupSpec.Builder> argGroupsByType = new LinkedHashMap<TypeElement, CommandLine.Model.ArgGroupSpec.Builder>();
            for (Map.Entry<Element, CommandLine.Model.ArgGroupSpec.Builder> entry : this.argGroupElementsByVar.entrySet()) {
                Element argGroupElement = entry.getKey();
                CommandLine.Model.ArgGroupSpec.Builder builder = entry.getValue();
                DeclaredType declaredType = AbstractCommandSpecProcessor.getDeclaredTypeForArgGroupVarOrMethod(argGroupElement, proc);
                if (declaredType == null) {
                    return true;
                }
                Types types = proc.processingEnv.getTypeUtils();
                CompileTimeTypeInfo typeInfo = new CompileTimeTypeInfo(declaredType);
                TypeElement typeElement = (TypeElement)types.asElement(typeInfo.auxTypeMirrors.get(0));
                CommandLine.Model.CommandSpec argsHolder = this.commands.get(typeElement);
                if (argsHolder != null) {
                    for (CommandLine.Model.OptionSpec option : argsHolder.options()) {
                        builder.addArg((CommandLine.Model.ArgSpec)option);
                    }
                    for (CommandLine.Model.PositionalParamSpec positional : argsHolder.positionalParameters()) {
                        builder.addArg((CommandLine.Model.ArgSpec)positional);
                    }
                }
                argGroupsByType.put(typeElement, builder);
                argGroupElementsToType.put(argGroupElement, typeElement);
                Element enclosingElement = argGroupElement.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) continue;
                TypeElement enclosingType = (TypeElement)types.asElement(enclosingElement.asType());
                groupTypeToParentGroupType.put(typeElement, enclosingType);
            }
            Element[] lookup = new Element[this.argGroupElementsByVar.size()];
            Graph graph = new Graph(this.argGroupElementsByVar.size());
            int i = 0;
            LinkedHashMap typeToIndex = new LinkedHashMap();
            for (Map.Entry entry : this.argGroupElementsByVar.entrySet()) {
                Element argGroupElement;
                lookup[i] = argGroupElement = (Element)entry.getKey();
                typeToIndex.put(argGroupElementsToType.get(argGroupElement), i++);
            }
            for (Map.Entry entry : typeToIndex.entrySet()) {
                TypeElement type = (TypeElement)entry.getKey();
                Integer parentIndex = (Integer)typeToIndex.get(groupTypeToParentGroupType.get(type));
                if (parentIndex == null) continue;
                graph.addEdge((Integer)typeToIndex.get(type), parentIndex);
            }
            Stack<Integer> sortedGroups = graph.topologicalSort();
            logger.fine("@ArgGroup-annotated variables/methods: " + this.argGroupElementsByVar.toString());
            while (!sortedGroups.isEmpty()) {
                Element element = lookup[sortedGroups.pop()];
                CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = this.argGroupElementsByVar.get(element);
                logger.fine(String.format("ArgGroup args=%s, typeInfo=%s", argGroupBuilder.args(), argGroupBuilder.typeInfo()));
                CommandLine.Model.ArgGroupSpec group = argGroupBuilder.build();
                CommandLine.Model.CommandSpec commandSpec = Context.getOrCreateCommandSpecForArg(element, this.commands);
                logger.fine("Building ArgGroupSpec for " + element + " in command " + commandSpec);
                commandSpec.addArgGroup(group);
                Types typeUtils = proc.processingEnv.getTypeUtils();
                TypeElement parentGroupElement = (TypeElement)typeUtils.asElement(element.getEnclosingElement().asType());
                CommandLine.Model.ArgGroupSpec.Builder parentGroup = (CommandLine.Model.ArgGroupSpec.Builder)argGroupsByType.get(parentGroupElement);
                if (parentGroup == null) continue;
                for (Map.Entry<Element, CommandLine.Model.ArgGroupSpec.Builder> entry : this.argGroupElementsByVar.entrySet()) {
                    TypeMirror entryTypeMirror = entry.getKey().asType();
                    if (entryTypeMirror.getKind() != TypeKind.DECLARED && entryTypeMirror.getKind() != TypeKind.ARRAY) continue;
                    CompileTimeTypeInfo typeInfo = new CompileTimeTypeInfo(entryTypeMirror);
                    TypeElement elementType = (TypeElement)typeUtils.asElement(typeInfo.auxTypeMirrors.get(0));
                    if (elementType == null || !elementType.toString().equals(parentGroupElement.toString())) continue;
                    entry.getValue().addSubgroup(group);
                }
            }
            return false;
        }

        private static CommandLine.Model.CommandSpec getOrCreateCommandSpecForArg(Element argElement, Map<Element, CommandLine.Model.CommandSpec> commands) {
            Element key = argElement.getEnclosingElement();
            CommandLine.Model.CommandSpec commandSpec = commands.get(key);
            if (commandSpec == null) {
                logger.fine("Element " + argElement + " is enclosed by " + key + " which does not have a @Command annotation");
                commandSpec = CommandLine.Model.CommandSpec.forAnnotatedObjectLenient((Object)key);
                commandSpec.interpolateVariables(Boolean.valueOf(false));
                commands.put(key, commandSpec);
            }
            return commandSpec;
        }

        private void registerCommandType(CommandLine.Model.CommandSpec result, TypeElement typeElement) {
            List<CommandLine.Model.CommandSpec> forSubclass = this.commandTypes.get(typeElement.asType());
            if (forSubclass == null) {
                forSubclass = new ArrayList<CommandLine.Model.CommandSpec>();
                this.commandTypes.put(typeElement.asType(), forSubclass);
            }
            forSubclass.add(result);
        }
    }
}

