/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.vfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.gzip.GzipFileProvider;
import org.apache.commons.vfs2.provider.http5.Http5FileProvider;
import org.apache.commons.vfs2.provider.http5s.Http5sFileProvider;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.plugin.IVfs;
import org.apache.hop.core.vfs.plugin.VfsPluginType;
import org.apache.hop.i18n.BaseMessages;

public class HopVfs {
    private static final Class<?> PKG = HopVfs.class;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static DefaultFileSystemManager fsm;
    private static DefaultFileSystemManager extendedFsm;
    private static final ReentrantReadWriteLock lock;

    public static DefaultFileSystemManager getFileSystemManager() {
        lock.readLock().lock();
        try {
            if (fsm == null) {
                try {
                    fsm = HopVfs.createFileSystemManager();
                    fsm.init();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing file system manager : ", e);
                }
            }
            DefaultFileSystemManager defaultFileSystemManager = fsm;
            return defaultFileSystemManager;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultFileSystemManager getFileSystemManager(IVariables variables) {
        lock.readLock().lock();
        try {
            if (extendedFsm == null) {
                try {
                    extendedFsm = HopVfs.createFileSystemManager();
                    PluginRegistry registry = PluginRegistry.getInstance();
                    List plugins = registry.getPlugins(VfsPluginType.class);
                    for (IPlugin plugin : plugins) {
                        IVfs iVfs = registry.loadClass(plugin, IVfs.class);
                        try {
                            Map<String, FileProvider> fileProviderMap = iVfs.getProviders(variables);
                            if (fileProviderMap == null) continue;
                            for (Map.Entry<String, FileProvider> entry : fileProviderMap.entrySet()) {
                                extendedFsm.addProvider(entry.getKey(), entry.getValue());
                            }
                        }
                        catch (Exception e) {
                            throw new HopException("Error registering provider for VFS plugin " + plugin.getIds()[0] + " : " + plugin.getName() + " : ", e);
                        }
                    }
                    extendedFsm.init();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing file system manager : ", e);
                }
            }
            DefaultFileSystemManager defaultFileSystemManager = extendedFsm;
            return defaultFileSystemManager;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static DefaultFileSystemManager createFileSystemManager() throws HopException {
        try {
            DefaultFileSystemManager fsm = new DefaultFileSystemManager();
            fsm.addProvider("ram", (FileProvider)new RamFileProvider());
            fsm.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
            fsm.addProvider("res", (FileProvider)new ResourceFileProvider());
            fsm.addProvider("zip", (FileProvider)new ZipFileProvider());
            fsm.addProvider("gz", (FileProvider)new GzipFileProvider());
            fsm.addProvider("jar", (FileProvider)new JarFileProvider());
            fsm.addProvider("http", (FileProvider)new Http5FileProvider());
            fsm.addProvider("https", (FileProvider)new Http5sFileProvider());
            fsm.addProvider("ftp", (FileProvider)new FtpFileProvider());
            fsm.addProvider("ftps", (FileProvider)new FtpsFileProvider());
            fsm.addProvider("sftp", (FileProvider)new SftpFileProvider());
            fsm.addProvider("war", (FileProvider)new JarFileProvider());
            fsm.addProvider("par", (FileProvider)new JarFileProvider());
            fsm.addProvider("ear", (FileProvider)new JarFileProvider());
            fsm.addProvider("sar", (FileProvider)new JarFileProvider());
            fsm.addProvider("ejb3", (FileProvider)new JarFileProvider());
            fsm.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
            fsm.addProvider("tar", (FileProvider)new TarFileProvider());
            fsm.addProvider("tbz2", (FileProvider)new TarFileProvider());
            fsm.addProvider("tgz", (FileProvider)new TarFileProvider());
            fsm.addProvider("bz2", (FileProvider)new Bzip2FileProvider());
            fsm.addProvider("files-cache", (FileProvider)new TemporaryFileProvider());
            fsm.addExtensionMap("jar", "jar");
            fsm.addExtensionMap("zip", "zip");
            fsm.addExtensionMap("gz", "gz");
            fsm.addExtensionMap("tar", "tar");
            fsm.addExtensionMap("tbz2", "tar");
            fsm.addExtensionMap("tgz", "tar");
            fsm.addExtensionMap("bz2", "bz2");
            fsm.addMimeTypeMap("application/x-tar", "tar");
            fsm.addMimeTypeMap("application/x-gzip", "gz");
            fsm.addMimeTypeMap("application/zip", "zip");
            fsm.setFileContentInfoFactory((FileContentInfoFactory)new FileContentInfoFilenameFactory());
            fsm.setReplicator((FileReplicator)new DefaultFileReplicator());
            fsm.setFilesCache((FilesCache)new SoftRefFilesCache());
            fsm.setCacheStrategy(CacheStrategy.ON_RESOLVE);
            PluginRegistry registry = PluginRegistry.getInstance();
            List plugins = registry.getPlugins(VfsPluginType.class);
            for (IPlugin plugin : plugins) {
                IVfs iVfs = registry.loadClass(plugin, IVfs.class);
                try {
                    fsm.addProvider(iVfs.getUrlSchemes(), iVfs.getProvider());
                }
                catch (Exception e) {
                    throw new HopException("Error registering provider for VFS plugin " + plugin.getIds()[0] + " : " + plugin.getName() + " : ", e);
                }
            }
            return fsm;
        }
        catch (Exception e) {
            throw new HopException("Error creating file system manager", e);
        }
    }

    public static synchronized FileObject getFileObject(String vfsFilename, IVariables variables) throws HopFileException {
        lock.readLock().lock();
        try {
            DefaultFileSystemManager fsManager = HopVfs.getFileSystemManager(variables);
            try {
                String filename;
                boolean relativeFilename = true;
                String[] initialSchemes = fsManager.getSchemes();
                relativeFilename = HopVfs.checkForScheme(initialSchemes, relativeFilename, vfsFilename);
                if (vfsFilename.startsWith("\\\\")) {
                    file = new File(vfsFilename);
                    filename = file.toURI().toString();
                } else if (relativeFilename) {
                    file = new File(vfsFilename);
                    filename = file.getAbsolutePath();
                } else {
                    filename = vfsFilename;
                }
                FileObject fileObject = fsManager.resolveFile(filename);
                return fileObject;
            }
            catch (Exception e) {
                throw new HopFileException("Unable to get VFS File object for filename '" + HopVfs.cleanseFilename(vfsFilename) + "' : " + e.getMessage(), e);
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static synchronized FileObject getFileObject(String vfsFilename) throws HopFileException {
        lock.readLock().lock();
        try {
            DefaultFileSystemManager fsManager = HopVfs.getFileSystemManager();
            try {
                String filename;
                boolean relativeFilename = true;
                String[] initialSchemes = fsManager.getSchemes();
                relativeFilename = HopVfs.checkForScheme(initialSchemes, relativeFilename, vfsFilename);
                if (vfsFilename.startsWith("\\\\")) {
                    file = new File(vfsFilename);
                    filename = file.toURI().toString();
                } else if (relativeFilename) {
                    file = new File(vfsFilename);
                    filename = file.getAbsolutePath();
                } else {
                    filename = vfsFilename;
                }
                FileObject fileObject = fsManager.resolveFile(filename);
                return fileObject;
            }
            catch (Exception e) {
                throw new HopFileException("Unable to get VFS File object for filename '" + HopVfs.cleanseFilename(vfsFilename) + "' : " + e.getMessage(), e);
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected static boolean checkForScheme(String[] initialSchemes, boolean relativeFilename, String vfsFilename) {
        if (vfsFilename == null) {
            return false;
        }
        for (int i = 0; i < initialSchemes.length && relativeFilename; ++i) {
            if (!vfsFilename.startsWith(initialSchemes[i] + ":")) continue;
            relativeFilename = false;
        }
        return relativeFilename;
    }

    private static String cleanseFilename(String vfsFilename) {
        return vfsFilename.replaceAll(":[^:@/]+@", ":<password>@");
    }

    public static String getTextFileContent(String vfsFilename, String charSetName) throws HopFileException {
        try {
            int c;
            InputStream inputStream = HopVfs.getInputStream(vfsFilename);
            InputStreamReader reader = new InputStreamReader(inputStream, charSetName);
            StringBuilder aBuffer = new StringBuilder();
            while ((c = reader.read()) != -1) {
                aBuffer.append((char)c);
            }
            reader.close();
            inputStream.close();
            return aBuffer.toString();
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static boolean fileExists(String vfsFilename) throws HopFileException {
        FileObject fileObject = null;
        try {
            fileObject = HopVfs.getFileObject(vfsFilename);
            boolean bl = fileObject.exists();
            return bl;
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
        finally {
            if (fileObject != null) {
                try {
                    fileObject.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean fileExists(String vfsFilename, IVariables variables) throws HopFileException {
        FileObject fileObject = null;
        try {
            fileObject = HopVfs.getFileObject(vfsFilename, variables);
            boolean bl = fileObject.exists();
            return bl;
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
        finally {
            if (fileObject != null) {
                try {
                    fileObject.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static InputStream getInputStream(FileObject fileObject) throws FileSystemException {
        FileContent content = fileObject.getContent();
        return content.getInputStream();
    }

    public static InputStream getInputStream(String vfsFilename) throws HopFileException {
        try {
            FileObject fileObject = HopVfs.getFileObject(vfsFilename);
            return HopVfs.getInputStream(fileObject);
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static InputStream getInputStream(String vfsFilename, IVariables variables) throws HopFileException {
        try {
            FileObject fileObject = HopVfs.getFileObject(vfsFilename, variables);
            return HopVfs.getInputStream(fileObject);
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static OutputStream getOutputStream(FileObject fileObject, boolean append) throws IOException {
        FileObject parent = fileObject.getParent();
        if (parent != null && !parent.exists()) {
            throw new IOException(BaseMessages.getString(PKG, "HopVFS.Exception.ParentDirectoryDoesNotExist", HopVfs.getFriendlyURI(parent)));
        }
        try {
            if (fileObject.exists() && !append) {
                fileObject.delete();
            }
            fileObject.createFile();
            FileContent content = fileObject.getContent();
            return content.getOutputStream(append);
        }
        catch (FileSystemException e) {
            if (fileObject instanceof LocalFile) {
                try {
                    String filename = HopVfs.getFilename(fileObject);
                    return new FileOutputStream(new File(filename), append);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public static OutputStream getOutputStream(String vfsFilename, boolean append, IVariables variables) throws HopFileException {
        try {
            FileObject fileObject = HopVfs.getFileObject(vfsFilename, variables);
            return HopVfs.getOutputStream(fileObject, append);
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static OutputStream getOutputStream(String vfsFilename, boolean append) throws HopFileException {
        try {
            FileObject fileObject = HopVfs.getFileObject(vfsFilename);
            return HopVfs.getOutputStream(fileObject, append);
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static String getFilename(FileObject fileObject) {
        FileName fileName = fileObject.getName();
        String root = fileName.getRootURI();
        if (!root.startsWith("file:")) {
            return fileName.getURI();
        }
        if (root.startsWith("file:////")) {
            return fileName.getURI();
        }
        root = root.endsWith(":/") ? root.substring(8, 10) : "";
        Object fileString = root + fileName.getPath();
        if (!"/".equals(Const.FILE_SEPARATOR)) {
            fileString = Const.replace((String)fileString, "/", Const.FILE_SEPARATOR);
        }
        return fileString;
    }

    public static String getFriendlyURI(String filename) {
        String friendlyName;
        if (filename == null) {
            return null;
        }
        try {
            friendlyName = HopVfs.getFriendlyURI(HopVfs.getFileObject(filename));
        }
        catch (Exception e) {
            friendlyName = HopVfs.cleanseFilename(filename);
        }
        return friendlyName;
    }

    public static String getFriendlyURI(String filename, IVariables variables) {
        String friendlyName;
        if (filename == null) {
            return null;
        }
        try {
            friendlyName = HopVfs.getFriendlyURI(HopVfs.getFileObject(filename, variables));
        }
        catch (Exception e) {
            friendlyName = HopVfs.cleanseFilename(filename);
        }
        return friendlyName;
    }

    public static String getFriendlyURI(FileObject fileObject) {
        return fileObject.getName().getFriendlyURI();
    }

    public static FileObject createTempFile(String prefix, Suffix suffix) throws HopFileException {
        return HopVfs.createTempFile(prefix, suffix.ext, TEMP_DIR);
    }

    public static synchronized FileObject createTempFile(String prefix, String suffix, String directory) throws HopFileException {
        try {
            Object baseUrl;
            String filename;
            FileObject fileObject;
            do {
                if (directory.contains("://")) {
                    baseUrl = directory;
                    continue;
                }
                File directoryFile = new File(directory);
                baseUrl = "file://" + directoryFile.getAbsolutePath();
            } while ((fileObject = HopVfs.getFileObject(filename = (String)baseUrl + "/" + prefix + "_" + String.valueOf(UUID.randomUUID()) + suffix)).exists());
            return fileObject;
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static synchronized FileObject createTempFile(String prefix, String suffix, String directory, IVariables variables) throws HopFileException {
        try {
            Object baseUrl;
            String filename;
            FileObject fileObject;
            do {
                if (directory.contains("://")) {
                    baseUrl = directory;
                    continue;
                }
                File directoryFile = new File(directory);
                baseUrl = "file://" + directoryFile.getAbsolutePath();
            } while ((fileObject = HopVfs.getFileObject(filename = (String)baseUrl + "/" + prefix + "_" + String.valueOf(UUID.randomUUID()) + suffix, variables)).exists());
            return fileObject;
        }
        catch (IOException e) {
            throw new HopFileException(e);
        }
    }

    public static Comparator<FileObject> getComparator() {
        return (o1, o2) -> {
            String filename1 = HopVfs.getFilename(o1);
            String filename2 = HopVfs.getFilename(o2);
            return filename1.compareTo(filename2);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startsWithScheme(String vfsFileName, IVariables variables) {
        lock.readLock().lock();
        try {
            DefaultFileSystemManager fsManager = HopVfs.getFileSystemManager(variables);
            boolean found = false;
            String[] schemes = fsManager.getSchemes();
            for (int i = 0; i < schemes.length; ++i) {
                if (!vfsFileName.startsWith(schemes[i] + ":")) continue;
                found = true;
                break;
            }
            boolean bl = found;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static final List<FileObject> findFiles(FileObject folder, String extension, boolean includeSubFolders) throws Exception {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject child : folder.getChildren()) {
            if (child.isFolder() && includeSubFolders) {
                files.addAll(HopVfs.findFiles(child, extension, true));
                continue;
            }
            if (!StringUtils.isEmpty((String)extension) && !extension.equalsIgnoreCase(child.getName().getExtension())) continue;
            files.add(child);
        }
        return files;
    }

    public static void freeUnusedResources() {
        if (fsm != null) {
            fsm.freeUnusedResources();
        }
    }

    public static void reset() {
        if (fsm != null) {
            fsm.freeUnusedResources();
            fsm.close();
            fsm = null;
        }
        if (extendedFsm != null) {
            extendedFsm.freeUnusedResources();
            extendedFsm.close();
            extendedFsm = null;
        }
    }

    static {
        lock = new ReentrantReadWriteLock();
    }

    public static enum Suffix {
        ZIP(".zip"),
        TMP(".tmp"),
        JAR(".jar");

        private String ext;

        private Suffix(String ext) {
            this.ext = ext;
        }
    }
}

