/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.util.JsonUtil;

@ValueMetaPlugin(id="11", name="JSON", description="JSON object", image="images/json.svg")
public class ValueMetaJson
extends ValueMetaBase {
    private boolean prettyPrinting = true;

    public ValueMetaJson() {
        this((String)null);
    }

    public ValueMetaJson(String name) {
        super(name, 11);
    }

    @Override
    public String getString(Object object) throws HopValueException {
        return this.convertJsonToString(this.getJson(object));
    }

    @Override
    public String convertJsonToString(JsonNode jsonNode) throws HopValueException {
        try {
            return JsonUtil.mapJsonToString(jsonNode, this.prettyPrinting);
        }
        catch (Exception e) {
            throw new HopValueException("Error converting JSON value to String", e);
        }
    }

    @Override
    public Object cloneValueData(Object object) throws HopValueException {
        JsonNode jsonNode = this.getJson(object);
        if (jsonNode == null) {
            return null;
        }
        try {
            String jsonString = this.convertJsonToString(jsonNode);
            return this.convertStringToJson(jsonString);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to clone JSON value", e);
        }
    }

    @Override
    public JsonNode getJson(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        try {
            if (this.type == 11) {
                switch (this.storageType) {
                    case 2: {
                        object = this.index[(Integer)object];
                    }
                    case 0: {
                        if (object instanceof JsonNode) {
                            JsonNode node = (JsonNode)object;
                            return node;
                        }
                        return JsonUtil.mapObjectToJson(object);
                    }
                    case 1: {
                        return JsonUtil.parse((byte[])object);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HopValueException("Error converting bytes to JSON (" + String.valueOf(object) + ")", e);
        }
        return super.getJson(object);
    }

    private String[] getSortedKeys(JsonNode node) {
        int n = node.size();
        String[] sortedKeys = new String[n];
        int c = 0;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            for (int i = c - 1; i >= 0 && sortedKeys[i].compareTo(key) > 0; --i) {
                sortedKeys[i + 1] = sortedKeys[i];
            }
            sortedKeys[i + 1] = key;
            ++c;
        }
        return sortedKeys;
    }

    private static int kind(JsonNode n) throws HopValueException {
        if (n == null) {
            return 0;
        }
        return switch (n.getNodeType()) {
            case JsonNodeType.NULL -> 0;
            case JsonNodeType.MISSING -> 1;
            case JsonNodeType.BINARY -> 2;
            case JsonNodeType.STRING -> 3;
            case JsonNodeType.NUMBER -> 4;
            case JsonNodeType.BOOLEAN -> 5;
            case JsonNodeType.ARRAY -> 6;
            case JsonNodeType.OBJECT -> 7;
            default -> throw new HopValueException("Unsupported JsonNode type: " + String.valueOf(n.getNodeType()));
        };
    }

    protected int jsonCompare(JsonNode a, JsonNode b) throws HopValueException {
        int kindB;
        int kindA = ValueMetaJson.kind(a);
        if (kindA != (kindB = ValueMetaJson.kind(b))) {
            return Integer.compare(kindA, kindB);
        }
        return switch (a.getNodeType()) {
            case JsonNodeType.NULL, JsonNodeType.MISSING -> 0;
            case JsonNodeType.BINARY -> this.jsonCompareBinary(a, b);
            case JsonNodeType.STRING -> a.textValue().compareTo(b.textValue());
            case JsonNodeType.NUMBER -> a.decimalValue().compareTo(b.decimalValue());
            case JsonNodeType.BOOLEAN -> Boolean.compare(a.booleanValue(), b.booleanValue());
            case JsonNodeType.ARRAY -> this.jsonCompareArray(a, b);
            case JsonNodeType.OBJECT -> this.jsonCompareObject(a, b);
            default -> throw new HopValueException("Unsupported JsonNode type: " + String.valueOf(a.getNodeType()));
        };
    }

    private int jsonCompareBinary(JsonNode a, JsonNode b) throws HopValueException {
        byte[] binaryB;
        byte[] binaryA;
        try {
            binaryA = a.binaryValue();
            binaryB = b.binaryValue();
        }
        catch (Exception e) {
            binaryA = new byte[]{};
            binaryB = new byte[]{};
        }
        int min = Math.min(binaryA.length, binaryB.length);
        for (int i = 0; i < min; ++i) {
            int diff = (binaryA[i] & 0xFF) - (binaryB[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return binaryA.length - binaryB.length;
    }

    private int jsonCompareArray(JsonNode a, JsonNode b) throws HopValueException {
        int lengthB;
        int lengthA = a.size();
        if (lengthA != (lengthB = b.size())) {
            return Integer.compare(lengthA, lengthB);
        }
        for (int i = 0; i < lengthA; ++i) {
            int c = this.jsonCompare(a.get(i), b.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private int jsonCompareObject(JsonNode a, JsonNode b) throws HopValueException {
        String[] keysB;
        String[] keysA = this.getSortedKeys(a);
        if (keysA.length != (keysB = this.getSortedKeys(b)).length) {
            return Integer.compare(keysA.length, keysB.length);
        }
        for (int i = 0; i < keysA.length; ++i) {
            int keyCompare = keysA[i].compareTo(keysB[i]);
            if (keyCompare != 0) {
                return keyCompare;
            }
            int valueCompare = this.jsonCompare(a.get(keysA[i]), b.get(keysB[i]));
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        return 0;
    }

    @Override
    protected int typeCompare(Object object1, Object object2) throws HopValueException {
        JsonNode a = this.getJson(object1);
        JsonNode b = this.getJson(object2);
        return this.jsonCompare(a, b);
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws HopDatabaseException {
        try {
            JsonNode jn = this.getJson(data);
            if (jn == null) {
                preparedStatement.setNull(index, 1111);
                return;
            }
            if (databaseMeta.getIDatabase().isPostgresVariant()) {
                preparedStatement.setObject(index, (Object)jn, 1111);
                return;
            }
            preparedStatement.setString(index, this.convertJsonToString(jn));
        }
        catch (Exception e) {
            throw new HopDatabaseException("Error setting JSON value #" + index + " [" + this.toStringMeta() + "] on prepared statement", e);
        }
    }

    @Override
    public Object getValueFromResultSet(IDatabase iDatabase, ResultSet resultSet, int index) throws HopDatabaseException {
        JsonNode jsonNode;
        block11: {
            InputStream in = resultSet.getBinaryStream(index + 1);
            try {
                jsonNode = JsonUtil.parse(in);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    try {
                        Object o = resultSet.getObject(index + 1);
                        return JsonUtil.parseTextValue(o);
                    }
                    catch (SQLException ex) {
                        throw new HopDatabaseException("Unable to get JSON value '" + this.toStringMeta() + "' from database resultset, index " + index, e);
                    }
                    catch (Exception exp) {
                        throw new HopDatabaseException("Unable to read JSON value", exp);
                    }
                }
            }
            in.close();
        }
        return jsonNode;
    }

    @Override
    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getJson(object);
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return JsonNode.class;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    @Override
    public String getDatabaseColumnTypeDefinition(IDatabase iDatabase, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCr) {
        String col = addFieldName ? this.getName() + " " : "";
        String def = "JSON";
        if (iDatabase.isPostgresVariant()) {
            def = "JSONB";
        }
        return col + def + (addCr ? Const.CR : "");
    }
}

