/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseDeserializer;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseSerializer;
import com.clickhouse.data.format.BinaryStreamUtils;
import com.clickhouse.data.value.ClickHouseByteValue;
import com.clickhouse.data.value.ClickHouseLongValue;
import com.clickhouse.data.value.ClickHouseStringValue;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

@Deprecated
public final class Main {
    private static void println() {
        System.out.println();
    }

    private static void println(Object msg, Object ... args) {
        if (args == null || args.length == 0) {
            System.out.println(msg);
        } else {
            System.out.println(String.format(Locale.ROOT, Objects.toString(msg), args));
        }
    }

    private static void printUsage() {
        String execFile = "clickhouse-jdbc-bin";
        try {
            File file = Paths.get(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile();
            if (file.isFile()) {
                execFile = file.getName();
                if (!Files.isExecutable(file.toPath())) {
                    execFile = "java -jar " + execFile;
                }
            } else {
                execFile = "java -cp " + file.getCanonicalPath() + " " + Main.class.getName();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        int index = execFile.indexOf(32);
        Main.println("Usage: %s <URL> [QUERY] [FILE]", index > 0 ? execFile.substring(0, index) + " [PROPERTIES]" + execFile.substring(index) : execFile + " [PROPERTIES]");
        Main.println();
        Main.println("Properties: -Dkey=value [-Dkey=value]*", new Object[0]);
        Main.println("  action \tAction, one of read(default), write, dump(no deserialization), and load(no serialization)", new Object[0]);
        Main.println("  batch  \tBatch size for JDBC writing, defaults to 1000", new Object[0]);
        Main.println("  mapping\tWhether to map record into POJO, defaults to false", new Object[0]);
        Main.println("  output \tWhether to write raw response into stdout or a file(java.out or jdbc.out), defaults to false", new Object[0]);
        Main.println("  samples\tSamples, defaults to 500000000", new Object[0]);
        Main.println("  serde  \tWhether to use default serialization/deserializion mechanism in Java client, defaults to true", new Object[0]);
        Main.println("  type   \tPredefined QUERY, one of Int8, UInt64, String, Array, Tuple, Nested, and Mixed", new Object[0]);
        Main.println("  verbose\tWhether to show logs, defaults to false", new Object[0]);
        Main.println();
        Main.println("Examples:", new Object[0]);
        Main.println("  -  %s 'https://localhost?sslmode=none' 'select 1' -", index > 0 ? execFile.substring(0, index) + " -Dverbose=true" + execFile.substring(index) : execFile + " -Dverbose=true");
        Main.println("  -  %s 'jdbc:ch://user:password@localhost:8123/default' 'select 1' output.file", execFile);
        Main.println("  -  %s 'jdbc:ch:http://node1,node2,node3/default' 'insert into table1' input.file", execFile);
    }

    public static void main(String[] args) throws Exception {
        Options options;
        if (args == null || args.length < 1 || args.length > 3) {
            Main.printUsage();
            System.exit(0);
        }
        GenericQuery query = (options = new Options(args[0].trim(), args.length > 1 ? args[1].trim() : null, args.length > 2 ? args[2].trim() : null)).isInt8() ? new Int8Query(options) : (options.isUInt64() ? new UInt64Query(options) : (options.isString() ? new StringQuery(options) : (options.isMixed() ? new MixedQuery(options) : new GenericQuery(options))));
        long startTime = options.verbose ? System.nanoTime() : 0L;
        long rows = query.run();
        if (options.verbose) {
            long elapsedNanos = System.nanoTime() - startTime;
            Main.println("\nProcessed %,d rows in %,.2f ms (%,.2f rows/s)", rows, (double)elapsedNanos / 1000000.0, (double)rows * 1.0E9 / (double)elapsedNanos);
        }
        System.exit(rows > 0L ? 0 : 1);
    }

    private Main() {
    }

    static class Options {
        final String action = System.getProperty("action", "read").toLowerCase();
        final int batch = Integer.getInteger("batch", 1000);
        final boolean mapping = Boolean.getBoolean("mapping");
        final boolean output = Boolean.getBoolean("output");
        final int samples = Integer.getInteger("samples", 500000000);
        final boolean serde = !"false".equalsIgnoreCase(System.getProperty("serde", ""));
        final String type = System.getProperty("type", "").toLowerCase();
        final boolean verbose = Boolean.getBoolean("verbose");
        final String url;
        final String query;
        final String file;
        final boolean requiresJdbc;

        private Options(String url, String query, String file) {
            this.url = url;
            boolean bl = this.requiresJdbc = url.length() > 5 && "jdbc:".equalsIgnoreCase(url.substring(0, 5));
            this.query = query == null || query.isEmpty() ? (this.isLoadAction() || this.isWriteAction() ? this.getInsertQuery() : this.getSelectQuery()) : query;
            this.file = file == null || file.isEmpty() ? (this.output ? (this.requiresJdbc ? "jdbc.out" : "java.out") : "") : file;
            if (this.verbose) {
                Main.println("Arguments:", new Object[0]);
                Main.println("  -   url=%s", new Object[]{this.url});
                Main.println("  - query=%s", new Object[]{this.query});
                Main.println("  -  file=%s", new Object[]{this.file});
                Main.println();
                Main.println("Options:\n  - action=%s, batch=%d, mapping=%s,\n  - output=%s, samples=%d, serde=%s, type=%s", new Object[]{this.action, this.batch, this.mapping, this.output, this.samples, this.serde, this.type});
            }
        }

        int getSamples() {
            return this.samples;
        }

        boolean hasFile() {
            return !this.file.isEmpty();
        }

        boolean hasMapping() {
            return this.mapping;
        }

        boolean isDumpAction() {
            return "dump".equals(this.action);
        }

        boolean isLoadAction() {
            return "load".equals(this.action);
        }

        boolean isWriteAction() {
            return "write".equals(this.action);
        }

        boolean isInt8() {
            return "int8".equals(this.type);
        }

        boolean isUInt64() {
            return "uint64".equals(this.type);
        }

        boolean isString() {
            return "string".equals(this.type);
        }

        boolean isDateTime() {
            return "datetime".equals(this.type);
        }

        boolean isDecimal() {
            return "decimal".equals(this.type);
        }

        boolean isMixed() {
            return "mixed".equals(this.type);
        }

        boolean isArray() {
            return "array".equals(this.type);
        }

        boolean isTuple() {
            return "tuple".equals(this.type);
        }

        boolean isNested() {
            return "nested".equals(this.type);
        }

        boolean isJson() {
            return "json".equals(this.type);
        }

        List<ClickHouseColumn> getColumns() {
            List<ClickHouseColumn> columns = this.isInt8() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Int8, false, new ClickHouseColumn[0])) : (this.isUInt64() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.UInt64, false, new ClickHouseColumn[0])) : (this.isString() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.String, false, new ClickHouseColumn[0])) : (this.isDateTime() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.DateTime, false, new ClickHouseColumn[0])) : (this.isDecimal() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Decimal128, false, 0, 6)) : (this.isMixed() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Int8, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.UInt64, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.DateTime, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.Decimal128, false, 0, 6)) : (this.isArray() ? Arrays.asList(ClickHouseColumn.of(null, "Array(Int32)")) : (this.isTuple() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Tuple, false, ClickHouseColumn.of(null, ClickHouseDataType.Int8, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.UInt64, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.DateTime, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.Decimal128, false, 0, 6))) : (this.isNested() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Nested, false, ClickHouseColumn.of(null, ClickHouseDataType.Int8, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.UInt64, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.DateTime, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.Decimal128, false, 0, 6))) : (this.isJson() ? Arrays.asList(ClickHouseColumn.of(null, ClickHouseDataType.Tuple, false, ClickHouseColumn.of(null, ClickHouseDataType.Int8, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.UInt64, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.DateTime, false, new ClickHouseColumn[0]), ClickHouseColumn.of(null, ClickHouseDataType.Decimal128, false, 0, 6))) : null)))))))));
            return columns;
        }

        ClickHouseDeserializer getDerializer(ClickHouseConfig config) throws IOException {
            List<ClickHouseColumn> columns = this.getColumns();
            if (columns == null || columns.isEmpty()) {
                throw new IllegalStateException("Not column information available for query: " + this.query);
            }
            ClickHouseDataProcessor processor = ClickHouseDataStreamFactory.getInstance().getProcessor(config, null, ClickHouseOutputStream.empty(), null, columns);
            ClickHouseDeserializer[] deserializers = processor.getDeserializers(config, columns);
            return deserializers.length == 1 ? deserializers[0] : ClickHouseDeserializer.of(Arrays.asList(deserializers));
        }

        ClickHouseSerializer getSerializer(ClickHouseConfig config) throws IOException {
            ClickHouseSerializer[] serializers = this.getSerializers(config);
            return serializers.length == 1 ? serializers[0] : ClickHouseSerializer.of(Arrays.asList(serializers));
        }

        ClickHouseSerializer[] getSerializers(ClickHouseConfig config) throws IOException {
            List<ClickHouseColumn> columns = this.getColumns();
            if (columns == null || columns.isEmpty()) {
                throw new IllegalStateException("Not column information available for query: " + this.query);
            }
            ClickHouseDataProcessor processor = ClickHouseDataStreamFactory.getInstance().getProcessor(config, null, ClickHouseOutputStream.empty(), null, columns);
            return processor.getSerializers(config, columns);
        }

        String getSelectQuery() {
            String selectQuery = this.isInt8() ? "select number::Int8 `byte` from numbers(%d)" : (this.isUInt64() ? "select number `long` from numbers(%d)" : (this.isString() ? "select toString(number) `string` from numbers(%d)" : (this.isDateTime() ? "select toDateTime(number) `datetime` from numbers(%d)" : (this.isDecimal() ? "select toDecimal128(number, 6) `decimal` from numbers(%d)" : (this.isMixed() ? "select number::Int8 `byte`, number `long`, toString(number) `string`, toDateTime(number) `datetime`, toDecimal128(number, 6) `decimal` from numbers(%d)" : (this.isArray() ? "select range(100000, 101000 + number %% 1000) as `array` from numbers(%d)" : (this.isTuple() ? "select tuple(number::Int8, number, toString(number), toDateTime(number), toDecimal128(number, 6)) `tuple` from numbers(%d)" : (this.isNested() ? "select [(number::Int8, number, toString(number), toDateTime(number), toDecimal128(number, 6))]::Nested(a Int8, b UInt64, c String, d DateTime, e Decimal128(6)) `nested` from numbers(%d)" : (this.isJson() ? "select (number::Int8, number, toString(number), toDateTime(number), toDecimal128(number, 6), range(1000,1005), [tuple(number, number+1)])::Tuple(a Int8, b UInt64, c String, d DateTime, e Decimal128(6), f Array(UInt16), g Nested(x UInt64, y UInt64)) `json` from numbers(%d)" : "select %d")))))))));
            return String.format(selectQuery, this.getSamples());
        }

        String getInsertQuery() {
            return this.type.isEmpty() ? "insert into test_insert" : "insert into test_insert_" + this.type;
        }
    }

    static class Int8Query
    extends GenericQuery {
        Int8Query(Options options) {
            super(options);
        }

        @Override
        long read(ResultSet rs) throws SQLException {
            long count = 0L;
            int len = rs.getMetaData().getColumnCount();
            int v = 0;
            while (rs.next()) {
                for (int i = 1; i <= len; ++i) {
                    v = rs.getByte(i);
                }
                ++count;
            }
            long lastValue = 0xFFL & (long)v;
            return count >= lastValue ? count : lastValue;
        }

        @Override
        long read(ClickHouseResponse response) throws ClickHouseException {
            long lastValue;
            long count = 0L;
            int v = 0;
            if (this.options.serde) {
                if (this.options.verbose) {
                    Main.println("Deserialization: records", new Object[0]);
                }
                for (ClickHouseRecord r : response.records()) {
                    v = r.getValue(0).asByte();
                    ++count;
                }
            } else {
                if (this.options.verbose) {
                    Main.println("Deserialization: readByte", new Object[0]);
                }
                try (ClickHouseInputStream in = response.getInputStream();){
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        v = in.readByte();
                        ++count;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return count >= (lastValue = 0xFFL & (long)v) ? count : lastValue;
        }

        @Override
        long write(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.options.query);){
                int batchSize = this.options.batch;
                long count = 0L;
                long rows = 0L;
                long len = this.options.getSamples();
                for (long i = 0L; i < len; ++i) {
                    stmt.setByte(1, (byte)i);
                    stmt.addBatch();
                    count = (i + 1L) % (long)batchSize;
                    if (count != 0L) continue;
                    rows += (long)stmt.executeLargeBatch().length;
                }
                if (count > 0L) {
                    rows += (long)stmt.executeLargeBatch().length;
                }
                long l = rows;
                return l;
            }
        }

        @Override
        long write(ClickHouseRequest.Mutation request) throws ClickHouseException {
            try (ClickHouseResponse response = request.data(o -> {
                if (this.options.serde) {
                    ClickHouseConfig config = request.getConfig();
                    ClickHouseSerializer serializer = this.options.getSerializer(config);
                    ClickHouseByteValue value = ClickHouseByteValue.ofNull();
                    if (this.options.verbose) {
                        Main.println("Serialization: %s -> %s", new Object[]{serializer, value});
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        serializer.serialize(value.update(i), o);
                    }
                } else {
                    if (this.options.verbose) {
                        Main.println("Serialization: writeByte", new Object[0]);
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        o.writeByte((byte)i);
                    }
                }
            }).executeAndWait();){
                long l = response.getSummary().getWrittenRows();
                return l;
            }
        }
    }

    static class UInt64Query
    extends GenericQuery {
        UInt64Query(Options options) {
            super(options);
        }

        @Override
        long read(ResultSet rs) throws SQLException {
            long count = 0L;
            int len = rs.getMetaData().getColumnCount();
            long v = 0L;
            while (rs.next()) {
                for (int i = 1; i <= len; ++i) {
                    v = rs.getLong(i);
                }
                ++count;
            }
            return count >= v ? count : v;
        }

        @Override
        long read(ClickHouseResponse response) throws ClickHouseException {
            long count = 0L;
            long v = 0L;
            if (this.options.serde) {
                if (this.options.verbose) {
                    Main.println("Deserialization: records", new Object[0]);
                }
                for (ClickHouseRecord r : response.records()) {
                    v = r.getValue(0).asLong();
                    ++count;
                }
            } else {
                if (this.options.verbose) {
                    Main.println("Deserialization: readByte", new Object[0]);
                }
                try (ClickHouseInputStream in = response.getInputStream();){
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        v = in.readBuffer(8).asLong();
                        ++count;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return count >= v ? count : v;
        }

        @Override
        long write(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.options.query);){
                int batchSize = this.options.batch;
                long count = 0L;
                long rows = 0L;
                long len = this.options.getSamples();
                for (long i = 0L; i < len; ++i) {
                    stmt.setLong(1, i);
                    stmt.addBatch();
                    count = (i + 1L) % (long)batchSize;
                    if (count != 0L) continue;
                    rows += (long)stmt.executeLargeBatch().length;
                }
                if (count > 0L) {
                    rows += (long)stmt.executeLargeBatch().length;
                }
                long l = rows;
                return l;
            }
        }

        @Override
        long write(ClickHouseRequest.Mutation request) throws ClickHouseException {
            try (ClickHouseResponse response = request.data(o -> {
                if (this.options.serde) {
                    ClickHouseConfig config = request.getConfig();
                    ClickHouseSerializer serializer = this.options.getSerializer(config);
                    ClickHouseLongValue value = ClickHouseLongValue.ofUnsignedNull();
                    if (this.options.verbose) {
                        Main.println("Serialization: %s -> %s", new Object[]{serializer, value});
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        serializer.serialize(value.update(i), o);
                    }
                } else {
                    if (this.options.verbose) {
                        Main.println("Serialization: writeLong", new Object[0]);
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        BinaryStreamUtils.writeUnsignedInt64((OutputStream)o, i);
                    }
                }
            }).executeAndWait();){
                long l = response.getSummary().getWrittenRows();
                return l;
            }
        }
    }

    static class StringQuery
    extends GenericQuery {
        StringQuery(Options options) {
            super(options);
        }

        @Override
        long read(ResultSet rs) throws SQLException {
            long count = 0L;
            int len = rs.getMetaData().getColumnCount();
            String v = null;
            while (rs.next()) {
                for (int i = 1; i <= len; ++i) {
                    v = rs.getString(i);
                }
                ++count;
            }
            return v != null ? count : 0L;
        }

        @Override
        long read(ClickHouseResponse response) throws ClickHouseException {
            long count = 0L;
            String v = null;
            if (this.options.serde) {
                if (this.options.verbose) {
                    Main.println("Deserialization: records", new Object[0]);
                }
                for (ClickHouseRecord r : response.records()) {
                    v = r.getValue(0).asString();
                    ++count;
                }
            } else {
                if (this.options.verbose) {
                    Main.println("Deserialization: readByte", new Object[0]);
                }
                try (ClickHouseInputStream in = response.getInputStream();){
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        v = in.readUnicodeString();
                        ++count;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return v != null ? count : 0L;
        }

        @Override
        long write(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.options.query);){
                int batchSize = this.options.batch;
                long count = 0L;
                long rows = 0L;
                long len = this.options.getSamples();
                for (long i = 0L; i < len; ++i) {
                    stmt.setString(1, Long.toString(i));
                    stmt.addBatch();
                    count = (i + 1L) % (long)batchSize;
                    if (count != 0L) continue;
                    rows += (long)stmt.executeLargeBatch().length;
                }
                if (count > 0L) {
                    rows += (long)stmt.executeLargeBatch().length;
                }
                long l = rows;
                return l;
            }
        }

        @Override
        long write(ClickHouseRequest.Mutation request) throws ClickHouseException {
            try (ClickHouseResponse response = request.data(o -> {
                if (this.options.serde) {
                    ClickHouseConfig config = request.getConfig();
                    ClickHouseSerializer serializer = this.options.getSerializer(config);
                    ClickHouseStringValue value = ClickHouseStringValue.ofNull();
                    if (this.options.verbose) {
                        Main.println("Serialization: %s -> %s", new Object[]{serializer, value});
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        serializer.serialize(value.update(i), o);
                    }
                } else {
                    if (this.options.verbose) {
                        Main.println("Serialization: writeString", new Object[0]);
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        o.writeUnicodeString(Long.toString(i));
                    }
                }
            }).executeAndWait();){
                long l = response.getSummary().getWrittenRows();
                return l;
            }
        }
    }

    static class MixedQuery
    extends GenericQuery {
        MixedQuery(Options options) {
            super(options);
        }

        @Override
        long read(ResultSet rs) throws SQLException {
            long count = 0L;
            int b = 0;
            long l = 0L;
            String s = null;
            Object t = null;
            BigDecimal d = null;
            while (rs.next()) {
                b = rs.getByte(1);
                l = rs.getLong(2);
                s = rs.getString(3);
                t = rs.getObject(4);
                d = rs.getBigDecimal(5);
                ++count;
            }
            return l > (long)b && l > 0L && s != null && t != null && d != null ? count : 0L;
        }

        @Override
        long read(ClickHouseResponse response) throws ClickHouseException {
            long count = 0L;
            int b = 0;
            long l = 0L;
            String s = null;
            LocalDateTime t = null;
            BigDecimal d = null;
            if (this.options.serde) {
                if (this.options.verbose) {
                    Main.println("Deserialization: records", new Object[0]);
                }
                for (ClickHouseRecord r : response.records()) {
                    b = r.getValue(0).asByte();
                    l = r.getValue(1).asLong();
                    s = r.getValue(2).asString();
                    t = r.getValue(3).asDateTime();
                    d = r.getValue(4).asBigDecimal();
                    ++count;
                }
                if (l <= (long)b || l <= 0L || t == null || d == null) {
                    s = null;
                }
            } else {
                if (this.options.verbose) {
                    Main.println("Deserialization: read(Byte, Long, String, DateTime, Decimal)", new Object[0]);
                }
                try (ClickHouseInputStream in = response.getInputStream();){
                    response.getColumns();
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        b = in.readByte();
                        l = in.readBuffer(8).asLong();
                        s = in.readUnicodeString();
                        t = in.readBuffer(4).asDateTime();
                        d = in.readBuffer(16).asBigDecimal(6);
                        ++count;
                    }
                    if (l > (long)b && l > 0L && t != null && d != null) {
                    } else {
                        s = null;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return s != null ? count : 0L;
        }

        @Override
        long write(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.options.query);){
                int batchSize = this.options.batch;
                long count = 0L;
                long rows = 0L;
                long len = this.options.getSamples();
                for (long i = 0L; i < len; ++i) {
                    stmt.setByte(1, (byte)(i % 256L));
                    stmt.setLong(2, i);
                    stmt.setString(3, Long.toString(i));
                    stmt.setLong(4, i);
                    stmt.setLong(5, i);
                    stmt.addBatch();
                    count = (i + 1L) % (long)batchSize;
                    if (count != 0L) continue;
                    rows += (long)stmt.executeLargeBatch().length;
                }
                if (count > 0L) {
                    rows += (long)stmt.executeLargeBatch().length;
                }
                long l = rows;
                return l;
            }
        }

        @Override
        long write(ClickHouseRequest.Mutation request) throws ClickHouseException {
            try (ClickHouseResponse response = request.data(o -> {
                if (this.options.serde) {
                    ClickHouseConfig config = request.getConfig();
                    ClickHouseSerializer[] serializers = this.options.getSerializers(config);
                    ClickHouseLongValue value = ClickHouseLongValue.ofNull();
                    if (this.options.verbose) {
                        Main.println("Serialization: %s -> %s", new Object[]{serializers, value});
                    }
                    long len = this.options.samples;
                    long l = serializers.length;
                    for (long i = 0L; i < len; ++i) {
                        int j = 0;
                        while ((long)j < l) {
                            serializers[j].serialize(value.update(i), o);
                            ++j;
                        }
                    }
                } else {
                    if (this.options.verbose) {
                        Main.println("Serialization: read(Byte, Long, String, DateTime, Decimal)", new Object[0]);
                    }
                    long len = this.options.samples;
                    for (long i = 0L; i < len; ++i) {
                        o.writeByte((byte)(i % 256L));
                        BinaryStreamUtils.writeUnsignedInt64((OutputStream)o, i);
                        o.writeUnicodeString(Long.toString(i));
                        BinaryStreamUtils.writeUnsignedInt32(o, i);
                        BinaryStreamUtils.writeInt128(o, BigInteger.valueOf(i));
                    }
                }
            }).executeAndWait();){
                long l = response.getSummary().getWrittenRows();
                return l;
            }
        }
    }

    static class GenericQuery {
        static final ClickHouseFormat defaultFormat = ClickHouseFormat.RowBinaryWithNamesAndTypes;
        protected final Options options;

        protected GenericQuery(Options options) {
            this.options = options;
        }

        final long run() throws ClickHouseException, SQLException {
            long rows = this.options.isDumpAction() ? this.dump() : (this.options.isLoadAction() ? this.load(this.options) : (this.options.isWriteAction() ? this.write(this.options) : this.read(this.options)));
            return rows;
        }

        long read(ResultSet rs) throws SQLException {
            long count = 0L;
            int len = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Object obj = null;
                for (int i = 1; i <= len; ++i) {
                    obj = rs.getObject(i);
                }
                if (obj == null) continue;
                ++count;
            }
            return count;
        }

        long read(ClickHouseResponse response) throws ClickHouseException {
            long count = 0L;
            int len = response.getColumns().size();
            for (ClickHouseRecord r : response.records()) {
                Object obj = null;
                for (int i = 0; i < len; ++i) {
                    obj = r.getValue(i).asObject();
                }
                if (obj == null) continue;
                ++count;
            }
            return count;
        }

        long write(Connection conn) throws SQLException {
            throw new UnsupportedOperationException("No idea how to write data for custom query");
        }

        long write(ClickHouseRequest.Mutation request) throws ClickHouseException {
            throw new UnsupportedOperationException("No idea how to write data for custom query");
        }

        final long dump() throws ClickHouseException, SQLException {
            long rows;
            block26: {
                if (this.options.requiresJdbc) {
                    try (ClickHouseConnectionImpl conn = new ClickHouseConnectionImpl(this.options.url);){
                        Object request = conn.unwrap(ClickHouseRequest.class).query(this.options.query);
                        if (!((ClickHouseRequest)request).getServer().getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                            ((ClickHouseRequest)request).format(defaultFormat);
                        }
                        ((ClickHouseRequest)request).output(this.options.file);
                        try (ClickHouseResponse response = ((ClickHouseRequest)request).executeAndWait();){
                            rows = response.getSummary().getReadRows();
                            break block26;
                        }
                    }
                }
                ClickHouseNode server = ClickHouseNode.of(this.options.url);
                try (ClickHouseClient client = ClickHouseClient.newInstance(server.getProtocol());){
                    Object request = client.read(server).query(this.options.query);
                    if (!server.getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                        ((ClickHouseRequest)request).format(defaultFormat);
                    }
                    ((ClickHouseRequest)request).output(this.options.file);
                    try (ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)request).query(this.options.query)).executeAndWait();){
                        rows = response.getSummary().getReadRows();
                    }
                }
            }
            return rows;
        }

        final long load(Options options) throws ClickHouseException, SQLException {
            long rows;
            block26: {
                if (options.requiresJdbc) {
                    try (ClickHouseConnectionImpl conn = new ClickHouseConnectionImpl(options.url);){
                        ClickHouseFormat format = conn.getConfig().getFormat();
                        if (!conn.unwrap(ClickHouseRequest.class).getServer().getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                            format = defaultFormat.defaultInputFormat();
                        }
                        try (PreparedStatement stmt = conn.prepareStatement(options.query + " format " + format.name());){
                            stmt.setObject(1, new File(options.file));
                            rows = stmt.executeLargeUpdate();
                            break block26;
                        }
                    }
                }
                ClickHouseNode server = ClickHouseNode.of(options.url);
                try (ClickHouseClient client = ClickHouseClient.newInstance(server.getProtocol());){
                    ClickHouseRequest.Mutation request = client.write(server).data(options.file);
                    if (!server.getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                        request.format(defaultFormat.defaultInputFormat());
                    }
                    try (ClickHouseResponse response = ((ClickHouseRequest.Mutation)request.query(options.query + " format " + request.getConfig().getFormat().name())).executeAndWait();){
                        rows = response.getSummary().getWrittenRows();
                    }
                }
            }
            return rows;
        }

        final long read(Options options) throws ClickHouseException, SQLException {
            long rows;
            block40: {
                if (options.requiresJdbc) {
                    try (ClickHouseConnectionImpl conn = new ClickHouseConnectionImpl(options.url);
                         ClickHouseStatement stmt = conn.createStatement();){
                        if (options.hasFile()) {
                            try {
                                stmt.setMirroredOutput(!"-".equals(options.file) ? new FileOutputStream(options.file, false) : System.out);
                            }
                            catch (IOException e) {
                                throw SqlExceptionUtils.clientError(e);
                            }
                        }
                        try (ResultSet rs = stmt.executeQuery(options.query);){
                            rows = this.read(rs);
                            break block40;
                        }
                    }
                }
                ClickHouseNode server = ClickHouseNode.of(options.url);
                try (ClickHouseClient client = ClickHouseClient.newInstance(server.getProtocol());){
                    Object request = client.read(server).query(options.query);
                    if (!server.getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                        ((ClickHouseRequest)request).format(defaultFormat);
                    }
                    try (ClickHouseResponse response = ((ClickHouseRequest)request).executeAndWait();){
                        if (options.hasFile()) {
                            try {
                                response.getInputStream().setCopyToTarget(!"-".equals(options.file) ? new FileOutputStream(options.file, false) : System.out);
                            }
                            catch (IOException e) {
                                throw ClickHouseException.of(e, server);
                            }
                        }
                        if (options.hasMapping()) {
                            long count = 0L;
                            for (Pojo p : response.records(Pojo.class)) {
                                if (p == null) continue;
                                ++count;
                            }
                            rows = count;
                        } else {
                            rows = this.read(response);
                        }
                    }
                }
            }
            return rows;
        }

        final long write(Options options) throws ClickHouseException, SQLException {
            long rows;
            if (options.requiresJdbc) {
                try (ClickHouseConnectionImpl conn = new ClickHouseConnectionImpl(options.url);){
                    rows = this.write(conn);
                }
            }
            ClickHouseNode server = ClickHouseNode.of(options.url);
            try (ClickHouseClient client = ClickHouseClient.newInstance(server.getProtocol());){
                ClickHouseRequest.Mutation request = ((ClickHouseRequest.Mutation)client.write(server).query(options.query)).data(options.file);
                if (!server.getConfig().hasOption(ClickHouseClientOption.FORMAT)) {
                    request.format(defaultFormat.defaultInputFormat());
                }
                rows = this.write(request);
            }
            return rows;
        }
    }

    public static class Pojo {
        private byte b;
        private long l;
        private BigDecimal d;
        private LocalDateTime t;
        private long[] a;
        private List<?> p;
        private Object[][] n;
        private Object j;

        public void setByte(byte b) {
            this.b = b;
        }

        public byte getByte() {
            return this.b;
        }

        public void setLong(long l) {
            this.l = l;
        }

        public long getLong() {
            return this.l;
        }

        public void setDecimal(BigDecimal d) {
            this.d = d;
        }

        public BigDecimal getDecimal() {
            return this.d;
        }

        public void setDateTime(LocalDateTime t) {
            this.t = t;
        }

        public LocalDateTime getDateTime() {
            return this.t;
        }

        public void setArray(long[] a) {
            this.a = a;
        }

        public long[] getArray() {
            return this.a;
        }

        public void setTuple(List<?> p) {
            this.p = p;
        }

        public List<?> getTuple() {
            return this.p;
        }

        public void setNested(Object[][] n) {
            this.n = n;
        }

        public Object[][] getNested() {
            return this.n;
        }

        public void setJson(Object j) {
            this.j = j;
        }

        public Object getJson() {
            return this.j;
        }
    }
}

