/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.roaringbitmap.insights;

import com.clickhouse.client.internal.org.roaringbitmap.ContainerPointer;
import com.clickhouse.client.internal.org.roaringbitmap.RoaringBitmap;
import com.clickhouse.client.internal.org.roaringbitmap.insights.BitmapStatistics;
import java.util.Collection;

public class BitmapAnalyser {
    public static BitmapStatistics analyse(RoaringBitmap r) {
        int acCount = 0;
        int acCardinalitySum = 0;
        int bcCount = 0;
        int rcCount = 0;
        ContainerPointer cp = r.getContainerPointer();
        while (cp.getContainer() != null) {
            if (cp.isBitmapContainer()) {
                ++bcCount;
            } else if (cp.isRunContainer()) {
                ++rcCount;
            } else {
                ++acCount;
                acCardinalitySum += cp.getCardinality();
            }
            cp.advance();
        }
        BitmapStatistics.ArrayContainersStats acStats = new BitmapStatistics.ArrayContainersStats(acCount, acCardinalitySum);
        return new BitmapStatistics(acStats, bcCount, rcCount);
    }

    public static BitmapStatistics analyse(Collection<? extends RoaringBitmap> bitmaps) {
        return bitmaps.stream().reduce(BitmapStatistics.empty, (acc, r) -> acc.merge(BitmapAnalyser.analyse(r)), BitmapStatistics::merge);
    }
}

