/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ava
implements Externalizable,
Cloneable,
Comparable<Ava> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Ava.class);
    String normType;
    String upType;
    Value value;
    String upName;
    AttributeType attributeType;
    private transient SchemaManager schemaManager;
    private volatile int h;

    public Ava() {
        this(null);
    }

    public Ava(SchemaManager schemaManager) {
        this.normType = null;
        this.upType = null;
        this.value = null;
        this.upName = "";
        this.schemaManager = schemaManager;
        this.attributeType = null;
    }

    public Ava(SchemaManager schemaManager, Ava ava) throws LdapInvalidDnException {
        this.upType = ava.upType;
        this.schemaManager = schemaManager;
        if (ava.isSchemaAware()) {
            this.normType = ava.normType;
            this.value = ava.value;
            this.attributeType = ava.getAttributeType();
        } else if (schemaManager != null) {
            this.attributeType = schemaManager.getAttributeType(ava.normType);
            if (this.attributeType != null) {
                this.normType = this.attributeType.getOid();
                try {
                    this.value = new Value(this.attributeType, ava.value);
                }
                catch (LdapInvalidAttributeValueException e) {
                    throw new LdapInvalidDnException(e.getResultCode());
                }
            } else {
                this.normType = ava.normType;
                this.value = ava.value;
            }
        } else {
            this.normType = ava.normType;
            this.value = ava.value;
        }
        this.upName = this.getEscaped();
        this.hashCode();
    }

    public Ava(String upType, byte[] upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
    }

    public Ava(SchemaManager schemaManager, String upType, String upName, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
        this.upName = upName;
    }

    public Ava(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
    }

    public Ava(SchemaManager schemaManager, String upType, String upName, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
        this.upName = upName;
    }

    Ava(String upType, String normType, Value value, String upName) throws LdapInvalidDnException {
        this(null, upType, normType, value, upName);
    }

    Ava(AttributeType attributeType, String upType, String normType, Value value, String upName) throws LdapInvalidDnException {
        this.attributeType = attributeType;
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = normType;
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.value = value;
        this.upName = upName;
        this.hashCode();
    }

    Ava(SchemaManager schemaManager, String upType, String normType, Value value) throws LdapInvalidDnException {
        StringBuilder sb = new StringBuilder();
        this.upType = upType;
        this.normType = normType;
        this.value = value;
        sb.append(upType);
        sb.append('=');
        if (value != null && value.getString() != null) {
            sb.append(value.getString());
        }
        this.upName = sb.toString();
        if (schemaManager != null) {
            this.apply(schemaManager);
        }
        this.hashCode();
    }

    private void createAva(SchemaManager schemaManager, String upType, Value value) {
        StringBuilder sb = new StringBuilder();
        this.normType = this.attributeType.getOid();
        this.upType = upType;
        this.value = value;
        sb.append(upType);
        sb.append('=');
        if (value != null) {
            sb.append(Rdn.escapeValue(value.getString()));
        }
        this.upName = sb.toString();
        this.hashCode();
    }

    private void createAva(String upType, Value upValue) throws LdapInvalidDnException {
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)this.normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.upType = this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.value = upValue;
        this.upName = this.getEscaped();
        this.hashCode();
    }

    private void apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            AttributeType tmpAttributeType = null;
            try {
                tmpAttributeType = schemaManager.lookupAttributeTypeRegistry(this.normType);
            }
            catch (LdapException le) {
                if (schemaManager.isRelaxed()) {
                    return;
                }
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            if (this.attributeType == tmpAttributeType) {
                return;
            }
            this.attributeType = tmpAttributeType;
            try {
                this.value = new Value(tmpAttributeType, this.value);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.hashCode();
        }
    }

    public String getNormType() {
        return this.normType;
    }

    public String getType() {
        return this.upType;
    }

    public Value getValue() {
        return this.value.clone();
    }

    public String getName() {
        return this.upName;
    }

    public String getEscaped() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append('=');
        sb.append(this.value.getEscaped());
        return sb.toString();
    }

    public Ava clone() {
        try {
            Ava clone = (Ava)super.clone();
            clone.value = this.value.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error(I18n.err((I18n)I18n.ERR_13621_ASSERTION_FAILURE, (Object[])new Object[0]), cnse);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            int hTmp = 37;
            hTmp = hTmp * 17 + (this.normType != null ? this.normType.hashCode() : 0);
            this.h = hTmp * 17 + (this.value != null ? this.value.hashCode() : 0);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ava)) {
            return false;
        }
        Ava instance = (Ava)obj;
        if (this.attributeType == null ? (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) : (instance.getAttributeType() == null ? this.schemaManager != null && !this.attributeType.equals(this.schemaManager.getAttributeType(instance.getType())) : !this.attributeType.equals(instance.getAttributeType()))) {
            return false;
        }
        if (this.value == null || this.value.isNull()) {
            return instance.value == null || instance.value.isNull();
        }
        if (this.schemaManager != null) {
            MatchingRule equalityMatchingRule;
            if (this.value.getString() != null && this.value.getString().equals(instance.value.getString())) {
                return true;
            }
            if (this.attributeType == null) {
                this.attributeType = this.schemaManager.getAttributeType(this.normType);
            }
            if ((equalityMatchingRule = this.attributeType.getEquality()) != null) {
                Normalizer normalizer = equalityMatchingRule.getNormalizer();
                try {
                    return equalityMatchingRule.getLdapComparator().compare(normalizer.normalize(this.value.getString()), instance.value.getString()) == 0;
                }
                catch (LdapException le) {
                    LOG.error(I18n.err((I18n)I18n.ERR_13620_CANNOT_NORMALIZE_VALUE, (Object[])new Object[0]), (Object)le.getMessage());
                    return false;
                }
            }
            if (!this.value.isHumanReadable()) {
                return Arrays.equals(this.value.getBytes(), instance.value.getBytes());
            }
            return this.value.getString().equals(instance.value.getString());
        }
        return this.value.equals(instance.value);
    }

    public int serialize(byte[] buffer, int pos) throws IOException {
        if (Strings.isEmpty((String)this.upName) || Strings.isEmpty((String)this.upType) || Strings.isEmpty((String)this.normType) || this.value.isNull()) {
            String message = Strings.isEmpty((String)this.upName) ? I18n.err((I18n)I18n.ERR_13616_CANNOT_SERIALIZE_AVA_UPNAME_NULL, (Object[])new Object[0]) : (Strings.isEmpty((String)this.upType) ? I18n.err((I18n)I18n.ERR_13617_CANNOT_SERIALIZE_AVA_UPTYPE_NULL, (Object[])new Object[0]) : (Strings.isEmpty((String)this.normType) ? I18n.err((I18n)I18n.ERR_13618_CANNOT_SERIALIZE_AVA_NORMTYPE_NULL, (Object[])new Object[0]) : I18n.err((I18n)I18n.ERR_13619_CANNOT_SERIALIZE_AVA_VALUE_NULL, (Object[])new Object[0])));
            LOG.error(message);
            throw new IOException(message);
        }
        int length = 0;
        byte[] upNameBytes = null;
        if (this.upName != null) {
            upNameBytes = Strings.getBytesUtf8((String)this.upName);
            length += 5 + upNameBytes.length;
        }
        byte[] upTypeBytes = null;
        if (this.upType != null) {
            upTypeBytes = Strings.getBytesUtf8((String)this.upType);
            length += 5 + upTypeBytes.length;
        }
        ++length;
        if (buffer.length - pos < (length += 4)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.upName != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize((byte[])upNameBytes, (byte[])buffer, (int)pos);
        } else {
            buffer[pos++] = 0;
        }
        if (this.upType != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize((byte[])upTypeBytes, (byte[])buffer, (int)pos);
        } else {
            buffer[pos++] = 0;
        }
        buffer[pos++] = this.value.isHumanReadable() ? (byte)1 : 0;
        if (this.value.isHumanReadable()) {
            pos = this.value.serialize(buffer, pos);
        }
        pos = Serialize.serialize((int)this.h, (byte[])buffer, (int)pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean hasUpName = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (hasUpName) {
            byte[] wrappedValueBytes = Serialize.deserializeBytes((byte[])buffer, (int)pos);
            pos += 4 + wrappedValueBytes.length;
            this.upName = Strings.utf8ToString((byte[])wrappedValueBytes);
        }
        boolean hasUpType = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (hasUpType) {
            byte[] upTypeBytes = Serialize.deserializeBytes((byte[])buffer, (int)pos);
            pos += 4 + upTypeBytes.length;
            this.upType = Strings.utf8ToString((byte[])upTypeBytes);
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty((String)this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        this.normType = this.attributeType != null ? this.attributeType.getOid() : this.upType;
        boolean isHR = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (isHR) {
            this.value = Value.createValue(this.attributeType);
            pos = this.value.deserialize(buffer, pos);
        }
        this.h = Serialize.deserializeInt((byte[])buffer, (int)pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (Strings.isEmpty((String)this.upName) || Strings.isEmpty((String)this.upType) || Strings.isEmpty((String)this.normType) || this.value.isNull()) {
            String message = Strings.isEmpty((String)this.upName) ? I18n.err((I18n)I18n.ERR_13616_CANNOT_SERIALIZE_AVA_UPNAME_NULL, (Object[])new Object[0]) : (Strings.isEmpty((String)this.upType) ? I18n.err((I18n)I18n.ERR_13617_CANNOT_SERIALIZE_AVA_UPTYPE_NULL, (Object[])new Object[0]) : (Strings.isEmpty((String)this.normType) ? I18n.err((I18n)I18n.ERR_13618_CANNOT_SERIALIZE_AVA_NORMTYPE_NULL, (Object[])new Object[0]) : I18n.err((I18n)I18n.ERR_13619_CANNOT_SERIALIZE_AVA_VALUE_NULL, (Object[])new Object[0])));
            LOG.error(message);
            throw new IOException(message);
        }
        if (this.upName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upName);
        } else {
            out.writeBoolean(false);
        }
        if (this.upType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upType);
        } else {
            out.writeBoolean(false);
        }
        if (this.normType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.normType);
        } else {
            out.writeBoolean(false);
        }
        boolean isHR = this.value.isHumanReadable();
        out.writeBoolean(isHR);
        this.value.writeExternal(out);
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasNormType;
        boolean hasUpType;
        boolean hasUpName = in.readBoolean();
        if (hasUpName) {
            this.upName = in.readUTF();
        }
        if (hasUpType = in.readBoolean()) {
            this.upType = in.readUTF();
        }
        if (hasNormType = in.readBoolean()) {
            this.normType = in.readUTF();
        }
        if (this.schemaManager != null) {
            if (!Strings.isEmpty((String)this.upType)) {
                this.attributeType = this.schemaManager.getAttributeType(this.upType);
            } else if (!Strings.isEmpty((String)this.normType)) {
                this.attributeType = this.schemaManager.getAttributeType(this.normType);
            } else {
                throw new IOException(I18n.err((I18n)I18n.ERR_13629_NO_ATTRIBUTE_TYPE, (Object[])new Object[0]));
            }
        }
        in.readBoolean();
        this.value = Value.deserialize(this.attributeType, in);
        this.h = in.readInt();
    }

    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    void setAttributeType(SchemaManager schemaManager, String upType) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.normType = this.attributeType.getOid();
        } else {
            String upTypeTrimmed = Strings.trim((String)upType);
            if (Strings.isEmpty((String)upTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, (Object[])new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        }
    }

    private int compareValues(Ava that) {
        if (this.value.isHumanReadable()) {
            int comp = this.value.compareTo(that.value);
            return comp;
        }
        byte[] bytes1 = this.value.getBytes();
        byte[] bytes2 = that.value.getBytes();
        for (int pos = 0; pos < bytes1.length; ++pos) {
            int v1 = bytes1[pos] & 0xFF;
            int v2 = bytes2[pos] & 0xFF;
            if (v1 > v2) {
                return 1;
            }
            if (v2 <= v1) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(Ava that) {
        int comp;
        if (that == null) {
            return 1;
        }
        if (this.schemaManager == null) {
            int comp2 = this.normType.compareTo(that.normType);
            if (comp2 != 0) {
                return comp2;
            }
            if (this.value == null) {
                if (that.value == null) {
                    return 0;
                }
                return -1;
            }
            if (that.value == null) {
                return 1;
            }
            comp2 = this.value.compareTo(that.value);
            return comp2;
        }
        if (that.schemaManager == null) {
            try {
                that.apply(this.schemaManager);
            }
            catch (LdapInvalidDnException lide) {
                return 1;
            }
        }
        if ((comp = this.attributeType.getOid().compareTo(that.attributeType.getOid())) != 0) {
            return comp;
        }
        MatchingRule orderingMR = this.attributeType.getOrdering();
        if (orderingMR != null) {
            LdapComparator<? super Object> comparator = orderingMR.getLdapComparator();
            if (comparator != null) {
                comp = this.value.compareTo(that.value);
                return comp;
            }
            comp = this.compareValues(that);
            return comp;
        }
        comp = this.compareValues(that);
        return comp;
    }

    public String toString() {
        return this.upName;
    }
}

