/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.MerkleTrees;

public class ValidationResponse
extends RepairMessage {
    public final MerkleTrees trees;
    public static final IVersionedSerializer<ValidationResponse> serializer = new IVersionedSerializer<ValidationResponse>(){

        @Override
        public void serialize(ValidationResponse message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeBoolean(message.success());
            if (message.trees != null) {
                MerkleTrees.serializer.serialize(message.trees, out, version);
            }
        }

        @Override
        public ValidationResponse deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            boolean success = in.readBoolean();
            if (success) {
                MerkleTrees trees = MerkleTrees.serializer.deserialize(in, version);
                return new ValidationResponse(desc, trees);
            }
            return new ValidationResponse(desc);
        }

        @Override
        public long serializedSize(ValidationResponse message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += (long)TypeSizes.sizeof(message.success());
            if (message.trees != null) {
                size += MerkleTrees.serializer.serializedSize(message.trees, version);
            }
            return size;
        }
    };

    public ValidationResponse(RepairJobDesc desc) {
        super(desc);
        this.trees = null;
    }

    public ValidationResponse(RepairJobDesc desc, MerkleTrees trees) {
        super(desc);
        assert (trees != null);
        this.trees = trees;
    }

    public boolean success() {
        return this.trees != null;
    }

    public ValidationResponse tryMoveOffHeap() throws IOException {
        return this.trees == null ? this : new ValidationResponse(this.desc, this.trees.tryMoveOffHeap());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValidationResponse)) {
            return false;
        }
        ValidationResponse other = (ValidationResponse)o;
        return this.desc.equals(other.desc);
    }

    public int hashCode() {
        return Objects.hash(this.desc);
    }
}

