/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.FBUtilities;

public class PartitionerDefinedOrder
extends AbstractType<ByteBuffer> {
    private final IPartitioner partitioner;

    public PartitionerDefinedOrder(IPartitioner partitioner) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.partitioner = partitioner;
    }

    public static AbstractType<?> getInstance(TypeParser parser) {
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        Iterator<String> argIterator = parser.getKeyValueParameters().keySet().iterator();
        if (argIterator.hasNext()) {
            partitioner = FBUtilities.newPartitioner(argIterator.next());
            assert (!argIterator.hasNext());
        }
        return partitioner.partitionOrdering();
    }

    @Override
    public <V> ByteBuffer compose(V value, ValueAccessor<V> accessor) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer value) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return accessor.toHex(value);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return PartitionPosition.ForKey.get(accessorL.toBuffer(left), this.partitioner).compareTo(PartitionPosition.ForKey.get(accessorR.toBuffer(right), this.partitioner));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", this.getClass().getName(), this.partitioner.getClass().getName());
    }
}

