/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.artifact;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.artifact.ArtifactFetcher;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FsArtifactFetcher
extends ArtifactFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(FsArtifactFetcher.class);

    FsArtifactFetcher() {
    }

    @Override
    File fetch(String uri, Configuration flinkConf, File targetDir) throws Exception {
        Path source = new Path(uri);
        long start = System.currentTimeMillis();
        FileSystem fileSystem = source.getFileSystem();
        String fileName = source.getName();
        File targetFile = new File(targetDir, fileName);
        try (FSDataInputStream inputStream = fileSystem.open(source);){
            FileUtils.copyToFile((InputStream)inputStream, (File)targetFile);
        }
        LOG.debug("Copied file from {} to {}, cost {} ms", new Object[]{source, targetFile, System.currentTimeMillis() - start});
        return targetFile;
    }
}

