/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.type.classreading;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ConcurrentReferenceCachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    private final Map<String, MetadataReader> classNameCache = new ConcurrentReferenceHashMap<String, MetadataReader>();
    private final Map<Resource, MetadataReader> resourceCache = new ConcurrentReferenceHashMap<Resource, MetadataReader>();

    public ConcurrentReferenceCachingMetadataReaderFactory() {
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public MetadataReader getMetadataReader(String className) throws IOException {
        MetadataReader metadataReader = this.classNameCache.get(className);
        if (metadataReader == null) {
            metadataReader = super.getMetadataReader(className);
            this.classNameCache.put(className, metadataReader);
        }
        return metadataReader;
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        MetadataReader metadataReader = this.resourceCache.get(resource);
        if (metadataReader == null) {
            metadataReader = this.createMetadataReader(resource);
            this.resourceCache.put(resource, metadataReader);
        }
        return metadataReader;
    }

    protected MetadataReader createMetadataReader(Resource resource) throws IOException {
        return super.getMetadataReader(resource);
    }

    public void clearCache() {
        this.classNameCache.clear();
        this.resourceCache.clear();
    }
}

