/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.servlet.WelcomePage;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ParameterizableViewController;

final class WelcomePageHandlerMapping
extends AbstractUrlHandlerMapping {
    private static final Log logger = LogFactory.getLog(WelcomePageHandlerMapping.class);
    private static final List<MediaType> MEDIA_TYPES_ALL = Collections.singletonList(MediaType.ALL);

    WelcomePageHandlerMapping(TemplateAvailabilityProviders templateAvailabilityProviders, ApplicationContext applicationContext, Resource indexHtmlResource, String staticPathPattern) {
        this.setOrder(2);
        WelcomePage welcomePage = WelcomePage.resolve(templateAvailabilityProviders, applicationContext, indexHtmlResource, staticPathPattern);
        if (welcomePage != WelcomePage.UNRESOLVED) {
            logger.info(LogMessage.of(() -> !welcomePage.isTemplated() ? "Adding welcome page: " + String.valueOf(indexHtmlResource) : "Adding welcome page template: index"));
            ParameterizableViewController controller2 = new ParameterizableViewController();
            controller2.setViewName(welcomePage.getViewName());
            this.setRootHandler(controller2);
        }
    }

    @Override
    public Object getHandlerInternal(HttpServletRequest request) throws Exception {
        return !this.isHtmlTextAccepted(request) ? null : super.getHandlerInternal(request);
    }

    private boolean isHtmlTextAccepted(HttpServletRequest request) {
        for (MediaType mediaType : this.getAcceptedMediaTypes(request)) {
            if (!mediaType.includes(MediaType.TEXT_HTML)) continue;
            return true;
        }
        return false;
    }

    private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (StringUtils.hasText(acceptHeader)) {
            try {
                return MediaType.parseMediaTypes(acceptHeader);
            }
            catch (InvalidMediaTypeException ex) {
                logger.warn("Received invalid Accept header. Assuming all media types are accepted", logger.isDebugEnabled() ? ex : null);
            }
        }
        return MEDIA_TYPES_ALL;
    }
}

