/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.util.List;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertiesKafkaConnectionDetails
implements KafkaConnectionDetails {
    private final KafkaProperties properties;
    private final SslBundles sslBundles;

    PropertiesKafkaConnectionDetails(KafkaProperties properties, SslBundles sslBundles) {
        this.properties = properties;
        this.sslBundles = sslBundles;
    }

    @Override
    public List<String> getBootstrapServers() {
        return this.properties.getBootstrapServers();
    }

    @Override
    public KafkaConnectionDetails.Configuration getConsumer() {
        List<String> servers = this.properties.getConsumer().getBootstrapServers();
        SslBundle sslBundle = this.getBundle(this.properties.getConsumer().getSsl());
        String protocol = this.properties.getConsumer().getSecurity().getProtocol();
        return KafkaConnectionDetails.Configuration.of(servers != null ? servers : this.getBootstrapServers(), sslBundle != null ? sslBundle : this.getSslBundle(), StringUtils.hasLength(protocol) ? protocol : this.getSecurityProtocol());
    }

    @Override
    public KafkaConnectionDetails.Configuration getProducer() {
        List<String> servers = this.properties.getProducer().getBootstrapServers();
        SslBundle sslBundle = this.getBundle(this.properties.getProducer().getSsl());
        String protocol = this.properties.getProducer().getSecurity().getProtocol();
        return KafkaConnectionDetails.Configuration.of(servers != null ? servers : this.getBootstrapServers(), sslBundle != null ? sslBundle : this.getSslBundle(), StringUtils.hasLength(protocol) ? protocol : this.getSecurityProtocol());
    }

    @Override
    public KafkaConnectionDetails.Configuration getStreams() {
        List<String> servers = this.properties.getStreams().getBootstrapServers();
        SslBundle sslBundle = this.getBundle(this.properties.getStreams().getSsl());
        String protocol = this.properties.getStreams().getSecurity().getProtocol();
        return KafkaConnectionDetails.Configuration.of(servers != null ? servers : this.getBootstrapServers(), sslBundle != null ? sslBundle : this.getSslBundle(), StringUtils.hasLength(protocol) ? protocol : this.getSecurityProtocol());
    }

    @Override
    public KafkaConnectionDetails.Configuration getAdmin() {
        SslBundle sslBundle = this.getBundle(this.properties.getAdmin().getSsl());
        String protocol = this.properties.getAdmin().getSecurity().getProtocol();
        return KafkaConnectionDetails.Configuration.of(this.getBootstrapServers(), sslBundle != null ? sslBundle : this.getSslBundle(), StringUtils.hasLength(protocol) ? protocol : this.getSecurityProtocol());
    }

    @Override
    public SslBundle getSslBundle() {
        return this.getBundle(this.properties.getSsl());
    }

    @Override
    public String getSecurityProtocol() {
        return this.properties.getSecurity().getProtocol();
    }

    private SslBundle getBundle(KafkaProperties.Ssl ssl) {
        if (StringUtils.hasLength(ssl.getBundle())) {
            Assert.notNull((Object)this.sslBundles, "SSL bundle name has been set but no SSL bundles found in context");
            return this.sslBundles.getBundle(ssl.getBundle());
        }
        return null;
    }
}

