/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.client.reactive;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.http.client.AbstractHttpClientProperties;
import org.springframework.boot.autoconfigure.http.client.reactive.AbstractClientHttpConnectorProperties;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

class ClientHttpConnectors {
    private final ObjectProvider<SslBundles> sslBundles;
    private final AbstractClientHttpConnectorProperties[] orderedProperties;

    ClientHttpConnectors(ObjectProvider<SslBundles> sslBundles, AbstractClientHttpConnectorProperties ... orderedProperties) {
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    ClientHttpConnectorBuilder<?> builder(ClassLoader classLoader) {
        AbstractClientHttpConnectorProperties.Connector connector = this.getProperty(AbstractClientHttpConnectorProperties::getConnector);
        return connector != null ? connector.builder() : ClientHttpConnectorBuilder.detect(classLoader);
    }

    ClientHttpConnectorSettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractHttpClientProperties::getRedirects);
        Duration connectTimeout = this.getProperty(AbstractHttpClientProperties::getConnectTimeout);
        Duration readTimeout = this.getProperty(AbstractHttpClientProperties::getReadTimeout);
        String sslBundleName = this.getProperty(AbstractHttpClientProperties::getSsl, AbstractHttpClientProperties.Ssl::getBundle, StringUtils::hasText);
        SslBundle sslBundle = StringUtils.hasLength(sslBundleName) ? this.sslBundles.getObject().getBundle(sslBundleName) : null;
        return new ClientHttpConnectorSettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    private <T> T getProperty(Function<AbstractClientHttpConnectorProperties, T> accessor) {
        return (T)this.getProperty(accessor, Function.identity(), Objects::nonNull);
    }

    private <P, T> T getProperty(Function<AbstractClientHttpConnectorProperties, P> accessor, Function<P, T> extractor, Predicate<T> predicate) {
        for (AbstractClientHttpConnectorProperties properties : this.orderedProperties) {
            T extracted;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return null;
    }
}

