/*
 * Decompiled with CFR 0.152.
 */
package org.grails.transaction;

import grails.transaction.TransactionManagerAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class TransactionManagerPostProcessor
implements SmartInstantiationAwareBeanPostProcessor,
BeanFactoryAware,
Ordered {
    private ConfigurableListableBeanFactory beanFactory;
    private PlatformTransactionManager transactionManager;
    private int order = Integer.MAX_VALUE;
    private boolean initialized = false;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, "TransactionManagerPostProcessor requires a ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean2, String name) throws BeansException {
        if (bean2 instanceof TransactionManagerAware) {
            this.initialize();
            if (this.transactionManager != null) {
                TransactionManagerAware tma = (TransactionManagerAware)bean2;
                tma.setTransactionManager(this.transactionManager);
            }
        }
        return true;
    }

    private void initialize() {
        if (this.transactionManager == null && this.beanFactory != null && !this.initialized) {
            if (this.beanFactory.containsBean("transactionManager")) {
                this.transactionManager = this.beanFactory.getBean("transactionManager", PlatformTransactionManager.class);
            } else {
                String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, PlatformTransactionManager.class, false, false);
                if (beanNames.length > 0) {
                    this.transactionManager = (PlatformTransactionManager)this.beanFactory.getBean(beanNames[0]);
                }
            }
            this.initialized = true;
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

