/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.config;

import java.util.function.Function;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.OneOfFeature;
import org.grails.forge.feature.config.Configuration;
import org.grails.forge.template.Template;

public interface ConfigurationFeature
extends OneOfFeature {
    public static final String ENVIRONMENTS_KEY = "environments";
    public static final String DEV_ENVIRONMENT_KEY = "development";
    public static final String TEST_ENVIRONMENT_KEY = "test";
    public static final String PROD_ENVIRONMENT_KEY = "production";
    public static final String PROPERTIES_KEY = "properties";

    @Override
    default public Class<?> getFeatureClass() {
        return ConfigurationFeature.class;
    }

    @Override
    default public String getCategory() {
        return "Configuration";
    }

    public Function<Configuration, Template> createTemplate();

    @Override
    default public void apply(GeneratorContext generatorContext) {
        Function<Configuration, Template> createTemplateFunc = this.createTemplate();
        generatorContext.getAllConfigurations().stream().filter(config -> !config.isEmpty()).forEach(config -> generatorContext.addTemplate(config.getTemplateKey(), (Template)createTemplateFunc.apply((Configuration)config)));
    }
}

