/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.transactions;

import jakarta.persistence.FlushModeType;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.Transaction;
import org.grails.datastore.mapping.transactions.TransactionObject;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DatastoreTransactionManager
extends AbstractPlatformTransactionManager {
    private Datastore datastore;
    private boolean datastoreManagedSession;

    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    public Datastore getDatastore() {
        Assert.notNull((Object)this.datastore, "Cannot use DatastoreTransactionManager without a datastore set!");
        return this.datastore;
    }

    public void setDatastoreManagedSession(boolean datastoreManagedSession) {
        this.datastoreManagedSession = datastoreManagedSession;
    }

    @Override
    protected Object doSuspend(Object transaction) throws TransactionException {
        TransactionObject txObject = (TransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getDatastore());
        return txObject.getSessionHolder();
    }

    @Override
    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        SessionHolder conHolder = (SessionHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getDatastore(), conHolder);
    }

    @Override
    protected Object doGetTransaction() throws TransactionException {
        TransactionObject txObject = new TransactionObject();
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getDatastore());
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound Session [" + String.valueOf(sessionHolder.getSession()) + "] for Datastore transaction");
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.datastoreManagedSession) {
            try {
                Session session = this.getDatastore().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found Datastore-managed Session [" + String.valueOf(session) + "] for Spring-managed transaction");
                }
                txObject.setExistingSession(session);
            }
            catch (ConnectionNotFoundException ex) {
                throw new DataAccessResourceFailureException("Could not obtain Datastore-managed Session for Spring-managed transaction", ex);
            }
        } else {
            Session session = this.getDatastore().connect();
            txObject.setSession(session);
        }
        return txObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBegin(Object o, TransactionDefinition definition) throws TransactionException {
        TransactionObject txObject = (TransactionObject)o;
        Session session = null;
        try {
            session = txObject.getSessionHolder().getSession();
            if (definition.isReadOnly()) {
                session.setFlushMode(FlushModeType.COMMIT);
            }
            Transaction tx = session.beginTransaction();
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                tx.setTimeout(timeout);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource(this.getDatastore(), txObject.getSessionHolder());
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Exception ex) {
            if (txObject.isNewSession()) {
                try {
                    Transaction transaction;
                    if (session != null && (transaction = session.getTransaction()) != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                }
                catch (Throwable ex2) {
                    this.logger.debug("Could not rollback Session after failed transaction begin", ex);
                }
                finally {
                    DatastoreUtils.closeSession(session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Datastore Session for transaction", ex);
        }
    }

    @Override
    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        SessionHolder sessionHolder = txObject.getSessionHolder();
        try {
            Transaction<?> transaction = txObject.getTransaction();
            if (transaction != null && transaction.isActive()) {
                Session session = sessionHolder.getSession();
                if (!status.isReadOnly() && session != null) {
                    if (status.isDebug()) {
                        this.logger.debug("Flushing Session prior to transaction commit [" + String.valueOf(session) + "]");
                    }
                    session.flush();
                }
                if (status.isDebug()) {
                    this.logger.debug("Committing Datastore transaction on Session [" + String.valueOf(session) + "]");
                }
                transaction.commit();
            }
        }
        catch (DataAccessException ex) {
            throw new TransactionSystemException("Could not commit Datastore transaction", ex);
        }
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        SessionHolder sessionHolder = txObject.getSessionHolder();
        try {
            Transaction<?> transaction = txObject.getTransaction();
            if (transaction != null && transaction.isActive()) {
                if (status.isDebug()) {
                    this.logger.debug("Rolling back Datastore transaction on Session [" + String.valueOf(sessionHolder.getSession()) + "]");
                }
                transaction.rollback();
            }
        }
        catch (DataAccessException ex) {
            throw new TransactionSystemException("Could not rollback Datastore transaction", ex);
        }
        finally {
            if (sessionHolder.getSession() != null) {
                sessionHolder.getSession().clear();
            }
        }
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        status.setRollbackOnly();
        txObject.getSessionHolder().setRollbackOnly();
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionObject txObject = (TransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            DatastoreUtils.closeSession(txObject.getSessionHolder().getSession());
        }
        txObject.getSessionHolder().setSynchronizedWithTransaction(false);
    }
}

