/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Set;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

public class BeanEntityAccess
implements EntityAccess {
    private static final Set EXCLUDED_PROPERTIES = ClassPropertyFetcher.EXCLUDED_PROPERTIES;
    protected Object entity;
    protected BeanWrapper beanWrapper;
    protected PersistentEntity persistentEntity;

    public BeanEntityAccess(PersistentEntity persistentEntity, Object entity) {
        this.entity = entity;
        this.persistentEntity = persistentEntity;
        this.beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(entity);
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    public void setConversionService(ConversionService conversionService) {
        this.beanWrapper.setConversionService(conversionService);
    }

    @Override
    public Object getProperty(String name) {
        return this.beanWrapper.getPropertyValue(name);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.beanWrapper.getPropertyValue(name);
    }

    @Override
    public Class getPropertyType(String name) {
        return this.beanWrapper.getPropertyType(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        Class type = this.getPropertyType(name);
        if (value == null) {
            if (!type.isPrimitive()) {
                this.beanWrapper.setPropertyValue(name, value);
            }
        } else {
            this.beanWrapper.setPropertyValue(name, value);
        }
    }

    @Override
    public Object getIdentifier() {
        String idName = this.getIdentifierName(this.persistentEntity.getMapping());
        if (idName != null) {
            return this.getProperty(idName);
        }
        PersistentProperty identity = this.persistentEntity.getIdentity();
        if (identity != null) {
            return this.getProperty(identity.getName());
        }
        return null;
    }

    @Override
    public void setIdentifier(Object id) {
        String idName = this.getIdentifierName(this.persistentEntity.getMapping());
        this.setProperty(idName, id);
    }

    @Override
    public void setIdentifierNoConversion(Object id) {
        String idName = this.getIdentifierName(this.persistentEntity.getMapping());
        this.setPropertyNoConversion(idName, id);
    }

    protected String getIdentifierName(ClassMapping cm) {
        String[] identifierName;
        IdentityMapping identifier = cm.getIdentifier();
        if (identifier != null && identifier.getIdentifierName() != null && (identifierName = identifier.getIdentifierName()).length > 0) {
            return identifierName[0];
        }
        return null;
    }

    @Override
    public String getIdentifierName() {
        return this.getIdentifierName(this.persistentEntity.getMapping());
    }

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public void setPropertyNoConversion(String name, Object value) {
        PropertyDescriptor pd = this.beanWrapper.getPropertyDescriptor(name);
        if (pd == null) {
            return;
        }
        Method writeMethod = pd.getWriteMethod();
        if (writeMethod != null) {
            ReflectionUtils.invokeMethod(writeMethod, this.beanWrapper.getWrappedInstance(), value);
        }
    }

    @Override
    public void refresh() {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = this.beanWrapper.getPropertyDescriptors()) {
            String name = descriptor.getName();
            if (EXCLUDED_PROPERTIES.contains(name) || !this.beanWrapper.isReadableProperty(name) || !this.beanWrapper.isWritableProperty(name)) continue;
            Object newValue = this.getProperty(name);
            this.setProperty(name, newValue);
        }
    }
}

