/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import groovy.lang.Range;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class RangeConstraint
extends AbstractConstraint {
    private final Range range;

    public RangeConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.range = (Range)this.constraintParameter;
    }

    public Range getRange() {
        return this.range;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (Comparable.class.isAssignableFrom(type) || ClassUtils.isAssignableOrConvertibleFrom(Number.class, type));
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Range)) {
            throw new IllegalArgumentException("Parameter for constraint [range] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be a of type [groovy.lang.Range]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "range";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.range.contains(propertyValue)) {
            return;
        }
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.range.getFrom(), this.range.getTo()};
        Object from = this.range.getFrom();
        Object to = this.range.getTo();
        boolean isNumberRange = from instanceof Number;
        if (isNumberRange) {
            from = ((Number)from).longValue();
            to = ((Number)to).longValue();
            if (propertyValue instanceof Number) {
                propertyValue = ((Number)propertyValue).longValue();
            } else if (propertyValue instanceof CharSequence) {
                try {
                    propertyValue = Long.valueOf(propertyValue.toString());
                }
                catch (NumberFormatException e) {
                    this.rejectValue(target, errors, "default.invalid.range.message", "range.invalid", args);
                }
            }
        }
        if (from.compareTo((Object)propertyValue) > 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toosmall", args);
        } else if (to.compareTo((Object)propertyValue) < 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toobig", args);
        }
    }
}

