/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.grails.cli.compiler.AstUtils;
import org.grails.cli.compiler.CompilerAutoConfiguration;
import org.grails.cli.compiler.DependencyCustomizer;
import org.grails.cli.groovy.GroovyTemplate;

public class SpringMvcCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "Controller", "RestController", "EnableWebMvc");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies2) {
        dependencies2.ifAnyMissingClasses("org.springframework.web.servlet.mvc.Controller").add("spring-boot-starter-web");
        dependencies2.ifAnyMissingClasses("groovy.text.TemplateEngine").add("groovy-templates");
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports("org.springframework.web.bind.annotation", "org.springframework.web.servlet.config.annotation", "org.springframework.web.servlet", "org.springframework.http", "org.springframework.web.servlet.handler", "org.springframework.http", "org.springframework.ui", "groovy.text");
        imports.addStaticImport(GroovyTemplate.class.getName(), "template");
    }
}

