/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.internal.consumer.converters.BackwardsCompatibleIdeaModuleDependency;
import org.gradle.tooling.internal.protocol.cpp.InternalCppApplication;
import org.gradle.tooling.internal.protocol.cpp.InternalCppExecutable;
import org.gradle.tooling.internal.protocol.cpp.InternalCppLibrary;
import org.gradle.tooling.internal.protocol.cpp.InternalCppSharedLibrary;
import org.gradle.tooling.internal.protocol.cpp.InternalCppStaticLibrary;
import org.gradle.tooling.internal.protocol.cpp.InternalCppTestSuite;
import org.gradle.tooling.model.cpp.CppApplication;
import org.gradle.tooling.model.cpp.CppBinary;
import org.gradle.tooling.model.cpp.CppComponent;
import org.gradle.tooling.model.cpp.CppExecutable;
import org.gradle.tooling.model.cpp.CppLibrary;
import org.gradle.tooling.model.cpp.CppSharedLibrary;
import org.gradle.tooling.model.cpp.CppStaticLibrary;
import org.gradle.tooling.model.cpp.CppTestSuite;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;

public class ConsumerTargetTypeProvider
implements TargetTypeProvider {
    private final Map<String, Class<?>> configuredTargetTypes = new HashMap();

    public ConsumerTargetTypeProvider() {
        this.configuredTargetTypes.put(IdeaSingleEntryLibraryDependency.class.getCanonicalName(), IdeaSingleEntryLibraryDependency.class);
        this.configuredTargetTypes.put(IdeaModuleDependency.class.getCanonicalName(), BackwardsCompatibleIdeaModuleDependency.class);
    }

    @Override
    public <T> Class<? extends T> getTargetType(Class<T> initialTargetType, Object protocolObject) {
        Class<?>[] interfaces;
        for (Class<?> i2 : interfaces = protocolObject.getClass().getInterfaces()) {
            if (!this.configuredTargetTypes.containsKey(i2.getName())) continue;
            return this.configuredTargetTypes.get(i2.getName()).asSubclass(initialTargetType);
        }
        if (initialTargetType.isAssignableFrom(CppComponent.class)) {
            if (protocolObject instanceof InternalCppApplication) {
                return CppApplication.class.asSubclass(initialTargetType);
            }
            if (protocolObject instanceof InternalCppLibrary) {
                return CppLibrary.class.asSubclass(initialTargetType);
            }
            if (protocolObject instanceof InternalCppTestSuite) {
                return CppTestSuite.class.asSubclass(initialTargetType);
            }
        } else if (initialTargetType.isAssignableFrom(CppBinary.class)) {
            if (protocolObject instanceof InternalCppExecutable) {
                return CppExecutable.class.asSubclass(initialTargetType);
            }
            if (protocolObject instanceof InternalCppSharedLibrary) {
                return CppSharedLibrary.class.asSubclass(initialTargetType);
            }
            if (protocolObject instanceof InternalCppStaticLibrary) {
                return CppStaticLibrary.class.asSubclass(initialTargetType);
            }
        }
        return initialTargetType;
    }
}

