/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public final class Hex {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static byte[] decode(String s) {
        int len = s.length();
        byte[] b = new byte[len / 2];
        int i2 = 0;
        while (i2 < len) {
            int left = Character.digit(s.charAt(i2), 16);
            int right = Character.digit(s.charAt(i2 + 1), 16);
            if (left == -1 || right == -1) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidHexString, s));
            }
            b[i2 / 2] = (byte)(left << 4 | right);
            i2 += 2;
        }
        return b;
    }

    public static String toHexString(byte[] b) {
        char[] c = new char[b.length * 2];
        int i2 = 0;
        while (i2 < b.length) {
            int v = b[i2] & 0xFF;
            c[i2 * 2] = HEX[v >>> 4];
            c[i2 * 2 + 1] = HEX[v & 0xF];
            ++i2;
        }
        return new String(c);
    }
}

