/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public final class AbbreviatedObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int nibbles;
    final int w1;
    final int w2;
    final int w3;
    final int w4;
    final int w5;

    public static final boolean isId(String id) {
        if (id.length() < 2 || 40 < id.length()) {
            return false;
        }
        try {
            int i2 = 0;
            while (i2 < id.length()) {
                RawParseUtils.parseHexInt4((byte)id.charAt(i2));
                ++i2;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static final AbbreviatedObjectId fromString(byte[] buf, int offset, int end) {
        if (end - offset > 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIdLength, end - offset, 40));
        }
        return AbbreviatedObjectId.fromHexString(buf, offset, end);
    }

    public static final AbbreviatedObjectId fromObjectId(AnyObjectId id) {
        return new AbbreviatedObjectId(40, id.w1, id.w2, id.w3, id.w4, id.w5);
    }

    public static final AbbreviatedObjectId fromString(String str) {
        if (str.length() > 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidId, str));
        }
        byte[] b = Constants.encodeASCII(str);
        return AbbreviatedObjectId.fromHexString(b, 0, b.length);
    }

    private static final AbbreviatedObjectId fromHexString(byte[] bs, int ptr, int end) {
        try {
            int a = AbbreviatedObjectId.hexUInt32(bs, ptr, end);
            int b = AbbreviatedObjectId.hexUInt32(bs, ptr + 8, end);
            int c = AbbreviatedObjectId.hexUInt32(bs, ptr + 16, end);
            int d = AbbreviatedObjectId.hexUInt32(bs, ptr + 24, end);
            int e = AbbreviatedObjectId.hexUInt32(bs, ptr + 32, end);
            return new AbbreviatedObjectId(end - ptr, a, b, c, d, e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            InvalidObjectIdException e1 = new InvalidObjectIdException(bs, ptr, end - ptr);
            e1.initCause(e);
            throw e1;
        }
    }

    private static final int hexUInt32(byte[] bs, int p, int end) {
        if (8 <= end - p) {
            return RawParseUtils.parseHexInt32(bs, p);
        }
        int r = 0;
        int n = 0;
        while (n < 8 && p < end) {
            r <<= 4;
            r |= RawParseUtils.parseHexInt4(bs[p++]);
            ++n;
        }
        return r << (8 - n) * 4;
    }

    static int mask(int nibbles, int word, int v) {
        int b = (word - 1) * 8;
        if (b + 8 <= nibbles) {
            return v;
        }
        if (nibbles <= b) {
            return 0;
        }
        int s = 32 - (nibbles - b) * 4;
        return v >>> s << s;
    }

    AbbreviatedObjectId(int n, int new_1, int new_2, int new_3, int new_4, int new_5) {
        this.nibbles = n;
        this.w1 = new_1;
        this.w2 = new_2;
        this.w3 = new_3;
        this.w4 = new_4;
        this.w5 = new_5;
    }

    public int length() {
        return this.nibbles;
    }

    public boolean isComplete() {
        return this.length() == 40;
    }

    public ObjectId toObjectId() {
        return this.isComplete() ? new ObjectId(this.w1, this.w2, this.w3, this.w4, this.w5) : null;
    }

    public final int prefixCompare(AnyObjectId other) {
        int cmp = NB.compareUInt32(this.w1, this.mask(1, other.w1));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, this.mask(2, other.w2));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, this.mask(3, other.w3));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, this.mask(4, other.w4));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, this.mask(5, other.w5));
    }

    public final int prefixCompare(byte[] bs, int p) {
        int cmp = NB.compareUInt32(this.w1, this.mask(1, NB.decodeInt32(bs, p)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, this.mask(2, NB.decodeInt32(bs, p + 4)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, this.mask(3, NB.decodeInt32(bs, p + 8)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, this.mask(4, NB.decodeInt32(bs, p + 12)));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, this.mask(5, NB.decodeInt32(bs, p + 16)));
    }

    public final int prefixCompare(int[] bs, int p) {
        int cmp = NB.compareUInt32(this.w1, this.mask(1, bs[p]));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w2, this.mask(2, bs[p + 1]));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w3, this.mask(3, bs[p + 2]));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt32(this.w4, this.mask(4, bs[p + 3]));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt32(this.w5, this.mask(5, bs[p + 4]));
    }

    public final int getFirstByte() {
        return this.w1 >>> 24;
    }

    private int mask(int word, int v) {
        return AbbreviatedObjectId.mask(this.nibbles, word, v);
    }

    public int hashCode() {
        return this.w1;
    }

    public boolean equals(Object o) {
        if (o instanceof AbbreviatedObjectId) {
            AbbreviatedObjectId b = (AbbreviatedObjectId)o;
            return this.nibbles == b.nibbles && this.w1 == b.w1 && this.w2 == b.w2 && this.w3 == b.w3 && this.w4 == b.w4 && this.w5 == b.w5;
        }
        return false;
    }

    public final String name() {
        char[] b = new char[40];
        AnyObjectId.formatHexChar(b, 0, this.w1);
        if (this.nibbles <= 8) {
            return new String(b, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(b, 8, this.w2);
        if (this.nibbles <= 16) {
            return new String(b, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(b, 16, this.w3);
        if (this.nibbles <= 24) {
            return new String(b, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(b, 24, this.w4);
        if (this.nibbles <= 32) {
            return new String(b, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(b, 32, this.w5);
        return new String(b, 0, this.nibbles);
    }

    public String toString() {
        return "AbbreviatedObjectId[" + this.name() + "]";
    }
}

