/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.OutputTool;

public class FileOutputTool
implements OutputTool {
    @Override
    public void makeOutputArea(String filename) {
        Path path = Paths.get(filename, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Unable to create directory '" + filename + "' due to '" + e.getMessage() + "'; attempting to continue...");
        }
    }

    @Override
    public void writeToOutput(String fileName, String text, String charset) throws Exception {
        File file = new File(fileName);
        Path path = file.getParentFile().toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Unable to create parent directory '" + path + "' due to '" + e.getMessage() + "'; attempting to continue...");
            }
        }
        ResourceGroovyMethods.write(file, text, charset, true);
    }
}

