/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.ResilientBeanDeserializerFactory;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

@Factory
@BootstrapContextCompatible
public class ObjectMapperFactory {
    public static final String MICRONAUT_MODULE = "micronaut";
    @Inject
    protected Module[] jacksonModules = new Module[0];
    @Inject
    protected JsonSerializer[] serializers = new JsonSerializer[0];
    @Inject
    protected JsonDeserializer[] deserializers = new JsonDeserializer[0];
    @Inject
    protected BeanSerializerModifier[] beanSerializerModifiers = new BeanSerializerModifier[0];
    @Inject
    protected BeanDeserializerModifier[] beanDeserializerModifiers = new BeanDeserializerModifier[0];
    @Inject
    protected KeyDeserializer[] keyDeserializers = new KeyDeserializer[0];

    @Requires(beans={JacksonConfiguration.class})
    @Singleton
    @BootstrapContextCompatible
    public JsonFactory jsonFactory(JacksonConfiguration jacksonConfiguration) {
        TSFBuilder<?, ?> jsonFactoryBuilder = JsonFactory.builder();
        jacksonConfiguration.getFactorySettings().forEach(jsonFactoryBuilder::configure);
        return jsonFactoryBuilder.build();
    }

    @Singleton
    @Primary
    @Named(value="json")
    @BootstrapContextCompatible
    public ObjectMapper objectMapper(@Nullable JacksonConfiguration jacksonConfiguration, @Nullable JsonFactory jsonFactory) {
        Optional<Class> targetType;
        Class<?>[] value;
        Type annotation;
        Class<?> type;
        boolean hasConfiguration;
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory, null, new DefaultDeserializationContext.Impl(new ResilientBeanDeserializerFactory(new DeserializerFactoryConfig())));
        boolean bl = hasConfiguration = jacksonConfiguration != null;
        if (!hasConfiguration || jacksonConfiguration.isModuleScan()) {
            objectMapper.findAndRegisterModules();
        }
        objectMapper.registerModules(this.jacksonModules);
        SimpleModule module = new SimpleModule(MICRONAUT_MODULE);
        for (JsonSerializer serializer : this.serializers) {
            type = serializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class<?> aClass2 : value = annotation.value()) {
                    module.addSerializer(aClass2, serializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            if (targetType.isPresent()) {
                module.addSerializer(targetType.get(), serializer);
                continue;
            }
            module.addSerializer(serializer);
        }
        for (JsonDeserializer deserializer : this.deserializers) {
            type = deserializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class<?> aClass2 : value = annotation.value()) {
                    module.addDeserializer(aClass2, deserializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            targetType.ifPresent(aClass -> module.addDeserializer(aClass, deserializer));
        }
        if (hasConfiguration && jacksonConfiguration.isTrimStrings()) {
            module.addDeserializer(String.class, new StringDeserializer(){

                @Override
                public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    String value = super.deserialize(p, ctxt);
                    return StringUtils.trimToNull(value);
                }
            });
        }
        for (KeyDeserializer keyDeserializer : this.keyDeserializers) {
            type = keyDeserializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation == null) continue;
            for (Class<?> clazz : value = annotation.value()) {
                module.addKeyDeserializer(clazz, keyDeserializer);
            }
        }
        objectMapper.registerModule(module);
        for (BeanSerializerModifier beanSerializerModifier : this.beanSerializerModifiers) {
            objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier(beanSerializerModifier));
        }
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        if (hasConfiguration) {
            PropertyNamingStrategy propertyNamingStrategy;
            TimeZone timeZone;
            Locale locale;
            String dateFormat;
            JsonInclude.Include include;
            ObjectMapper.DefaultTyping defaultTyping = jacksonConfiguration.getDefaultTyping();
            if (defaultTyping != null) {
                objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), defaultTyping);
            }
            if ((include = jacksonConfiguration.getSerializationInclusion()) != null) {
                objectMapper.setSerializationInclusion(include);
            }
            if ((dateFormat = jacksonConfiguration.getDateFormat()) != null) {
                objectMapper.setDateFormat(new SimpleDateFormat(dateFormat));
            }
            if ((locale = jacksonConfiguration.getLocale()) != null) {
                objectMapper.setLocale(locale);
            }
            if ((timeZone = jacksonConfiguration.getTimeZone()) != null) {
                objectMapper.setTimeZone(timeZone);
            }
            if ((propertyNamingStrategy = jacksonConfiguration.getPropertyNamingStrategy()) != null) {
                objectMapper.setPropertyNamingStrategy(propertyNamingStrategy);
            }
            jacksonConfiguration.getSerializationSettings().forEach(objectMapper::configure);
            jacksonConfiguration.getDeserializationSettings().forEach(objectMapper::configure);
            jacksonConfiguration.getMapperSettings().forEach(objectMapper::configure);
            jacksonConfiguration.getParserSettings().forEach(objectMapper::configure);
            jacksonConfiguration.getGeneratorSettings().forEach(objectMapper::configure);
        }
        return objectMapper;
    }
}

