/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanLocator {
    @NonNull
    public <T> T getBean(@NonNull BeanDefinition<T> var1);

    @NonNull
    public <T> T getBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBean(Objects.requireNonNull(beanType, "Bean type cannot be null").getType(), qualifier);
    }

    @NonNull
    default public <T> T getBean(@NonNull Argument<T> beanType) {
        return this.getBean(beanType, null);
    }

    @NonNull
    public <T> Optional<T> findBean(@NonNull Argument<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> Optional<T> findBean(@NonNull Argument<T> beanType) {
        return this.findBean(beanType, null);
    }

    @NonNull
    public <T> Optional<T> findBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Class<T> var1);

    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> Collection<T> getBeansOfType(@NonNull Argument<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeansOfType(beanType.getType());
    }

    @NonNull
    default public <T> Collection<T> getBeansOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeansOfType(beanType.getType(), qualifier);
    }

    @NonNull
    public <T> Stream<T> streamOfType(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> Stream<T> streamOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.streamOfType(Objects.requireNonNull(beanType, "Bean type cannot be null").getType(), qualifier);
    }

    @NonNull
    default public <T> Stream<T> streamOfType(@NonNull Argument<T> beanType) {
        return this.streamOfType(Objects.requireNonNull(beanType, "Bean type cannot be null"), null);
    }

    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> T getProxyTargetBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getProxyTargetBean(Objects.requireNonNull(beanType, "Bean type cannot be null").getType(), qualifier);
    }

    @NonNull
    default public <T> Stream<T> streamOfType(@NonNull Class<T> beanType) {
        return this.streamOfType(beanType, null);
    }

    @NonNull
    default public <T> T getBean(@NonNull Class<T> beanType) {
        return this.getBean(beanType, null);
    }

    @NonNull
    default public <T> Optional<T> findBean(@NonNull Class<T> beanType) {
        return this.findBean(beanType, null);
    }

    @NonNull
    default public <T> Optional<T> findOrInstantiateBean(@NonNull Class<T> beanType) {
        Optional<T> bean2 = this.findBean(beanType, null);
        if (bean2.isPresent()) {
            return bean2;
        }
        return InstantiationUtils.tryInstantiate(beanType);
    }
}

