/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.asm.tree;

import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.TypePath;
import io.micronaut.asm.tree.LabelNode;
import io.micronaut.asm.tree.TypeAnnotationNode;
import io.micronaut.asm.tree.Util;
import java.util.List;

public class LocalVariableAnnotationNode
extends TypeAnnotationNode {
    public List<LabelNode> start;
    public List<LabelNode> end;
    public List<Integer> index;

    public LocalVariableAnnotationNode(int typeRef, TypePath typePath, LabelNode[] start, LabelNode[] end, int[] index2, String descriptor) {
        this(589824, typeRef, typePath, start, end, index2, descriptor);
    }

    public LocalVariableAnnotationNode(int api, int typeRef, TypePath typePath, LabelNode[] start, LabelNode[] end, int[] index2, String descriptor) {
        super(api, typeRef, typePath, descriptor);
        this.start = Util.asArrayList(start);
        this.end = Util.asArrayList(end);
        this.index = Util.asArrayList(index2);
    }

    public void accept(MethodVisitor methodVisitor, boolean visible) {
        Label[] startLabels = new Label[this.start.size()];
        Label[] endLabels = new Label[this.end.size()];
        int[] indices = new int[this.index.size()];
        int n = startLabels.length;
        for (int i2 = 0; i2 < n; ++i2) {
            startLabels[i2] = this.start.get(i2).getLabel();
            endLabels[i2] = this.end.get(i2).getLabel();
            indices[i2] = this.index.get(i2);
        }
        this.accept(methodVisitor.visitLocalVariableAnnotation(this.typeRef, this.typePath, startLabels, endLabels, indices, this.desc, visible));
    }
}

