/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.ConstructorInterceptor;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InterceptorRegistry;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.chain.AbstractInterceptorChain;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.naming.Described;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterceptorRegistry
implements InterceptorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final MethodInterceptor<?, ?>[] ZERO_METHOD_INTERCEPTORS = new MethodInterceptor[0];
    private final BeanContext beanContext;

    public DefaultInterceptorRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    @NonNull
    public <T> Interceptor<T, ?>[] resolveInterceptors(@NonNull Executable<T, ?> method, @NonNull Collection<BeanRegistration<Interceptor<T, ?>>> interceptors, @NonNull InterceptorKind interceptorKind) {
        AnnotationMetadata annotationMetadata = method.getAnnotationMetadata();
        if (interceptors.isEmpty()) {
            return this.resolveToNone((ExecutableMethod)method, interceptorKind, annotationMetadata);
        }
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, method);
        Collection<AnnotationValue<?>> applicableBindings = AbstractInterceptorChain.resolveInterceptorValues(annotationMetadata, interceptorKind);
        if (applicableBindings.isEmpty()) {
            return this.resolveToNone((ExecutableMethod)method, interceptorKind, annotationMetadata);
        }
        Interceptor[] resolvedInterceptors = (Interceptor[])this.interceptorStream(method.getDeclaringType(), interceptors, interceptorKind, applicableBindings).filter(bean2 -> bean2 instanceof MethodInterceptor || !(bean2 instanceof ConstructorInterceptor)).toArray(Interceptor[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for method: {} - {}", new Object[]{resolvedInterceptors.length, interceptorKind, interceptors.size(), method.getDeclaringType(), method instanceof Described ? ((Described)((Object)method)).getDescription(true) : method.toString()});
            for (int i2 = 0; i2 < resolvedInterceptors.length; ++i2) {
                Interceptor resolvedInterceptor = resolvedInterceptors[i2];
                LOG.trace("Interceptor {} - {}", (Object)i2, (Object)resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private Interceptor[] resolveToNone(ExecutableMethod<?, ?> method, InterceptorKind interceptorKind, AnnotationMetadata annotationMetadata) {
        if (interceptorKind == InterceptorKind.INTRODUCTION) {
            if (annotationMetadata.hasStereotype((Class<? extends Annotation>)Adapter.class)) {
                return new MethodInterceptor[]{new AdapterIntroduction(this.beanContext, method)};
            }
            throw new IllegalStateException("At least one @Introduction method interceptor required, but missing for method: " + method.getDescription(true) + ". Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @InterceptorBean(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
        }
        return ZERO_METHOD_INTERCEPTORS;
    }

    private <T, R> Stream<? extends Interceptor<T, R>> interceptorStream(Class<?> declaringType, Collection<BeanRegistration<Interceptor<T, R>>> interceptors, InterceptorKind interceptorKind, Collection<AnnotationValue<?>> applicableBindings) {
        return interceptors.stream().filter(beanRegistration -> {
            List<Argument<ConstructorInterceptor>> typeArgs = beanRegistration.getBeanDefinition().getTypeArguments(ConstructorInterceptor.class);
            if (typeArgs.isEmpty()) {
                return true;
            }
            Class applicableType = typeArgs.iterator().next().getType();
            return applicableType.isAssignableFrom(declaringType);
        }).filter(beanRegistration -> {
            Collection<AnnotationValue<?>> interceptorValues = AbstractInterceptorChain.resolveInterceptorValues(beanRegistration.getBeanDefinition().getAnnotationMetadata(), interceptorKind);
            if (interceptorValues.isEmpty()) {
                for (AnnotationValue applicableValue : applicableBindings) {
                    if (!this.isApplicableByType((BeanRegistration)beanRegistration, applicableValue)) continue;
                    return true;
                }
                return false;
            }
            if (interceptorValues.size() == 1) {
                AnnotationValue<?> interceptorBinding = interceptorValues.iterator().next();
                AnnotationValue memberBinding = interceptorBinding.getAnnotation("bindMembers").orElse(null);
                String annotationName = interceptorBinding.stringValue().orElse(null);
                if (annotationName != null) {
                    for (AnnotationValue applicableBinding : applicableBindings) {
                        if (this.isApplicableByType((BeanRegistration)beanRegistration, applicableBinding)) {
                            return true;
                        }
                        if (!annotationName.equals(applicableBinding.stringValue().orElse(null))) continue;
                        if (memberBinding != null) {
                            AnnotationValue otherMembers = applicableBinding.getAnnotation("bindMembers").orElse(null);
                            if (!memberBinding.equals(otherMembers)) continue;
                            return true;
                        }
                        return true;
                    }
                }
                return false;
            }
            boolean isApplicationByBinding = true;
            for (AnnotationValue annotationValue : applicableBindings) {
                AnnotationValue memberBinding = annotationValue.getAnnotation("bindMembers").orElse(null);
                String annotationName = annotationValue.stringValue().orElse(null);
                if (annotationName == null) continue;
                boolean interceptorApplicable = true;
                for (AnnotationValue<?> applicableValue : interceptorValues) {
                    if (this.isApplicableByType((BeanRegistration)beanRegistration, applicableValue)) {
                        return true;
                    }
                    if (annotationName.equals(applicableValue.stringValue().orElse(null))) {
                        if (memberBinding != null) {
                            AnnotationValue otherMembers = applicableValue.getAnnotation("bindMembers").orElse(null);
                            interceptorApplicable = memberBinding.equals(otherMembers);
                            if (!interceptorApplicable) continue;
                            break;
                        }
                        interceptorApplicable = true;
                        break;
                    }
                    interceptorApplicable = false;
                }
                if (isApplicationByBinding = interceptorApplicable) continue;
                break;
            }
            return isApplicationByBinding;
        }).sorted(OrderUtil.COMPARATOR).map(BeanRegistration::getBean);
    }

    private <T, R> boolean isApplicableByType(BeanRegistration<Interceptor<T, R>> beanRegistration, AnnotationValue<?> applicableValue) {
        return applicableValue.classValue("interceptorType").map(t -> t.isInstance(beanRegistration.getBean())).orElse(false);
    }

    @Override
    @NonNull
    public <T> Interceptor<T, T>[] resolveConstructorInterceptors(@NonNull BeanConstructor<T> constructor, @NonNull Collection<BeanRegistration<Interceptor<T, T>>> interceptors) {
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, constructor);
        Collection<AnnotationValue<?>> applicableBindings = AbstractInterceptorChain.resolveInterceptorValues(constructor.getAnnotationMetadata(), InterceptorKind.AROUND_CONSTRUCT);
        Interceptor[] resolvedInterceptors = (Interceptor[])this.interceptorStream(constructor.getDeclaringBeanType(), interceptors, InterceptorKind.AROUND_CONSTRUCT, applicableBindings).filter(bean2 -> bean2 instanceof ConstructorInterceptor || !(bean2 instanceof MethodInterceptor)).toArray(Interceptor[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for constructor: {} - {}", new Object[]{resolvedInterceptors.length, InterceptorKind.AROUND_CONSTRUCT, interceptors.size(), constructor.getDeclaringBeanType(), constructor.getDescription(true)});
            for (int i2 = 0; i2 < resolvedInterceptors.length; ++i2) {
                Interceptor resolvedInterceptor = resolvedInterceptors[i2];
                LOG.trace("Interceptor {} - {}", (Object)i2, (Object)resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, Object method) {
        EnvironmentConfigurable m;
        if (beanContext instanceof ApplicationContext && method instanceof EnvironmentConfigurable && (m = (EnvironmentConfigurable)method).hasPropertyExpressions()) {
            m.configure(((ApplicationContext)beanContext).getEnvironment());
        }
    }
}

