/*
 * Decompiled with CFR 0.152.
 */
package grails.web.servlet.context;

import grails.core.GrailsApplication;
import grails.spring.BeanBuilder;
import grails.web.servlet.context.support.GrailsEnvironment;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import org.grails.spring.GrailsApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.springframework.web.context.support.StandardServletEnvironment;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsWebApplicationContext
extends GrailsApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private String namespace;
    private ServletConfig servletConfig;
    private String[] configLocations = new String[0];
    private GrailsApplication grailsApplication;

    public GrailsWebApplicationContext() throws BeansException {
    }

    public GrailsWebApplicationContext(GrailsApplication grailsApplication) {
        this();
        this.grailsApplication = grailsApplication;
    }

    public GrailsWebApplicationContext(ApplicationContext parent) throws BeansException {
        super(parent);
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, GrailsApplication grailsApplication) {
        this(defaultListableBeanFactory);
        this.grailsApplication = grailsApplication;
    }

    public GrailsWebApplicationContext(ApplicationContext parent, GrailsApplication grailsApplication) throws BeansException {
        super(parent);
        this.grailsApplication = grailsApplication;
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory) {
        super(defaultListableBeanFactory);
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, ApplicationContext parent) {
        super(defaultListableBeanFactory, parent);
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, ApplicationContext parent, GrailsApplication grailsApplication) {
        super(defaultListableBeanFactory, parent);
        this.grailsApplication = grailsApplication;
    }

    @Override
    public ClassLoader getClassLoader() {
        GrailsApplication application2 = this.getGrailsApplication();
        return application2 == null ? super.getClassLoader() : application2.getClassLoader();
    }

    private GrailsApplication getGrailsApplication() {
        if (this.grailsApplication == null && this.containsBean("grailsApplication")) {
            this.grailsApplication = this.getBean("grailsApplication", GrailsApplication.class);
        }
        return this.grailsApplication;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setConfigLocation(String configLocation) {
        Assert.notNull((Object)configLocation, "Argument [configLocation] cannot be null");
        this.configLocations = new String[]{configLocation};
    }

    @Override
    public void setConfigLocations(String[] configLocations) {
        Assert.notNull((Object)configLocations, "Argument [configLocations] cannot be null");
        this.configLocations = configLocations;
    }

    @Override
    public String[] getConfigLocations() {
        return this.configLocations;
    }

    @Override
    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.registerResolvableDependency(ServletContext.class, this.servletContext);
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory);
    }

    @Override
    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    @Override
    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver(this);
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.configLocations.length > 0) {
            for (String configLocation : this.configLocations) {
                BeanBuilder beanBuilder = new BeanBuilder(this.getParent(), this.getClassLoader());
                ServletContextResource resource = new ServletContextResource(this.getServletContext(), configLocation);
                beanBuilder.loadBeans(resource);
                beanBuilder.registerBeans(this);
            }
        }
        super.prepareBeanFactory(beanFactory);
    }

    @Override
    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    protected ConfigurableEnvironment createEnvironment() {
        GrailsApplication grailsApplication = this.getGrailsApplication();
        return grailsApplication == null ? new StandardServletEnvironment() : new GrailsEnvironment(grailsApplication);
    }

    @Override
    public ConfigurableWebEnvironment getEnvironment() {
        ConfigurableEnvironment env = super.getEnvironment();
        Assert.isInstanceOf(ConfigurableWebEnvironment.class, (Object)env, "ConfigurableWebApplication environment must be of type ConfigurableWebEnvironment");
        return (ConfigurableWebEnvironment)env;
    }
}

