/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;

public final class BitCounter
implements BitmapStorage {
    private int oneBits;

    @Override
    public void addWord(long newData) {
        this.oneBits += Long.bitCount(newData);
    }

    @Override
    public void addLiteralWord(long newData) {
        this.oneBits += Long.bitCount(newData);
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int start, int number) {
        for (int i2 = start; i2 < start + number; ++i2) {
            this.addLiteralWord(buffer.getWord(i2));
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (v) {
            this.oneBits += (int)(number * 64L);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int start, int number) {
        for (int i2 = start; i2 < start + number; ++i2) {
            this.addLiteralWord(buffer.getWord(i2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.oneBits = 0;
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int bits) {
    }
}

