/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.SIA;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

class SIAW<K, V>
extends SIA<K, V> {
    static final LocalCacheFactory FACTORY = SIAW::new;
    protected static final VarHandle EXPIRES_AFTER_WRITE_NANOS;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
    volatile long expiresAfterWriteNanos;

    SIAW(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.setExpiresAfterWriteNanos(caffeine.getExpiresAfterWriteNanos());
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return EXPIRES_AFTER_WRITE_NANOS.getAcquire(this);
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        EXPIRES_AFTER_WRITE_NANOS.setRelease(this, l);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            EXPIRES_AFTER_WRITE_NANOS = lookup.findVarHandle(SIAW.class, "expiresAfterWriteNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

