/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.HashMap;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.DirectAuxHashMap;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectAuxHashMapTest {
    @Test
    public void checkGrow() {
        int lgConfigK = 4;
        TgtHllType tgtHllType = TgtHllType.HLL_4;
        int n = 8;
        long bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)tgtHllType);
        Arena arena = Arena.ofConfined();
        MemorySegment wseg = arena.allocate(bytes);
        HllSketch hllSketch = new HllSketch(4, tgtHllType, wseg);
        for (int i = 0; i < 8; ++i) {
            hllSketch.update((long)i);
        }
        hllSketch.couponUpdate(HllUtil.pair((int)7, (int)15));
        hllSketch.couponUpdate(HllUtil.pair((int)8, (int)15));
        hllSketch.couponUpdate(HllUtil.pair((int)9, (int)15));
        DirectAuxHashMapTest.println(hllSketch.toString(true, true, true, true));
        DirectHllArray dha = (DirectHllArray)hllSketch.hllSketchImpl;
        Assert.assertEquals((int)dha.getAuxHashMap().getLgAuxArrInts(), (int)2);
        Assert.assertTrue((boolean)hllSketch.hasMemorySegment());
        Assert.assertTrue((boolean)hllSketch.isOffHeap());
        Assert.assertTrue((boolean)hllSketch.isSameResource(wseg));
        byte[] byteArray = hllSketch.toCompactByteArray();
        HllSketch hllSketch2 = HllSketch.heapify((byte[])byteArray);
        HllArray ha = (HllArray)hllSketch2.hllSketchImpl;
        Assert.assertEquals((int)ha.getAuxHashMap().getLgAuxArrInts(), (int)2);
        Assert.assertEquals((int)ha.getAuxHashMap().getAuxCount(), (int)3);
        byteArray = hllSketch.toUpdatableByteArray();
        MemorySegment wseg2 = MemorySegment.ofArray(byteArray);
        hllSketch2 = HllSketch.writableWrap((MemorySegment)wseg2);
        DirectAuxHashMapTest.println(hllSketch2.toString(true, true, true, true));
        DirectHllArray dha2 = (DirectHllArray)hllSketch2.hllSketchImpl;
        Assert.assertEquals((int)dha2.getAuxHashMap().getLgAuxArrInts(), (int)2);
        Assert.assertEquals((int)dha2.getAuxHashMap().getAuxCount(), (int)3);
        hllSketch.couponUpdate(HllUtil.pair((int)10, (int)15));
        DirectAuxHashMapTest.println(hllSketch.toString(true, true, true, true));
        dha = (DirectHllArray)hllSketch.hllSketchImpl;
        Assert.assertEquals((int)dha.getAuxHashMap().getLgAuxArrInts(), (int)3);
        Assert.assertEquals((int)dha.getAuxHashMap().getAuxCount(), (int)4);
        Assert.assertTrue((boolean)hllSketch.hasMemorySegment());
        Assert.assertFalse((boolean)hllSketch.isOffHeap());
        Assert.assertFalse((boolean)hllSketch.isSameResource(wseg));
        arena.close();
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void checkDiffToByteArr() {
        int lgK = 12;
        int lgU = 19;
        TgtHllType type = TgtHllType.HLL_4;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)12, (TgtHllType)type);
        byte[] segByteArr = new byte[bytes];
        MemorySegment wseg = MemorySegment.ofArray(segByteArr);
        HllSketch heapSk = new HllSketch(12, type);
        HllSketch dirSk = new HllSketch(12, type, wseg);
        for (int i = 0; i < 524288; ++i) {
            heapSk.update((long)i);
            dirSk.update((long)i);
        }
        AbstractHllArray heapHllArr = (AbstractHllArray)heapSk.hllSketchImpl;
        AbstractHllArray dirHllArr = (AbstractHllArray)dirSk.hllSketchImpl;
        assert (dirHllArr instanceof DirectHllArray);
        AuxHashMap heapAux = heapHllArr.getAuxHashMap();
        assert (heapAux instanceof HeapAuxHashMap);
        AuxHashMap dirAux = dirHllArr.getAuxHashMap();
        assert (dirAux instanceof DirectAuxHashMap);
        DirectAuxHashMapTest.println("HeapAuxCount: " + heapAux.getAuxCount());
        DirectAuxHashMapTest.println("DirAuxCount: " + dirAux.getAuxCount());
        int heapCurMin = heapHllArr.getCurMin();
        int dirCurMin = dirHllArr.getCurMin();
        DirectAuxHashMapTest.println("HeapCurMin: " + heapCurMin);
        DirectAuxHashMapTest.println("DirCurMin: " + dirCurMin);
        PairIterator auxItr = heapHllArr.getAuxIterator();
        DirectAuxHashMapTest.println("\nHeap Pairs");
        while (auxItr.nextValid()) {
            DirectAuxHashMapTest.println("" + auxItr.getPair());
        }
        auxItr = dirHllArr.getAuxIterator();
        DirectAuxHashMapTest.println("\nDirect Pairs");
        while (auxItr.nextValid()) {
            DirectAuxHashMapTest.println("" + auxItr.getPair());
        }
        PairIterator hllItr = heapSk.iterator();
        DirectAuxHashMapTest.println("Heap HLL arr");
        DirectAuxHashMapTest.println(hllItr.getHeader());
        while (hllItr.nextValid()) {
            if (hllItr.getValue() - heapCurMin <= 14) continue;
            DirectAuxHashMapTest.println(hllItr.getString() + ", " + hllItr.getPair());
        }
        hllItr = dirSk.iterator();
        DirectAuxHashMapTest.println("Direct HLL arr");
        DirectAuxHashMapTest.println(hllItr.getHeader());
        while (hllItr.nextValid()) {
            if (hllItr.getValue() - dirCurMin <= 14) continue;
            DirectAuxHashMapTest.println(hllItr.getString() + ", " + hllItr.getPair());
        }
        byte[] heapImg = heapSk.toUpdatableByteArray();
        MemorySegment heapImgSeg = MemorySegment.ofArray(heapImg);
        byte[] dirImg = dirSk.toUpdatableByteArray();
        MemorySegment dirImgSeg = MemorySegment.ofArray(dirImg);
        DirectAuxHashMapTest.println("heapLen: " + heapImg.length + ", dirLen: " + dirImg.length + ", segObjLen: " + segByteArr.length);
        int auxStart = 2088;
        DirectAuxHashMapTest.println("AuxStart: 2088");
        DirectAuxHashMapTest.println(String.format("%14s%14s%14s", "dir wseg", "heap to b[]", "direct to b[]"));
        for (int i = 2088; i < heapImg.length; i += 4) {
            DirectAuxHashMapTest.println(String.format("%14d%14d%14d", wseg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)i), heapImgSeg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)i), dirImgSeg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)i)));
            assert (segByteArr[i] == heapImg[i]);
            assert (heapImg[i] == dirImg[i]) : "i: " + i;
        }
        Assert.assertEquals((byte[])heapImg, (byte[])dirImg);
    }

    @Test
    public void exerciseHeapAndDirectAux() {
        DirectAuxHashMapTest.initSketchAndMap(true, true);
        DirectAuxHashMapTest.initSketchAndMap(false, true);
        DirectAuxHashMapTest.initSketchAndMap(true, false);
        DirectAuxHashMapTest.initSketchAndMap(false, false);
    }

    static void initSketchAndMap(boolean direct, boolean compact) {
        HllSketch sketch;
        int lgK = 15;
        int lgU = 20;
        DirectAuxHashMapTest.println("HLL_4, lgK: 15, lgU: 20");
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (direct) {
            int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)15, (TgtHllType)TgtHllType.HLL_4);
            MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
            sketch = new HllSketch(15, TgtHllType.HLL_4, wseg);
        } else {
            sketch = new HllSketch(15, TgtHllType.HLL_4);
        }
        for (int i = 0; i < 0x100000; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((int)sketch.getUpdatableSerializationBytes(), (int)(16424 + (4 << HllUtil.LG_AUX_ARR_INTS[15])));
        AbstractHllArray absDirectHllArr = (AbstractHllArray)sketch.hllSketchImpl;
        AuxHashMap auxMap = absDirectHllArr.getAuxHashMap();
        int auxCount = auxMap.getAuxCount();
        Assert.assertEquals((int)auxMap.getCompactSizeBytes(), (int)(auxCount << 2));
        int auxArrInts = 1 << auxMap.getLgAuxArrInts();
        Assert.assertEquals((int)auxMap.getUpdatableSizeBytes(), (int)(auxArrInts << 2));
        PairIterator itr = absDirectHllArr.getAuxIterator();
        DirectAuxHashMapTest.println("Source Aux Array.");
        DirectAuxHashMapTest.println(itr.getHeader());
        while (itr.nextValid()) {
            map.put(itr.getSlot(), itr.getValue());
            DirectAuxHashMapTest.println(itr.getString());
        }
        double est = sketch.getEstimate();
        DirectAuxHashMapTest.println("\nHLL Array of original sketch: should match Source Aux Array.");
        DirectAuxHashMapTest.checkHllArr(sketch, map);
        byte[] byteArr = compact ? sketch.toCompactByteArray() : sketch.toUpdatableByteArray();
        HllSketch heapSk = HllSketch.heapify((MemorySegment)MemorySegment.ofArray(byteArr));
        Assert.assertEquals((double)heapSk.getEstimate(), (double)est, (double)0.0);
        DirectAuxHashMapTest.println("\nAux Array of heapified serialized sketch.");
        DirectAuxHashMapTest.checkAux(heapSk, map);
        DirectAuxHashMapTest.println("\nHLL Array of heapified serialized sketch.");
        DirectAuxHashMapTest.checkHllArr(heapSk, map);
        HllSketch wrapSk = HllSketch.wrap((MemorySegment)MemorySegment.ofArray(byteArr));
        Assert.assertEquals((double)wrapSk.getEstimate(), (double)est, (double)0.0);
        DirectAuxHashMapTest.println("\nAux Array of wrapped RO serialized sketch.");
        DirectAuxHashMapTest.checkAux(wrapSk, map);
        DirectAuxHashMapTest.println("\nHLL Array of wrapped RO serialized sketch.");
        DirectAuxHashMapTest.checkHllArr(wrapSk, map);
        DirectAuxHashMapTest.println(wrapSk.toString(false, false, true, true));
    }

    static void checkHllArr(HllSketch sk, HashMap<Integer, Integer> map) {
        AbstractHllArray absHllArr = (AbstractHllArray)sk.hllSketchImpl;
        int curMin = absHllArr.getCurMin();
        PairIterator hllArrItr = sk.iterator();
        DirectAuxHashMapTest.println(hllArrItr.getHeader());
        while (hllArrItr.nextValid()) {
            int hllArrVal = hllArrItr.getValue();
            if (hllArrItr.getValue() - curMin <= 14) continue;
            int mapVal = map.get(hllArrItr.getSlot());
            DirectAuxHashMapTest.println(hllArrItr.getString());
            Assert.assertEquals((int)hllArrVal, (int)mapVal);
        }
    }

    static void checkAux(HllSketch sk, HashMap<Integer, Integer> map) {
        AbstractHllArray absHllArr = (AbstractHllArray)sk.hllSketchImpl;
        PairIterator heapAuxItr = absHllArr.getAuxIterator();
        DirectAuxHashMapTest.println(heapAuxItr.getHeader());
        while (heapAuxItr.nextValid()) {
            int afterVal = heapAuxItr.getValue();
            if (afterVal <= 14) continue;
            DirectAuxHashMapTest.println(heapAuxItr.getString());
            int auxSlot = heapAuxItr.getSlot();
            assert (map.containsKey(auxSlot));
            int beforeVal = map.get(heapAuxItr.getSlot());
            Assert.assertEquals((int)afterVal, (int)beforeVal);
        }
    }

    @Test
    public void checkDirectReadOnlyCompactAux() {
        int lgK = 15;
        int lgU = 20;
        HllSketch sk = new HllSketch(15, TgtHllType.HLL_4);
        for (int i = 0; i < 0x100000; ++i) {
            sk.update((long)i);
        }
    }

    @Test
    public void checkMustReplace() {
        int lgK = 7;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)7, (TgtHllType)TgtHllType.HLL_4);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        HllSketch sk = new HllSketch(7, TgtHllType.HLL_4, wseg);
        for (int i = 0; i < 25; ++i) {
            sk.update((long)i);
        }
        DirectHllArray dHllArr = (DirectHllArray)sk.hllSketchImpl;
        AuxHashMap map = dHllArr.getNewAuxHashMap();
        map.mustAdd(100, 5);
        int val = map.mustFindValueFor(100);
        Assert.assertEquals((int)val, (int)5);
        map.mustReplace(100, 10);
        val = map.mustFindValueFor(100);
        Assert.assertEquals((int)val, (int)10);
        Assert.assertTrue((boolean)map.hasMemorySegment());
        Assert.assertFalse((boolean)map.isOffHeap());
        Assert.assertNull((Object)map.copy());
        Assert.assertNull((Object)map.getAuxIntArr());
        try {
            map.mustAdd(100, 12);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            map.mustFindValueFor(101);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            map.mustReplace(101, 5);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    static void println(String s) {
    }
}

