/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;

public class BitsCharsetDecoderUTF32LE
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte4 = this.getByte(dis, 0);
        int byte3 = this.getByte(dis, 8);
        int byte2 = this.getByte(dis, 16);
        int byte1 = this.getByte(dis, 24);
        int cp = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        if (cp >= 0 && cp <= 65535) {
            return (char)cp;
        }
        if (cp <= 0x10FFFF) {
            char high = Character.highSurrogate(cp);
            this.setLowSurrogate(Character.lowSurrogate(cp));
            return high;
        }
        throw new BitsCharsetDecoderMalformedException(32);
    }
}

