/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.BaseBearing;
import org.opensaml.core.xml.IdBearing;
import org.opensaml.core.xml.LangBearing;
import org.opensaml.core.xml.SpaceBearing;
import org.opensaml.core.xml.XMLObject;

public final class XMLAttributeSupport {
    private XMLAttributeSupport() {
    }

    public static void addXMLId(@Nonnull XMLObject xmlObject, @Nullable String id) {
        if (xmlObject instanceof IdBearing) {
            IdBearing downcast = (IdBearing)((Object)xmlObject);
            downcast.setXMLId(id);
        } else if (xmlObject instanceof AttributeExtensibleXMLObject) {
            AttributeExtensibleXMLObject downcast = (AttributeExtensibleXMLObject)xmlObject;
            downcast.getUnknownAttributes().put(IdBearing.XML_ID_ATTR_NAME, id);
        } else {
            throw new IllegalArgumentException("Specified object was neither IdBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getXMLId(@Nonnull XMLObject xmlObject) {
        Object downcast;
        String value;
        if (xmlObject instanceof IdBearing && (value = StringSupport.trimOrNull((String)(downcast = (IdBearing)((Object)xmlObject)).getXMLId())) != null) {
            return value;
        }
        if (xmlObject instanceof AttributeExtensibleXMLObject) {
            downcast = (AttributeExtensibleXMLObject)xmlObject;
            return StringSupport.trimOrNull((String)downcast.getUnknownAttributes().get(IdBearing.XML_ID_ATTR_NAME));
        }
        return null;
    }

    public static void addXMLLang(@Nonnull XMLObject xmlObject, @Nullable String lang) {
        if (xmlObject instanceof LangBearing) {
            LangBearing downcast = (LangBearing)((Object)xmlObject);
            downcast.setXMLLang(lang);
        } else if (xmlObject instanceof AttributeExtensibleXMLObject) {
            AttributeExtensibleXMLObject downcast = (AttributeExtensibleXMLObject)xmlObject;
            downcast.getUnknownAttributes().put(LangBearing.XML_LANG_ATTR_NAME, lang);
        } else {
            throw new IllegalArgumentException("Specified object was neither LangBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getXMLLang(@Nonnull XMLObject xmlObject) {
        Object downcast;
        String value = null;
        if (xmlObject instanceof LangBearing && (value = StringSupport.trimOrNull((String)(downcast = (LangBearing)((Object)xmlObject)).getXMLLang())) != null) {
            return value;
        }
        if (xmlObject instanceof AttributeExtensibleXMLObject) {
            downcast = (AttributeExtensibleXMLObject)xmlObject;
            value = StringSupport.trimOrNull((String)downcast.getUnknownAttributes().get(LangBearing.XML_LANG_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addXMLBase(@Nonnull XMLObject xmlObject, @Nullable String base) {
        if (xmlObject instanceof BaseBearing) {
            BaseBearing downcast = (BaseBearing)((Object)xmlObject);
            downcast.setXMLBase(base);
        } else if (xmlObject instanceof AttributeExtensibleXMLObject) {
            AttributeExtensibleXMLObject downcast = (AttributeExtensibleXMLObject)xmlObject;
            downcast.getUnknownAttributes().put(BaseBearing.XML_BASE_ATTR_NAME, base);
        } else {
            throw new IllegalArgumentException("Specified object was neither BaseBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getXMLBase(@Nonnull XMLObject xmlObject) {
        Object downcast;
        String value = null;
        if (xmlObject instanceof BaseBearing && (value = StringSupport.trimOrNull((String)(downcast = (BaseBearing)((Object)xmlObject)).getXMLBase())) != null) {
            return value;
        }
        if (xmlObject instanceof AttributeExtensibleXMLObject) {
            downcast = (AttributeExtensibleXMLObject)xmlObject;
            value = StringSupport.trimOrNull((String)downcast.getUnknownAttributes().get(BaseBearing.XML_BASE_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addXMLSpace(@Nonnull XMLObject xmlObject, @Nonnull SpaceBearing.XMLSpaceEnum space) {
        if (xmlObject instanceof SpaceBearing) {
            SpaceBearing downcast = (SpaceBearing)((Object)xmlObject);
            downcast.setXMLSpace(space);
        } else if (xmlObject instanceof AttributeExtensibleXMLObject) {
            AttributeExtensibleXMLObject downcast = (AttributeExtensibleXMLObject)xmlObject;
            downcast.getUnknownAttributes().put(SpaceBearing.XML_SPACE_ATTR_NAME, space.toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither SpaceBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static SpaceBearing.XMLSpaceEnum getXMLSpace(@Nonnull XMLObject xmlObject) {
        AttributeExtensibleXMLObject downcast;
        SpaceBearing downcast2;
        SpaceBearing.XMLSpaceEnum valueEnum = null;
        if (xmlObject instanceof SpaceBearing && (valueEnum = (downcast2 = (SpaceBearing)((Object)xmlObject)).getXMLSpace()) != null) {
            return valueEnum;
        }
        String valueString = null;
        if (xmlObject instanceof AttributeExtensibleXMLObject && (valueString = StringSupport.trimOrNull((String)(downcast = (AttributeExtensibleXMLObject)xmlObject).getUnknownAttributes().get(SpaceBearing.XML_SPACE_ATTR_NAME))) != null) {
            return SpaceBearing.XMLSpaceEnum.parseValue(valueString);
        }
        return null;
    }
}

