/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage;

public class NullResponseMessage_V2
extends NullResponseMessage {
    private long correlationID;

    public NullResponseMessage_V2(long correlationID) {
        this.correlationID = correlationID;
    }

    public NullResponseMessage_V2() {
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void setCorrelationID(long correlationID) {
        this.correlationID = correlationID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readableBytes() >= 8 ? buffer.readLong() : -1L;
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + 8;
    }

    @Override
    public final boolean isResponse() {
        return true;
    }

    @Override
    public final boolean isResponseAsync() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.correlationID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NullResponseMessage_V2)) {
            return false;
        }
        NullResponseMessage_V2 other = (NullResponseMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }

    @Override
    public void reset() {
        super.reset();
        this.correlationID = 0L;
    }
}

