/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentCacheConfigurationBuilder;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class CoreConfigurationBuilder<B extends CoreConfigurationBuilder<B>>
implements FluentConfigurationBuilder<B> {
    private final Map<String, CacheConfiguration<?, ?>> caches;
    private final Collection<ServiceCreationConfiguration<?, ?>> serviceConfigurations;
    private final ClassLoader classLoader;

    protected static CoreConfigurationBuilder<?> newConfigurationBuilder(Configuration seed) {
        return new CoreConfigurationBuilder(new CoreConfigurationBuilder(new CoreConfigurationBuilder(new CoreConfigurationBuilder(), seed.getCacheConfigurations()), seed.getServiceCreationConfigurations()), seed.getClassLoader());
    }

    protected CoreConfigurationBuilder() {
        this.caches = Collections.emptyMap();
        this.serviceConfigurations = Collections.emptyList();
        this.classLoader = null;
    }

    protected CoreConfigurationBuilder(CoreConfigurationBuilder<?> builder, Map<String, CacheConfiguration<?, ?>> caches) {
        this.caches = Collections.unmodifiableMap(caches);
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = builder.classLoader;
    }

    protected CoreConfigurationBuilder(CoreConfigurationBuilder<?> builder, Collection<ServiceCreationConfiguration<?, ?>> serviceConfigurations) {
        this.caches = builder.caches;
        this.serviceConfigurations = Collections.unmodifiableCollection(serviceConfigurations);
        this.classLoader = builder.classLoader;
    }

    protected CoreConfigurationBuilder(CoreConfigurationBuilder<?> builder, ClassLoader classLoader) {
        this.caches = builder.caches;
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = classLoader;
    }

    @Override
    public Configuration build() {
        return new DefaultConfiguration(this.caches, this.classLoader, this.serviceConfigurations.toArray(new ServiceCreationConfiguration[this.serviceConfigurations.size()]));
    }

    @Override
    public CacheConfiguration<?, ?> getCache(String alias) {
        return this.caches.get(alias);
    }

    @Override
    public B withCache(String alias, CacheConfiguration<?, ?> config) {
        HashMap newCaches = new HashMap(this.caches);
        newCaches.put(alias, config);
        return this.newBuilderWith(newCaches);
    }

    @Override
    public B withoutCache(String alias) {
        HashMap newCaches = new HashMap(this.caches);
        newCaches.remove(alias);
        return this.newBuilderWith(newCaches);
    }

    @Override
    public B updateCache(String alias, UnaryOperator<FluentCacheConfigurationBuilder<?, ?, ?>> update) {
        CacheConfiguration<?, ?> existing = this.getCache(alias);
        if (existing == null) {
            throw new IllegalArgumentException("Cache does not exist");
        }
        return (B)this.withCache(alias, (CacheConfiguration)((FluentCacheConfigurationBuilder)update.apply(existing.derive())).build());
    }

    @Override
    public B updateCaches(UnaryOperator<FluentCacheConfigurationBuilder<?, ?, ?>> update) {
        return this.newBuilderWith(this.caches.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FluentCacheConfigurationBuilder)update.apply(((CacheConfiguration)e.getValue()).derive())).build())));
    }

    @Override
    public <C extends ServiceCreationConfiguration<?, ?>> Collection<C> getServices(Class<C> configurationType) {
        return this.serviceConfigurations.stream().filter(service -> configurationType.isAssignableFrom(service.getClass())).map(configurationType::cast).collect(Collectors.toList());
    }

    @Override
    public B withService(ServiceCreationConfiguration<?, ?> config) {
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.removeIf(other -> !other.compatibleWith(config) || !config.compatibleWith((ServiceCreationConfiguration<?, ?>)other));
        newServiceConfigurations.add(config);
        return this.newBuilderWith(newServiceConfigurations);
    }

    @Override
    public <C extends ServiceCreationConfiguration<?, ?>> B withoutServices(Class<C> clazz, Predicate<? super C> predicate) {
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.removeIf(c -> clazz.isInstance(c) && predicate.test((Object)clazz.cast(c)));
        return this.newBuilderWith(newServiceConfigurations);
    }

    @Override
    public <R, C extends ServiceCreationConfiguration<?, R>> B updateServices(Class<C> clazz, UnaryOperator<R> update) {
        Collection<C> existing = this.getServices(clazz);
        if (existing.isEmpty()) {
            throw new IllegalStateException("Cannot updates service configurations. No services exist");
        }
        FluentConfigurationBuilder<B> otherBuilder = (CoreConfigurationBuilder)this.withoutServices(clazz);
        for (ServiceCreationConfiguration configuration : existing) {
            ServiceCreationConfiguration replacement = configuration.build(update.apply(configuration.derive()));
            if (replacement == null) {
                throw new NullPointerException(configuration.getClass().getSimpleName() + ".build(...) returned a null configuration instance");
            }
            otherBuilder = otherBuilder.withService(replacement);
        }
        return (B)otherBuilder;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public B withClassLoader(ClassLoader classLoader) {
        return this.newBuilderWith(Objects.requireNonNull(classLoader));
    }

    @Override
    public B withDefaultClassLoader() {
        return this.newBuilderWith((ClassLoader)null);
    }

    protected B newBuilderWith(Map<String, CacheConfiguration<?, ?>> caches) {
        if (this.getClass().equals(CoreConfigurationBuilder.class)) {
            return (B)new CoreConfigurationBuilder<B>(this, caches);
        }
        throw new AssertionError();
    }

    protected B newBuilderWith(Collection<ServiceCreationConfiguration<?, ?>> serviceConfigurations) {
        if (this.getClass().equals(CoreConfigurationBuilder.class)) {
            return (B)new CoreConfigurationBuilder<B>(this, serviceConfigurations);
        }
        throw new AssertionError();
    }

    protected B newBuilderWith(ClassLoader classLoader) {
        if (this.getClass().equals(CoreConfigurationBuilder.class)) {
            return (B)new CoreConfigurationBuilder<B>(this, classLoader);
        }
        throw new AssertionError();
    }
}

