/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.parser.ASTScalar;

public class ASTNamedParameter
extends ASTScalar {
    private static final long serialVersionUID = -3965588358977704022L;

    ASTNamedParameter(int id) {
        super(id);
    }

    public ASTNamedParameter() {
        super(56);
    }

    public ASTNamedParameter(Object value) {
        super(56);
        this.setValue(value);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        throw new ExpressionException("Uninitialized parameter: " + this.value + ", call 'expWithParameters' first.", new Object[0]);
    }

    @Override
    public Expression shallowCopy() {
        ASTNamedParameter copy = new ASTNamedParameter(this.id);
        copy.value = this.value;
        return copy;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new ExpressionException("Null Parameter value", new Object[0]);
        }
        String name = value.toString().trim();
        if (name.length() == 0) {
            throw new ExpressionException("Empty Parameter value", new Object[0]);
        }
        super.setValue(new ExpressionParameter(name));
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        String valueString;
        if (this.value != null && (valueString = this.value.toString()).length() > 1 && valueString.charAt(0) == '$') {
            out.append(':');
            out.append(valueString.substring(1));
            return;
        }
        super.appendAsEJBQL(parameterAccumulator, out, rootId);
    }
}

