/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Extract text and data from documents using AWS Textract and AWS SDK version
 * 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Textract2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Textract component.
     */
    public interface Textract2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTextract2EndpointBuilder advanced() {
            return (AdvancedTextract2EndpointBuilder) this;
        }

        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.textract.Textract2Operations</code> type.
         * 
         * Required: true
         * Default: detectDocumentText
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder operation(org.apache.camel.component.aws2.textract.Textract2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.textract.Textract2Operations</code> type.
         * 
         * Required: true
         * Default: detectDocumentText
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The region in which Textract client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The S3 bucket name for document location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param s3Bucket the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder s3Bucket(String s3Bucket) {
            doSetProperty("s3Bucket", s3Bucket);
            return this;
        }
        /**
         * The S3 object name for document location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param s3Object the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder s3Object(String s3Object) {
            doSetProperty("s3Object", s3Object);
            return this;
        }
        /**
         * The S3 object version for document location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param s3ObjectVersion the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder s3ObjectVersion(String s3ObjectVersion) {
            doSetProperty("s3ObjectVersion", s3ObjectVersion);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Textract client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Textract client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Textract client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Textract client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Textract client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the Textract client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Textract client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Textract client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Textract client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Textract client should expect to use Session
         * Credentials. This is useful in situation in which the user needs to
         * assume a IAM role for doing operations in Textract.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Textract client should expect to use Session
         * Credentials. This is useful in situation in which the user needs to
         * assume a IAM role for doing operations in Textract.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Textract2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Textract component.
     */
    public interface AdvancedTextract2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Textract2EndpointBuilder basic() {
            return (Textract2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTextract2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTextract2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AWS Textract client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.textract.TextractClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param textractClient the value to set
         * @return the dsl builder
         */
        default AdvancedTextract2EndpointBuilder textractClient(software.amazon.awssdk.services.textract.TextractClient textractClient) {
            doSetProperty("textractClient", textractClient);
            return this;
        }
        /**
         * To use an existing configured AWS Textract client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.textract.TextractClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param textractClient the value to set
         * @return the dsl builder
         */
        default AdvancedTextract2EndpointBuilder textractClient(String textractClient) {
            doSetProperty("textractClient", textractClient);
            return this;
        }
    }

    public interface Textract2Builders {
        /**
         * AWS Textract (camel-aws2-textract)
         * Extract text and data from documents using AWS Textract and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,document
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-textract
         * 
         * @return the dsl builder for the headers' name.
         */
        default Textract2HeaderNameBuilder aws2Textract() {
            return Textract2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Textract (camel-aws2-textract)
         * Extract text and data from documents using AWS Textract and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,document
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-textract
         * 
         * Syntax: <code>aws2-textract:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Textract2EndpointBuilder aws2Textract(String path) {
            return Textract2EndpointBuilderFactory.endpointBuilder("aws2-textract", path);
        }
        /**
         * AWS Textract (camel-aws2-textract)
         * Extract text and data from documents using AWS Textract and AWS SDK
         * version 2.x.
         * 
         * Category: cloud,document
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-textract
         * 
         * Syntax: <code>aws2-textract:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Textract2EndpointBuilder aws2Textract(String componentName, String path) {
            return Textract2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Textract component.
     */
    public static class Textract2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Textract2HeaderNameBuilder INSTANCE = new Textract2HeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractOperation}.
         */
        public String awsTextractOperation() {
            return "CamelAwsTextractOperation";
        }
        /**
         * The S3 bucket name containing the document to process.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractS3Bucket}.
         */
        public String awsTextractS3Bucket() {
            return "CamelAwsTextractS3Bucket";
        }
        /**
         * The S3 object name (key) of the document to process.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractS3Object}.
         */
        public String awsTextractS3Object() {
            return "CamelAwsTextractS3Object";
        }
        /**
         * The S3 object version of the document to process.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractS3ObjectVersion}.
         */
        public String awsTextractS3ObjectVersion() {
            return "CamelAwsTextractS3ObjectVersion";
        }
        /**
         * The job ID for async operations (StartDocumentTextDetection,
         * StartDocumentAnalysis).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractJobId}.
         */
        public String awsTextractJobId() {
            return "CamelAwsTextractJobId";
        }
        /**
         * The maximum number of results to return in paginated operations.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractMaxResults}.
         */
        public String awsTextractMaxResults() {
            return "CamelAwsTextractMaxResults";
        }
        /**
         * The next token for pagination in operations that return multiple
         * pages.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractNextToken}.
         */
        public String awsTextractNextToken() {
            return "CamelAwsTextractNextToken";
        }
        /**
         * The feature types for document analysis (TABLES, FORMS, SIGNATURES,
         * etc.).
         * 
         * The option is a: {@code List<FeatureType>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTextractFeatureTypes}.
         */
        public String awsTextractFeatureTypes() {
            return "CamelAwsTextractFeatureTypes";
        }
    }
    static Textract2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Textract2EndpointBuilderImpl extends AbstractEndpointBuilder implements Textract2EndpointBuilder, AdvancedTextract2EndpointBuilder {
            public Textract2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Textract2EndpointBuilderImpl(path);
    }
}